/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.msnconstants;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.util.Logger;

public class MsnStatusEnum
extends PresenceStatus {
    private static Logger logger = Logger.getLogger(MsnStatusEnum.class);
    public static final MsnStatusEnum ONLINE = new MsnStatusEnum(65, "Online", MsnStatusEnum.loadIcon("resources/images/protocol/msn/msn16x16-online.png"));
    public static final MsnStatusEnum AWAY = new MsnStatusEnum(48, "Away", MsnStatusEnum.loadIcon("resources/images/protocol/msn/msn16x16-away.png"));
    public static final MsnStatusEnum IDLE = new MsnStatusEnum(46, "Idle", MsnStatusEnum.loadIcon("resources/images/protocol/msn/msn16x16-na.png"));
    public static final MsnStatusEnum HIDE = new MsnStatusEnum(45, "Hide", MsnStatusEnum.loadIcon("resources/images/protocol/msn/msn16x16-invisible.png"));
    public static final MsnStatusEnum OUT_TO_LUNCH = new MsnStatusEnum(39, "Out to lunch", MsnStatusEnum.loadIcon("resources/images/protocol/msn/msn16x16-lunch.png"));
    public static final MsnStatusEnum BE_RIGHT_BACK = new MsnStatusEnum(35, "Be Right Back", MsnStatusEnum.loadIcon("resources/images/protocol/msn/msn16x16-brb.png"));
    public static final MsnStatusEnum ON_THE_PHONE = new MsnStatusEnum(31, "On the phone", MsnStatusEnum.loadIcon("resources/images/protocol/msn/msn16x16-phone.png"));
    public static final MsnStatusEnum BUSY = new MsnStatusEnum(30, "Busy", MsnStatusEnum.loadIcon("resources/images/protocol/msn/msn16x16-busy.png"));
    public static final MsnStatusEnum OFFLINE = new MsnStatusEnum(0, "Offline", MsnStatusEnum.loadIcon("resources/images/protocol/msn/msn16x16-offline.png"));
    public static final ArrayList<MsnStatusEnum> msnStatusSet = new ArrayList();

    static {
        msnStatusSet.add(OUT_TO_LUNCH);
        msnStatusSet.add(ON_THE_PHONE);
        msnStatusSet.add(ONLINE);
        msnStatusSet.add(OFFLINE);
        msnStatusSet.add(IDLE);
        msnStatusSet.add(HIDE);
        msnStatusSet.add(BUSY);
        msnStatusSet.add(BE_RIGHT_BACK);
        msnStatusSet.add(AWAY);
    }

    protected MsnStatusEnum(int status, String statusName, byte[] statusIcon) {
        super(status, statusName, statusIcon);
    }

    public static byte[] loadIcon(String imagePath) {
        InputStream is = MsnStatusEnum.class.getClassLoader().getResourceAsStream(imagePath);
        if (is == null) {
            return null;
        }
        byte[] icon = null;
        try {
            icon = new byte[is.available()];
            is.read(icon);
        }
        catch (IOException exc) {
            logger.error((Object)("Failed to load icon: " + imagePath), (Throwable)exc);
        }
        return icon;
    }
}

