/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.geolocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import net.java.sip.communicator.impl.protocol.jabber.extensions.geolocation.GeolocationPacketExtension;
import net.java.sip.communicator.util.Logger;

public class GeolocationJabberUtils {
    private static final Logger logger = Logger.getLogger(GeolocationJabberUtils.class);

    public static Map<String, String> convertExtensionToMap(GeolocationPacketExtension geolocExt) {
        Hashtable<String, String> geolocMap = new Hashtable<String, String>();
        GeolocationJabberUtils.addFloatToMap(geolocMap, "alt", geolocExt.getAlt());
        GeolocationJabberUtils.addStringToMap(geolocMap, "area", geolocExt.getArea());
        GeolocationJabberUtils.addFloatToMap(geolocMap, "bearing", geolocExt.getBearing());
        GeolocationJabberUtils.addStringToMap(geolocMap, "building", geolocExt.getBuilding());
        GeolocationJabberUtils.addStringToMap(geolocMap, "country", geolocExt.getCountry());
        GeolocationJabberUtils.addStringToMap(geolocMap, "datum", geolocExt.getDatum());
        GeolocationJabberUtils.addStringToMap(geolocMap, "description", geolocExt.getDescription());
        GeolocationJabberUtils.addFloatToMap(geolocMap, "error", geolocExt.getError());
        GeolocationJabberUtils.addStringToMap(geolocMap, "floor", geolocExt.getFloor());
        GeolocationJabberUtils.addFloatToMap(geolocMap, "lat", geolocExt.getLat());
        GeolocationJabberUtils.addStringToMap(geolocMap, "locality", geolocExt.getLocality());
        GeolocationJabberUtils.addFloatToMap(geolocMap, "lon", geolocExt.getLon());
        GeolocationJabberUtils.addStringToMap(geolocMap, "postalcode", geolocExt.getPostalCode());
        GeolocationJabberUtils.addStringToMap(geolocMap, "region", geolocExt.getRegion());
        GeolocationJabberUtils.addStringToMap(geolocMap, "room", geolocExt.getRoom());
        GeolocationJabberUtils.addStringToMap(geolocMap, "street", geolocExt.getStreet());
        GeolocationJabberUtils.addStringToMap(geolocMap, "text", geolocExt.getText());
        GeolocationJabberUtils.addStringToMap(geolocMap, "timestamp", geolocExt.getTimestamp());
        return geolocMap;
    }

    private static void addFloatToMap(Map<String, String> map, String key, float value) {
        if (value != -1.0f) {
            Float valor = new Float(value);
            map.put(key, valor.toString());
        }
    }

    private static void addStringToMap(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    public static GeolocationPacketExtension convertMapToExtension(Map<String, String> geolocation) {
        GeolocationPacketExtension geolocExt = new GeolocationPacketExtension();
        Set<Map.Entry<String, String>> entries = geolocation.entrySet();
        for (Map.Entry<String, String> line : entries) {
            String curParam = line.getKey();
            String curValue = line.getValue();
            String prototype = String.valueOf(Character.toUpperCase(curParam.charAt(0))) + curParam.substring(1);
            String setterFunction = "set" + prototype;
            try {
                Method toCall = GeolocationPacketExtension.class.getMethod(setterFunction, String.class);
                Object[] arguments = new Object[]{curValue};
                try {
                    toCall.invoke((Object)geolocExt, arguments);
                }
                catch (IllegalArgumentException exc) {
                    logger.error((Object)exc);
                }
                catch (IllegalAccessException exc) {
                    logger.error((Object)exc);
                }
                catch (InvocationTargetException exc) {
                    logger.error((Object)exc);
                }
            }
            catch (SecurityException exc) {
                logger.error((Object)exc);
            }
            catch (NoSuchMethodException exc) {
                logger.error((Object)exc);
            }
        }
        return geolocExt;
    }
}

