/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.WhiteboardSessionJabberImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.WhiteboardParticipant;
import net.java.sip.communicator.service.protocol.WhiteboardParticipantState;
import net.java.sip.communicator.service.protocol.WhiteboardSession;
import net.java.sip.communicator.service.protocol.event.WhiteboardParticipantChangeEvent;
import net.java.sip.communicator.service.protocol.event.WhiteboardParticipantListener;
import net.java.sip.communicator.util.Logger;

public class WhiteboardParticipantJabberImpl
implements WhiteboardParticipant {
    private static final Logger logger = Logger.getLogger(WhiteboardParticipantJabberImpl.class);
    private ContactJabberImpl participant = null;
    protected WhiteboardParticipantState whiteboardParticipantState = WhiteboardParticipantState.UNKNOWN;
    protected Date currentStateStartDate = new Date();
    private byte[] image;
    private String participantID;
    private WhiteboardSessionJabberImpl whiteboard;
    protected final List<WhiteboardParticipantListener> whiteboardParticipantListeners = new ArrayList<WhiteboardParticipantListener>();

    public WhiteboardParticipantJabberImpl(ContactJabberImpl participant, WhiteboardSessionJabberImpl owningWhiteboard) {
        this.participant = participant;
        this.whiteboard = owningWhiteboard;
        this.whiteboard.addWhiteboardParticipant(this);
        this.participantID = String.valueOf(String.valueOf(System.currentTimeMillis())) + String.valueOf(this.hashCode());
    }

    public String getContactAddress() {
        return this.participant.getAddress();
    }

    public WhiteboardParticipantState getState() {
        return this.whiteboardParticipantState;
    }

    protected void setState(WhiteboardParticipantState newState, String reason) {
        WhiteboardParticipantState oldState = this.getState();
        if (oldState == newState) {
            return;
        }
        this.whiteboardParticipantState = newState;
        this.currentStateStartDate = new Date();
        this.fireWhiteboardParticipantChangeEvent("WhiteboardParticipantStatusChange", oldState, newState);
    }

    protected void setState(WhiteboardParticipantState newState) {
        this.setState(newState, null);
    }

    public Date getCurrentStateStartDate() {
        return this.currentStateStartDate;
    }

    public String getDisplayName() {
        String displayName = this.participant.getDisplayName();
        return displayName == null ? "" : displayName;
    }

    protected void setDisplayName(String displayName) {
        String oldName = this.getDisplayName();
        this.fireWhiteboardParticipantChangeEvent("WhiteboardParticipantDisplayNameChange", oldName, displayName);
    }

    public byte[] getImage() {
        return this.image;
    }

    protected void setImage(byte[] image) {
        byte[] oldImage = this.getImage();
        this.image = image;
        this.fireWhiteboardParticipantChangeEvent("WhiteboardParticipantImageChange", oldImage, image);
    }

    public String getParticipantID() {
        return this.participantID;
    }

    protected void setParticipantID(String participantID) {
        this.participantID = participantID;
    }

    public WhiteboardSession getWhiteboardSession() {
        return this.whiteboard;
    }

    protected void setWhiteboard(WhiteboardSessionJabberImpl whiteboard) {
        this.whiteboard = whiteboard;
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.getWhiteboardSession().getProtocolProvider();
    }

    public Contact getContact() {
        return this.participant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWhiteboardParticipantListener(WhiteboardParticipantListener listener) {
        List<WhiteboardParticipantListener> list = this.whiteboardParticipantListeners;
        synchronized (list) {
            if (!this.whiteboardParticipantListeners.contains(listener)) {
                this.whiteboardParticipantListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWhiteboardParticipantListener(WhiteboardParticipantListener listener) {
        List<WhiteboardParticipantListener> list = this.whiteboardParticipantListeners;
        synchronized (list) {
            if (listener == null) {
                return;
            }
            this.whiteboardParticipantListeners.remove(listener);
        }
    }

    protected void fireWhiteboardParticipantChangeEvent(String eventType, Object oldValue, Object newValue) {
        this.fireWhiteboardParticipantChangeEvent(eventType, oldValue, newValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireWhiteboardParticipantChangeEvent(String eventType, Object oldValue, Object newValue, String reason) {
        ArrayList<WhiteboardParticipantListener> listeners;
        WhiteboardParticipantChangeEvent evt = new WhiteboardParticipantChangeEvent((WhiteboardParticipant)this, eventType, oldValue, newValue, reason);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a WhiteboardParticipantChangeEvent event to " + this.whiteboardParticipantListeners.size() + " listeners. event is: " + evt.toString()));
        }
        List<WhiteboardParticipantListener> list = this.whiteboardParticipantListeners;
        synchronized (list) {
            listeners = new ArrayList<WhiteboardParticipantListener>(this.whiteboardParticipantListeners);
        }
        for (WhiteboardParticipantListener listener : listeners) {
            if (eventType.equals("WhiteboardParticipantDisplayNameChange")) {
                listener.participantDisplayNameChanged(evt);
                continue;
            }
            if (eventType.equals("WhiteboardParticipantImageChange")) {
                listener.participantImageChanged(evt);
                continue;
            }
            if (!eventType.equals("WhiteboardParticipantStatusChange")) continue;
            listener.participantStateChanged(evt);
        }
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.participant.getDisplayName();
    }

    public void setWhiteboardSession(WhiteboardSessionJabberImpl session) {
        this.whiteboard = session;
    }
}

