/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ScLogFormatter
extends Formatter {
    static long startTime = System.currentTimeMillis();
    private static String lineSeparator = System.getProperty("line.separator");
    private static DecimalFormat twoDigFmt = new DecimalFormat("00");
    private static DecimalFormat threeDigFmt = new DecimalFormat("000");

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        int millis = cal.get(14);
        sb.append(twoDigFmt.format(hour)).append(':');
        sb.append(twoDigFmt.format(minutes)).append(':');
        sb.append(twoDigFmt.format(seconds)).append('.');
        sb.append(threeDigFmt.format(millis)).append(' ');
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append("[" + record.getThreadID() + "] ");
        int lineNumber = this.inferCaller(record);
        String loggerName = record.getLoggerName();
        if (loggerName == null) {
            loggerName = record.getSourceClassName();
        }
        if (loggerName.startsWith("net.java.sip.communicator.")) {
            sb.append(loggerName.substring("net.java.sip.communicator.".length()));
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(".");
            sb.append(record.getSourceMethodName());
            if (lineNumber != -1) {
                sb.append("().").append(Integer.toString(lineNumber));
            } else {
                sb.append("()");
            }
        }
        sb.append(" ");
        sb.append(record.getMessage());
        sb.append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private int inferCaller(LogRecord record) {
        String cname;
        StackTraceElement frame;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int lineNumber = -1;
        int ix = 0;
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (cname.equals("net.java.sip.communicator.util.Logger")) break;
            ++ix;
        }
        while (ix < stack.length) {
            frame = stack[ix];
            lineNumber = stack[ix].getLineNumber();
            cname = frame.getClassName();
            if (!cname.equals("net.java.sip.communicator.util.Logger")) {
                record.setSourceClassName(cname);
                record.setSourceMethodName(frame.getMethodName());
                break;
            }
            ++ix;
        }
        return lineNumber;
    }
}

