/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.examples;

import java.io.PrintStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.DefaultStreamConnector;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.MediaFormat;

public class AVTransmit2 {
    private int localPortBase;
    private MediaStream[] mediaStreams;
    private InetAddress remoteAddr;
    private int remotePortBase;
    private static final String LOCAL_PORT_BASE_ARG_NAME = "--local-port-base=";
    private static final String REMOTE_HOST_ARG_NAME = "--remote-host=";
    private static final String REMOTE_PORT_BASE_ARG_NAME = "--remote-port-base=";
    private static final String[][] ARGS = new String[][]{{"--local-port-base=", "The port which is the source of the transmission i.e. from which the media is to be transmitted. The specified value will be used as the port to transmit the audio RTP from, the next port after it will be used to transmit the audio RTCP from. Respectively, the subsequent ports will be used to transmit the video RTP and RTCP from."}, {"--remote-host=", "The name of the host which is the target of the transmission i.e. to which the media is to be transmitted"}, {"--remote-port-base=", "The port which is the target of the transmission i.e. to which the media is to be transmitted. The specified value will be used as the port to transmit the audio RTP to the next port after it will be used to transmit the audio RTCP to. Respectively, the subsequent ports will be used to transmit the video RTP and RTCP to."}};

    private AVTransmit2(String localPortBase, String remoteHost, String remotePortBase) throws Exception {
        this.localPortBase = localPortBase == null ? -1 : Integer.valueOf(localPortBase);
        this.remoteAddr = InetAddress.getByName(remoteHost);
        this.remotePortBase = Integer.valueOf(remotePortBase);
    }

    private String start() throws Exception {
        MediaType[] mediaTypes = MediaType.values();
        MediaService mediaService = LibJitsi.getMediaService();
        int localPort = this.localPortBase;
        int remotePort = this.remotePortBase;
        this.mediaStreams = new MediaStream[mediaTypes.length];
        for (MediaType mediaType : mediaTypes) {
            DefaultStreamConnector connector;
            byte dynamicRTPPayloadType;
            double clockRate;
            String encoding;
            MediaDevice device = mediaService.getDefaultDevice(mediaType, MediaUseCase.CALL);
            MediaStream mediaStream = mediaService.createMediaStream(device);
            mediaStream.setDirection(MediaDirection.SENDONLY);
            switch (device.getMediaType()) {
                case AUDIO: {
                    encoding = "PCMU";
                    clockRate = 8000.0;
                    dynamicRTPPayloadType = -1;
                    break;
                }
                case VIDEO: {
                    encoding = "H264";
                    clockRate = -1.0;
                    dynamicRTPPayloadType = 99;
                    break;
                }
                default: {
                    encoding = null;
                    clockRate = -1.0;
                    dynamicRTPPayloadType = -1;
                }
            }
            if (encoding != null) {
                MediaFormat format = mediaService.getFormatFactory().createMediaFormat(encoding, clockRate);
                if (dynamicRTPPayloadType != -1) {
                    mediaStream.addDynamicRTPPayloadType(dynamicRTPPayloadType, format);
                }
                mediaStream.setFormat(format);
            }
            if (this.localPortBase == -1) {
                connector = new DefaultStreamConnector();
            } else {
                int localRTPPort = localPort++;
                int localRTCPPort = localPort++;
                connector = new DefaultStreamConnector(new DatagramSocket(localRTPPort), new DatagramSocket(localRTCPPort));
            }
            mediaStream.setConnector(connector);
            int remoteRTPPort = remotePort++;
            int remoteRTCPPort = remotePort++;
            mediaStream.setTarget(new MediaStreamTarget(new InetSocketAddress(this.remoteAddr, remoteRTPPort), new InetSocketAddress(this.remoteAddr, remoteRTCPPort)));
            mediaStream.setName(mediaType.toString());
            this.mediaStreams[mediaType.ordinal()] = mediaStream;
        }
        for (MediaStream mediaStream : this.mediaStreams) {
            if (mediaStream == null) continue;
            mediaStream.start();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        if (this.mediaStreams != null) {
            for (int i = 0; i < this.mediaStreams.length; ++i) {
                MediaStream mediaStream = this.mediaStreams[i];
                if (mediaStream == null) continue;
                try {
                    mediaStream.stop();
                    continue;
                }
                finally {
                    mediaStream.close();
                    this.mediaStreams[i] = null;
                }
            }
            this.mediaStreams = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block8: {
            if (args.length < 2) {
                AVTransmit2.prUsage();
            } else {
                Map<String, String> argMap = AVTransmit2.parseCommandLineArgs(args);
                LibJitsi.start();
                try {
                    AVTransmit2 at = new AVTransmit2(argMap.get(LOCAL_PORT_BASE_ARG_NAME), argMap.get(REMOTE_HOST_ARG_NAME), argMap.get(REMOTE_PORT_BASE_ARG_NAME));
                    String result = at.start();
                    if (result == null) {
                        System.err.println("Start transmission for 60 seconds...");
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        at.stop();
                        System.err.println("...transmission ended.");
                        break block8;
                    }
                    System.err.println("Error : " + result);
                }
                finally {
                    LibJitsi.stop();
                }
            }
        }
    }

    static Map<String, String> parseCommandLineArgs(String[] args) {
        HashMap<String, String> argMap = new HashMap<String, String>();
        for (String arg : args) {
            String value;
            String key;
            int keyEndIndex = arg.indexOf(61);
            if (keyEndIndex == -1) {
                key = arg;
                value = null;
            } else {
                key = arg.substring(0, keyEndIndex + 1);
                value = arg.substring(keyEndIndex + 1);
            }
            argMap.put(key, value);
        }
        return argMap;
    }

    private static void prUsage() {
        PrintStream err = System.err;
        err.println("Usage: " + AVTransmit2.class.getName() + " <args>");
        err.println("Valid args:");
        for (String[] arg : ARGS) {
            err.println("  " + arg[0] + " " + arg[1]);
        }
    }
}

