/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.SessionAddress;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.RTCPAPPPacket;
import net.sf.fmj.media.rtp.RTCPBYEPacket;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTCPSDESItem;
import net.sf.fmj.media.rtp.RTCPSDESPacket;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.StreamSynch;
import net.sf.fmj.media.rtp.util.BadFormatException;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.RTPPacketReceiver;
import net.sf.fmj.media.rtp.util.UDPPacketReceiver;

public class RTCPRawReceiver
extends PacketFilter {
    public DatagramSocket socket;
    private StreamSynch streamSynch;
    private OverallStats stats = null;

    public RTCPRawReceiver() {
    }

    public RTCPRawReceiver(DatagramSocket sock, OverallStats stats, StreamSynch streamSynch) {
        this.setSource(new UDPPacketReceiver(sock, 1000));
        this.stats = stats;
        this.streamSynch = streamSynch;
    }

    public RTCPRawReceiver(int localPort, String localAddress, OverallStats stats, StreamSynch streamSynch) throws UnknownHostException, IOException, SocketException {
        this.streamSynch = streamSynch;
        this.stats = stats;
        UDPPacketReceiver recv = new UDPPacketReceiver(localPort, localAddress, -1, null, 1000, null);
        this.setSource(recv);
        this.socket = recv.getSocket();
    }

    public RTCPRawReceiver(RTPConnector rtpConnector, OverallStats stats, StreamSynch streamSynch) {
        this.streamSynch = streamSynch;
        try {
            this.setSource(new RTPPacketReceiver(rtpConnector.getControlInputStream()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.stats = stats;
    }

    public RTCPRawReceiver(RTPPushDataSource networkdatasource, OverallStats stats, StreamSynch streamSynch) {
        this.streamSynch = streamSynch;
        this.setSource(new RTPPacketReceiver(networkdatasource));
        this.stats = stats;
    }

    public RTCPRawReceiver(SessionAddress localAddress, SessionAddress remoteAddress, OverallStats stats, StreamSynch streamSynch, DatagramSocket controlSocket) throws UnknownHostException, IOException, SocketException {
        this.streamSynch = streamSynch;
        this.stats = stats;
        UDPPacketReceiver recv = new UDPPacketReceiver(localAddress.getControlPort(), localAddress.getControlHostAddress(), remoteAddress.getControlPort(), remoteAddress.getControlHostAddress(), 1000, controlSocket);
        this.setSource(recv);
        this.socket = recv.getSocket();
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.getSource() instanceof RTPPacketReceiver) {
            this.getSource().closeSource();
        }
    }

    public String filtername() {
        return "RTCP Raw Receiver";
    }

    public Packet handlePacket(Packet p) {
        RTCPPacket result;
        this.stats.update(0, 1);
        this.stats.update(11, 1);
        this.stats.update(1, p.length);
        try {
            result = this.parse(p);
        }
        catch (BadFormatException e) {
            this.stats.update(13, 1);
            return null;
        }
        return result;
    }

    public Packet handlePacket(Packet p, int i) {
        return null;
    }

    public Packet handlePacket(Packet p, SessionAddress a) {
        return null;
    }

    public Packet handlePacket(Packet p, SessionAddress a, boolean control) {
        return null;
    }

    public RTCPPacket parse(Packet packet) throws BadFormatException {
        RTCPCompoundPacket base = new RTCPCompoundPacket(packet);
        Vector<RTCPSDESPacket> subpackets = new Vector<RTCPSDESPacket>(2);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(base.data, base.offset, base.length));
        try {
            int length;
            for (int offset = 0; offset < base.length; offset += length) {
                RTCPPacket p;
                int firstbyte = in.readUnsignedByte();
                if ((firstbyte & 0xC0) != 128) {
                    throw new BadFormatException();
                }
                int type = in.readUnsignedByte();
                length = in.readUnsignedShort();
                length = length + 1 << 2;
                int padlen = 0;
                if (offset + length > base.length) {
                    throw new BadFormatException();
                }
                if (offset + length == base.length ? (firstbyte & 0x20) != 0 && (padlen = base.data[base.offset + base.length - 1] & 0xFF) == 0 : (firstbyte & 0x20) != 0) {
                    throw new BadFormatException();
                }
                int inlength = length - padlen;
                firstbyte &= 0x1F;
                switch (type) {
                    case 200: {
                        this.stats.update(12, 1);
                        if (inlength != 28 + 24 * firstbyte) {
                            this.stats.update(18, 1);
                            System.out.println("bad format.");
                            throw new BadFormatException();
                        }
                        RTCPSRPacket srp = new RTCPSRPacket(base);
                        p = srp;
                        srp.ssrc = in.readInt();
                        srp.ntptimestampmsw = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.ntptimestamplsw = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.rtptimestamp = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.packetcount = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.octetcount = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.reports = new RTCPReportBlock[firstbyte];
                        this.streamSynch.update(srp.ssrc, srp.rtptimestamp, srp.ntptimestampmsw, srp.ntptimestamplsw);
                        for (int i = 0; i < srp.reports.length; ++i) {
                            RTCPReportBlock report;
                            srp.reports[i] = report = new RTCPReportBlock();
                            report.ssrc = in.readInt();
                            long val = in.readInt();
                            report.fractionlost = (int)((val &= 0xFFFFFFFFL) >> 24);
                            report.packetslost = (int)(val & 0xFFFFFFL);
                            report.lastseq = (long)in.readInt() & 0xFFFFFFFFL;
                            report.jitter = in.readInt();
                            report.lsr = (long)in.readInt() & 0xFFFFFFFFL;
                            report.dlsr = (long)in.readInt() & 0xFFFFFFFFL;
                        }
                        break;
                    }
                    case 201: {
                        if (inlength != 8 + 24 * firstbyte) {
                            this.stats.update(15, 1);
                            throw new BadFormatException();
                        }
                        RTCPRRPacket rrp = new RTCPRRPacket(base);
                        p = rrp;
                        rrp.ssrc = in.readInt();
                        rrp.reports = new RTCPReportBlock[firstbyte];
                        for (int i = 0; i < rrp.reports.length; ++i) {
                            RTCPReportBlock report;
                            rrp.reports[i] = report = new RTCPReportBlock();
                            report.ssrc = in.readInt();
                            long val = in.readInt();
                            report.fractionlost = (int)((val &= 0xFFFFFFFFL) >> 24);
                            report.packetslost = (int)(val & 0xFFFFFFL);
                            report.lastseq = (long)in.readInt() & 0xFFFFFFFFL;
                            report.jitter = in.readInt();
                            report.lsr = (long)in.readInt() & 0xFFFFFFFFL;
                            report.dlsr = (long)in.readInt() & 0xFFFFFFFFL;
                        }
                        break;
                    }
                    case 202: {
                        RTCPSDESPacket sdesp;
                        p = sdesp = new RTCPSDESPacket(base);
                        sdesp.sdes = new RTCPSDES[firstbyte];
                        int sdesoff = 4;
                        for (int i = 0; i < sdesp.sdes.length; ++i) {
                            int j;
                            RTCPSDES chunk;
                            sdesp.sdes[i] = chunk = new RTCPSDES();
                            chunk.ssrc = in.readInt();
                            sdesoff += 5;
                            Vector<RTCPSDESItem> items = new Vector<RTCPSDESItem>();
                            boolean gotcname = false;
                            while ((j = in.readUnsignedByte()) != 0) {
                                if (j < 1 || j > 8) {
                                    this.stats.update(16, 1);
                                    throw new BadFormatException();
                                }
                                if (j == 1) {
                                    gotcname = true;
                                }
                                RTCPSDESItem item = new RTCPSDESItem();
                                items.addElement(item);
                                item.type = j;
                                int sdeslen = in.readUnsignedByte();
                                item.data = new byte[sdeslen];
                                in.readFully(item.data);
                                sdesoff += 2 + sdeslen;
                            }
                            if (!gotcname) {
                                this.stats.update(16, 1);
                                throw new BadFormatException();
                            }
                            chunk.items = new RTCPSDESItem[items.size()];
                            items.copyInto(chunk.items);
                            if ((sdesoff & 3) == 0) continue;
                            in.skip(4 - (sdesoff & 3));
                            sdesoff = sdesoff + 3 & 0xFFFFFFFC;
                        }
                        if (inlength == sdesoff) break;
                        this.stats.update(16, 1);
                        throw new BadFormatException();
                    }
                    case 203: {
                        int reasonlen;
                        RTCPBYEPacket byep = new RTCPBYEPacket(base);
                        p = byep;
                        byep.ssrc = new int[firstbyte];
                        for (int i = 0; i < byep.ssrc.length; ++i) {
                            byep.ssrc[i] = in.readInt();
                        }
                        if (inlength > 4 + 4 * firstbyte) {
                            reasonlen = in.readUnsignedByte();
                            byep.reason = new byte[reasonlen];
                            ++reasonlen;
                        } else {
                            reasonlen = 0;
                            byep.reason = new byte[0];
                        }
                        reasonlen = reasonlen + 3 & 0xFFFFFFFC;
                        if (inlength != 4 + 4 * firstbyte + reasonlen) {
                            this.stats.update(17, 1);
                            throw new BadFormatException();
                        }
                        in.readFully(byep.reason);
                        in.skip(reasonlen - byep.reason.length);
                        break;
                    }
                    case 204: {
                        if (inlength < 12) {
                            throw new BadFormatException();
                        }
                        RTCPAPPPacket appp = new RTCPAPPPacket(base);
                        p = appp;
                        appp.ssrc = in.readInt();
                        appp.name = in.readInt();
                        appp.subtype = firstbyte;
                        appp.data = new byte[inlength - 12];
                        in.readFully(appp.data);
                        in.skip(inlength - 12 - appp.data.length);
                        break;
                    }
                    default: {
                        this.stats.update(14, 1);
                        throw new BadFormatException();
                    }
                }
                p.offset = offset;
                p.length = length;
                subpackets.addElement((RTCPSDESPacket)p);
                in.skipBytes(padlen);
            }
        }
        catch (EOFException e) {
            throw new BadFormatException("Unexpected end of RTCP packet");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Impossible Exception");
        }
        base.packets = new RTCPPacket[subpackets.size()];
        subpackets.copyInto(base.packets);
        return base;
    }
}

