/*
 * Decompiled with CFR 0.152.
 */
package com.t4l.jmf;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.media.format.RGBFormat;

public class RGBConverter {
    public static void flipVertical(int[] data, int width, int height) {
        int[] row1 = new int[width];
        int[] row2 = new int[width];
        for (int y = 0; y < height / 2; ++y) {
            int y2 = height - 1 - y;
            int offset1 = y * width;
            int offset2 = y2 * width;
            System.arraycopy(data, offset1, row1, 0, width);
            System.arraycopy(data, offset2, row2, 0, width);
            System.arraycopy(row1, 0, data, offset2, width);
            System.arraycopy(row2, 0, data, offset1, width);
        }
    }

    private static int getShift(int mask) {
        int i = mask;
        int k = 0;
        while (i != 255) {
            if (i < 255) {
                throw new IllegalArgumentException("Unsupported mask: " + Integer.toString(mask, 16));
            }
            ++k;
            i /= 2;
        }
        return k;
    }

    public static void populateArray(BufferedImage image, int[] dest, RGBFormat format) {
        int imageType = image.getType();
        int width = image.getWidth();
        int height = image.getHeight();
        if (format == null) {
            throw new NullPointerException();
        }
        int pixelsPerRow = format.getLineStride();
        if (dest.length < pixelsPerRow * height) {
            throw new IllegalArgumentException("Illegal array size: " + dest.length + "<" + pixelsPerRow * height);
        }
        if (imageType == 2 || imageType == 3 || imageType == 1) {
            image.getRaster().getDataElements(0, 0, width, height, dest);
        } else {
            image.getRGB(0, 0, width, height, dest, 0, width);
        }
        int rMask = format.getRedMask();
        int gMask = format.getGreenMask();
        int bMask = format.getBlueMask();
        if (rMask != 0xFF0000 || gMask != 65280 || bMask != 255 || format.getLineStride() != width || format.getPixelStride() != 1) {
            int rShift = RGBConverter.getShift(rMask);
            int gShift = RGBConverter.getShift(gMask);
            int bShift = RGBConverter.getShift(bMask);
            int pixelSize = format.getPixelStride();
            for (int y = height - 1; y >= 0; --y) {
                for (int x = width - 1; x >= 0; --x) {
                    int i = y * width + x;
                    int r = dest[i] >> 16 & 0xFF;
                    int g = dest[i] >> 8 & 0xFF;
                    int b = dest[i] >> 0 & 0xFF;
                    i = y * pixelsPerRow + x * pixelSize;
                    dest[i] = (r << rShift) + (g << gShift) + (b << bShift);
                }
            }
        }
        if (format.getFlipped() == 1) {
            RGBConverter.flipVertical(dest, width, height);
        }
    }

    public static void populateImage(int[] array, int offset, BufferedImage image, RGBFormat vf) {
        int imageType = image.getType();
        int targetType = imageType == 2 || imageType == 3 ? 2 : 1;
        RGBConverter.processData(array, offset, vf, targetType);
        int width = image.getWidth();
        int height = image.getHeight();
        if (imageType == 2 || imageType == 1) {
            image.getRaster().setDataElements(0, 0, width, height, array);
        } else {
            image.setRGB(0, 0, width, height, array, 0, width);
        }
    }

    private static void processData(int[] array, int arrayOffset, RGBFormat vf, int targetType) {
        Dimension size = vf.getSize();
        int width = size.width;
        int height = size.height;
        int rMask = vf.getRedMask();
        int gMask = vf.getGreenMask();
        int bMask = vf.getBlueMask();
        int rShift = RGBConverter.getShift(rMask);
        int gShift = RGBConverter.getShift(gMask);
        int bShift = RGBConverter.getShift(bMask);
        int padding = vf.getLineStride() - width;
        if (arrayOffset == 0 && vf.getPixelStride() == 1 && padding == 0 && rMask == 0xFF0000 && gMask == 65280 && bMask == 255) {
            if (targetType == 1) {
                return;
            }
            int area = width * height;
            for (int a = 0; a < area; ++a) {
                array[a] = (array[a] & 0xFFFFFF) + -16777216;
            }
            return;
        }
        int i = 0;
        if (targetType == 2) {
            for (int y = 0; y < height; ++y) {
                int base = y * width;
                for (int x = 0; x < width; ++x) {
                    int color = array[i + arrayOffset];
                    int r = color >> rShift & 0xFF;
                    int g = color >> gShift & 0xFF;
                    int b = color >> bShift & 0xFF;
                    array[base + x] = color = -16777216 + (r << 16) + (g << 8) + b;
                    ++i;
                }
                i += padding;
            }
        } else {
            for (int y = 0; y < height; ++y) {
                int base = y * width;
                for (int x = 0; x < width; ++x) {
                    int color = array[i + arrayOffset];
                    int r = color >> rShift & 0xFF;
                    int g = color >> gShift & 0xFF;
                    int b = color >> bShift & 0xFF;
                    array[base + x] = color = (r << 16) + (g << 8) + b;
                    ++i;
                }
                i += padding;
            }
        }
        if (vf.getFlipped() == 1) {
            RGBConverter.flipVertical(array, width, height);
        }
    }
}

