/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.sctp4j;

import java.util.HashMap;
import java.util.Map;
import org.jitsi.sctp4j.SctpSocket;
import org.jitsi.util.Logger;

public class Sctp {
    private static final Logger logger = Logger.getLogger(Sctp.class);
    public static final int MSG_NOTIFICATION = 8192;
    public static final int SCTP_ASSOC_CHANGE = 1;
    public static final int SCTP_PEER_ADDR_CHANGE = 2;
    public static final int SCTP_REMOTE_ERROR = 3;
    public static final int SCTP_SEND_FAILED = 4;
    public static final int SCTP_SHUTDOWN_EVENT = 5;
    public static final int SCTP_ADAPTATION_INDICATION = 6;
    public static final int SCTP_PARTIAL_DELIVERY_EVENT = 7;
    public static final int SCTP_AUTHENTICATION_EVENT = 8;
    public static final int SCTP_STREAM_RESET_EVENT = 9;
    public static final int SCTP_SENDER_DRY_EVENT = 10;
    public static final int SCTP_NOTIFICATIONS_STOPPED_EVENT = 11;
    public static final int SCTP_ASSOC_RESET_EVENT = 12;
    public static final int SCTP_STREAM_CHANGE_EVENT = 13;
    public static final int SCTP_SEND_FAILED_EVENT = 14;
    public static final int SCTP_COMM_UP = 1;
    public static final int SCTP_COMM_LOST = 2;
    public static final int SCTP_RESTART = 3;
    public static final int SCTP_SHUTDOWN_COMP = 4;
    public static final int SCTP_CANT_STR_ASSOC = 5;
    public static final int SCTP_ASSOC_SUPPORTS_PR = 1;
    public static final int SCTP_ASSOC_SUPPORTS_AUTH = 2;
    public static final int SCTP_ASSOC_SUPPORTS_ASCONF = 3;
    public static final int SCTP_ASSOC_SUPPORTS_MULTIBUF = 4;
    public static final int SCTP_ASSOC_SUPPORTS_RE_CONFIG = 5;
    public static final int SCTP_ASSOC_SUPPORTS_MAX = 5;
    public static final int SCTP_ADDR_AVAILABLE = 1;
    public static final int SCTP_ADDR_UNREACHABLE = 2;
    public static final int SCTP_ADDR_REMOVED = 3;
    public static final int SCTP_ADDR_ADDED = 4;
    public static final int SCTP_ADDR_MADE_PRIM = 5;
    public static final int SCTP_ADDR_CONFIRMED = 6;
    public static final int SCTP_STREAM_RESET_INCOMING_SSN = 1;
    public static final int SCTP_STREAM_RESET_OUTGOING_SSN = 2;
    public static final int SCTP_STREAM_RESET_DENIED = 4;
    public static final int SCTP_STREAM_RESET_FAILED = 8;
    public static final int SCTP_STREAM_CHANGED_DENIED = 16;
    public static final int SCTP_STREAM_RESET_INCOMING = 1;
    public static final int SCTP_STREAM_RESET_OUTGOING = 2;
    private static boolean initialized;
    private static Map<Long, SctpSocket> sockets;

    public static synchronized void init(int port) {
        if (initialized) {
            return;
        }
        Sctp.usrsctp_init(port);
        initialized = true;
    }

    private static native boolean usrsctp_init(int var0);

    public static SctpSocket createSocket(int localPort) {
        Long ptr = Sctp.usersctp_socket(localPort);
        if (ptr != 0L) {
            SctpSocket sock = new SctpSocket(ptr, localPort);
            sockets.put(ptr, sock);
            return sock;
        }
        return null;
    }

    private static native long usersctp_socket(int var0);

    static native int usrsctp_send(long var0, byte[] var2, boolean var3, int var4, int var5);

    static native void usrsctp_listen(long var0);

    static native void usrsctp_accept(long var0);

    static native boolean usrsctp_connect(long var0, int var2);

    static void closeSocket(Long ptr) {
        Sctp.usrsctp_close(ptr);
        sockets.remove(ptr);
    }

    private static native void usrsctp_close(long var0);

    public static synchronized void finish() {
        if (!initialized) {
            return;
        }
        try {
            while (!Sctp.usrsctp_finish()) {
                Thread.sleep(50L);
            }
            initialized = false;
        }
        catch (InterruptedException e) {
            logger.error("Finish interrupted", e);
            Thread.currentThread().interrupt();
        }
    }

    private static native boolean usrsctp_finish();

    public static void onSctpOutboundPacket(long socketAddr, byte[] data, int tos, int set_df) {
        SctpSocket socket = sockets.get(socketAddr);
        if (socket != null) {
            socket.onSctpOut(data, tos, set_df);
        } else {
            logger.error("No SctpSocket found for ptr: " + socketAddr);
        }
    }

    public static void onSctpInboundPacket(long socketAddr, byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        SctpSocket socket = sockets.get(socketAddr);
        if (socket != null) {
            socket.onSctpIn(data, sid, ssn, tsn, ppid, context, flags);
        } else {
            logger.error("No SctpSocket found for ptr: " + socketAddr);
        }
    }

    static void onConnIn(long socketPtr, byte[] packet) {
        Sctp.on_network_in(socketPtr, packet);
    }

    private static native void on_network_in(long var0, byte[] var2);

    static {
        String lib = "jnsctp";
        try {
            System.loadLibrary(lib);
        }
        catch (Throwable t) {
            logger.error("Failed to load native library " + lib + ": " + t.getMessage());
            throw new RuntimeException(t);
        }
        sockets = new HashMap<Long, SctpSocket>();
    }
}

