/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.bccontrib.macs.SkeinMac;
import org.jitsi.bccontrib.params.ParametersForSkein;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.srtp.SRTPCipherCTR;
import org.jitsi.impl.neomedia.transform.srtp.SRTPCipherF8;
import org.jitsi.impl.neomedia.transform.srtp.SRTPPolicy;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.util.Logger;

public class SRTPCryptoContext {
    public static final String CHECK_REPLAY_PNAME = SRTPCryptoContext.class.getName() + ".checkReplay";
    private static boolean checkReplay = true;
    private static final Logger logger = Logger.getLogger(SRTPCryptoContext.class);
    private static boolean readConfigurationServicePropertiesOnce = true;
    private static final long REPLAY_WINDOW_SIZE = 64L;
    private final int ssrc;
    private byte[] mki;
    private int roc;
    private int guessedROC;
    private int s_l = 0;
    private boolean seqNumSet = false;
    private long keyDerivationRate;
    private long replayWindow;
    private byte[] masterKey;
    private byte[] masterSalt;
    private byte[] encKey;
    private byte[] authKey;
    private byte[] saltKey;
    private final SRTPPolicy policy;
    private Mac mac;
    private BlockCipher cipher = null;
    private BlockCipher cipherF8 = null;
    private final SRTPCipherCTR cipherCtr = new SRTPCipherCTR();
    private final byte[] tagStore;
    private final byte[] ivStore = new byte[16];
    private final byte[] rbStore = new byte[4];
    private final byte[] tempStore = new byte[100];
    private final boolean sender;

    public SRTPCryptoContext(boolean sender, int ssrc) {
        this.authKey = null;
        this.encKey = null;
        this.keyDerivationRate = 0L;
        this.masterKey = null;
        this.masterSalt = null;
        this.mki = null;
        this.policy = null;
        this.roc = 0;
        this.sender = sender;
        this.ssrc = ssrc;
        this.tagStore = null;
    }

    public SRTPCryptoContext(boolean sender, int ssrc, int rocIn, long kdr, byte[] masterK, byte[] masterS, SRTPPolicy policyIn) {
        this.keyDerivationRate = kdr;
        this.mki = null;
        this.roc = rocIn;
        this.policy = policyIn;
        this.sender = sender;
        this.ssrc = ssrc;
        this.masterKey = new byte[this.policy.getEncKeyLength()];
        System.arraycopy(masterK, 0, this.masterKey, 0, this.policy.getEncKeyLength());
        this.masterSalt = new byte[this.policy.getSaltKeyLength()];
        System.arraycopy(masterS, 0, this.masterSalt, 0, this.policy.getSaltKeyLength());
        this.mac = new HMac((Digest)new SHA1Digest());
        switch (this.policy.getEncType()) {
            case 0: {
                this.encKey = null;
                this.saltKey = null;
                break;
            }
            case 2: {
                this.cipherF8 = new AESFastEngine();
            }
            case 1: {
                this.cipher = new AESFastEngine();
                this.encKey = new byte[this.policy.getEncKeyLength()];
                this.saltKey = new byte[this.policy.getSaltKeyLength()];
                break;
            }
            case 4: {
                this.cipherF8 = new TwofishEngine();
            }
            case 3: {
                this.cipher = new TwofishEngine();
                this.encKey = new byte[this.policy.getEncKeyLength()];
                this.saltKey = new byte[this.policy.getSaltKeyLength()];
            }
        }
        switch (this.policy.getAuthType()) {
            case 0: {
                this.authKey = null;
                this.tagStore = null;
                break;
            }
            case 1: {
                this.mac = new HMac((Digest)new SHA1Digest());
                this.authKey = new byte[this.policy.getAuthKeyLength()];
                this.tagStore = new byte[this.mac.getMacSize()];
                break;
            }
            case 2: {
                this.mac = new SkeinMac();
                this.authKey = new byte[this.policy.getAuthKeyLength()];
                this.tagStore = new byte[this.policy.getAuthTagLength()];
                break;
            }
            default: {
                this.tagStore = null;
            }
        }
        SRTPCryptoContext.readConfigurationServicePropertiesOnce();
    }

    public void close() {
        Arrays.fill(this.masterKey, (byte)0);
        Arrays.fill(this.masterSalt, (byte)0);
    }

    public int getAuthTagLength() {
        return this.policy.getAuthTagLength();
    }

    public int getMKILength() {
        return this.mki == null ? 0 : this.mki.length;
    }

    public int getSSRC() {
        return this.ssrc;
    }

    public boolean transformPacket(RawPacket pkt) {
        long guessedIndex;
        int seqNo = pkt.getSequenceNumber();
        if (!this.seqNumSet) {
            this.seqNumSet = true;
            this.s_l = seqNo;
        }
        if (!this.checkReplay(seqNo, guessedIndex = this.guessIndex(seqNo))) {
            return false;
        }
        switch (this.policy.getEncType()) {
            case 1: 
            case 3: {
                this.processPacketAESCM(pkt);
                break;
            }
            case 2: 
            case 4: {
                this.processPacketAESF8(pkt);
            }
        }
        if (this.policy.getAuthType() != 0) {
            this.authenticatePacketHMCSHA1(pkt, this.guessedROC);
            pkt.append(this.tagStore, this.policy.getAuthTagLength());
        }
        this.update(seqNo, guessedIndex);
        return true;
    }

    public boolean reverseTransformPacket(RawPacket pkt) {
        int seqNo = pkt.getSequenceNumber();
        if (!this.seqNumSet) {
            this.seqNumSet = true;
            this.s_l = seqNo;
        }
        long guessedIndex = this.guessIndex(seqNo);
        boolean b = false;
        if (this.checkReplay(seqNo, guessedIndex) && this.authenticatePacket(pkt)) {
            switch (this.policy.getEncType()) {
                case 1: 
                case 3: {
                    this.processPacketAESCM(pkt);
                    break;
                }
                case 2: 
                case 4: {
                    this.processPacketAESF8(pkt);
                }
            }
            this.update(seqNo, guessedIndex);
            b = true;
        }
        return b;
    }

    public void processPacketAESCM(RawPacket pkt) {
        int i;
        int ssrc = pkt.getSSRC();
        int seqNo = pkt.getSequenceNumber();
        long index = (long)this.guessedROC << 16 | (long)seqNo;
        this.ivStore[0] = this.saltKey[0];
        this.ivStore[1] = this.saltKey[1];
        this.ivStore[2] = this.saltKey[2];
        this.ivStore[3] = this.saltKey[3];
        for (i = 4; i < 8; ++i) {
            this.ivStore[i] = (byte)(0xFF & ssrc >> (7 - i) * 8 ^ this.saltKey[i]);
        }
        for (i = 8; i < 14; ++i) {
            this.ivStore[i] = (byte)(0xFF & (byte)(index >> (13 - i) * 8) ^ this.saltKey[i]);
        }
        this.ivStore[15] = 0;
        this.ivStore[14] = 0;
        int payloadOffset = pkt.getHeaderLength();
        int payloadLength = pkt.getPayloadLength();
        this.cipherCtr.process(this.cipher, pkt.getBuffer(), pkt.getOffset() + payloadOffset, payloadLength, this.ivStore);
    }

    public void processPacketAESF8(RawPacket pkt) {
        System.arraycopy(pkt.getBuffer(), pkt.getOffset(), this.ivStore, 0, 12);
        this.ivStore[0] = 0;
        int roc = this.guessedROC;
        this.ivStore[12] = (byte)(roc >> 24);
        this.ivStore[13] = (byte)(roc >> 16);
        this.ivStore[14] = (byte)(roc >> 8);
        this.ivStore[15] = (byte)roc;
        int payloadOffset = pkt.getHeaderLength();
        int payloadLength = pkt.getPayloadLength();
        SRTPCipherF8.process(this.cipher, pkt.getBuffer(), pkt.getOffset() + payloadOffset, payloadLength, this.ivStore, this.cipherF8);
    }

    private boolean authenticatePacket(RawPacket pkt) {
        boolean b = true;
        if (this.policy.getAuthType() != 0) {
            int tagLength = this.policy.getAuthTagLength();
            pkt.readRegionToBuff(pkt.getLength() - tagLength, tagLength, this.tempStore);
            pkt.shrink(tagLength);
            this.authenticatePacketHMCSHA1(pkt, this.guessedROC);
            for (int i = 0; i < tagLength; ++i) {
                if ((this.tempStore[i] & 0xFF) == (this.tagStore[i] & 0xFF)) continue;
                b = false;
                break;
            }
        }
        return b;
    }

    private void authenticatePacketHMCSHA1(RawPacket pkt, int rocIn) {
        this.mac.update(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
        this.rbStore[0] = (byte)(rocIn >> 24);
        this.rbStore[1] = (byte)(rocIn >> 16);
        this.rbStore[2] = (byte)(rocIn >> 8);
        this.rbStore[3] = (byte)rocIn;
        this.mac.update(this.rbStore, 0, this.rbStore.length);
        this.mac.doFinal(this.tagStore, 0);
    }

    boolean checkReplay(int seqNo, long guessedIndex) {
        if (!checkReplay) {
            return true;
        }
        long localIndex = (long)this.roc << 16 | (long)this.s_l;
        long delta = guessedIndex - localIndex;
        if (delta > 0L) {
            return true;
        }
        if (-delta > 64L) {
            if (this.sender) {
                logger.error("Discarding RTP packet with sequence number " + seqNo + ", SSRC " + Long.toString(0xFFFFFFFFL & (long)this.ssrc) + " because it is outside the replay window! (roc " + this.roc + ", s_l " + this.s_l + ", guessedROC " + this.guessedROC);
            }
            return false;
        }
        if ((this.replayWindow >> (int)(-delta) & 1L) != 0L) {
            if (this.sender) {
                logger.error("Discarding RTP packet with sequence number " + seqNo + ", SSRC " + Long.toString(0xFFFFFFFFL & (long)this.ssrc) + " because it has been received already! (roc " + this.roc + ", s_l " + this.s_l + ", guessedROC " + this.guessedROC);
            }
            return false;
        }
        return true;
    }

    private void computeIv(long label, long index) {
        int i;
        long key_id = this.keyDerivationRate == 0L ? label << 48 : label << 48 | index / this.keyDerivationRate;
        for (i = 0; i < 7; ++i) {
            this.ivStore[i] = this.masterSalt[i];
        }
        for (i = 7; i < 14; ++i) {
            this.ivStore[i] = (byte)((byte)(0xFFL & key_id >> 8 * (13 - i)) ^ this.masterSalt[i]);
        }
        this.ivStore[15] = 0;
        this.ivStore[14] = 0;
    }

    public void deriveSrtpKeys(long index) {
        long label = 0L;
        this.computeIv(label, index);
        KeyParameter encryptionKey = new KeyParameter(this.masterKey);
        this.cipher.init(true, (CipherParameters)encryptionKey);
        Arrays.fill(this.masterKey, (byte)0);
        this.cipherCtr.getCipherStream(this.cipher, this.encKey, this.policy.getEncKeyLength(), this.ivStore);
        if (this.authKey != null) {
            label = 1L;
            this.computeIv(label, index);
            this.cipherCtr.getCipherStream(this.cipher, this.authKey, this.policy.getAuthKeyLength(), this.ivStore);
            switch (this.policy.getAuthType()) {
                case 1: {
                    KeyParameter key = new KeyParameter(this.authKey);
                    this.mac.init((CipherParameters)key);
                    break;
                }
                case 2: {
                    ParametersForSkein pfs = new ParametersForSkein((CipherParameters)new KeyParameter(this.authKey), 512, this.tagStore.length * 8);
                    this.mac.init((CipherParameters)pfs);
                }
            }
        }
        Arrays.fill(this.authKey, (byte)0);
        label = 2L;
        this.computeIv(label, index);
        this.cipherCtr.getCipherStream(this.cipher, this.saltKey, this.policy.getSaltKeyLength(), this.ivStore);
        Arrays.fill(this.masterSalt, (byte)0);
        if (this.cipherF8 != null) {
            SRTPCipherF8.deriveForIV(this.cipherF8, this.encKey, this.saltKey);
        }
        encryptionKey = new KeyParameter(this.encKey);
        this.cipher.init(true, (CipherParameters)encryptionKey);
        Arrays.fill(this.encKey, (byte)0);
    }

    private long guessIndex(int seqNo) {
        this.guessedROC = this.s_l < 32768 ? (seqNo - this.s_l > 32768 ? this.roc - 1 : this.roc) : (this.s_l - 32768 > seqNo ? this.roc + 1 : this.roc);
        return (long)this.guessedROC << 16 | (long)seqNo;
    }

    private void update(int seqNo, long guessedIndex) {
        long delta = guessedIndex - ((long)this.roc << 16 | (long)this.s_l);
        if (delta > 0L) {
            this.replayWindow <<= (int)delta;
            this.replayWindow |= 1L;
        } else {
            this.replayWindow |= (long)(1 << (int)(-delta));
        }
        if (this.guessedROC == this.roc) {
            if (seqNo > this.s_l) {
                this.s_l = seqNo & 0xFFFF;
            }
        } else if (this.guessedROC == this.roc + 1) {
            this.s_l = seqNo & 0xFFFF;
            this.roc = this.guessedROC;
        }
    }

    public SRTPCryptoContext deriveContext(int ssrc, int roc, long deriveRate) {
        return new SRTPCryptoContext(this.sender, ssrc, roc, deriveRate, this.masterKey, this.masterSalt, this.policy);
    }

    private static synchronized void readConfigurationServicePropertiesOnce() {
        if (!readConfigurationServicePropertiesOnce) {
            return;
        }
        readConfigurationServicePropertiesOnce = false;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            checkReplay = cfg.getBoolean(CHECK_REPLAY_PNAME, checkReplay);
        }
    }
}

