/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public class SRTPCipherF8 {
    private static final int BLKLEN = 16;

    public static void deriveForIV(BlockCipher f8Cipher, byte[] key, byte[] salt) {
        int i;
        byte[] saltMask = new byte[key.length];
        byte[] maskedKey = new byte[key.length];
        System.arraycopy(salt, 0, saltMask, 0, salt.length);
        for (i = salt.length; i < saltMask.length; ++i) {
            saltMask[i] = 85;
        }
        for (i = 0; i < key.length; ++i) {
            maskedKey[i] = (byte)(key[i] ^ saltMask[i]);
        }
        KeyParameter encryptionKey = new KeyParameter(maskedKey);
        f8Cipher.init(true, (CipherParameters)encryptionKey);
        saltMask = null;
        maskedKey = null;
    }

    public static void process(BlockCipher cipher, byte[] data, int off, int len, byte[] iv, BlockCipher f8Cipher) {
        F8Context f8ctx = new SRTPCipherF8().new F8Context();
        f8ctx.ivAccent = new byte[16];
        f8Cipher.processBlock(iv, 0, f8ctx.ivAccent, 0);
        f8ctx.J = 0L;
        f8ctx.S = new byte[16];
        Arrays.fill(f8ctx.S, (byte)0);
        int inLen = len;
        while (inLen >= 16) {
            SRTPCipherF8.processBlock(cipher, f8ctx, data, off, data, off, 16);
            inLen -= 16;
            off += 16;
        }
        if (inLen > 0) {
            SRTPCipherF8.processBlock(cipher, f8ctx, data, off, data, off, inLen);
        }
    }

    private static void processBlock(BlockCipher cipher, F8Context f8ctx, byte[] in, int inOff, byte[] out, int outOff, int len) {
        int i;
        for (i = 0; i < 16; ++i) {
            int n = i;
            f8ctx.S[n] = (byte)(f8ctx.S[n] ^ f8ctx.ivAccent[i]);
        }
        f8ctx.S[12] = (byte)((long)f8ctx.S[12] ^ f8ctx.J >> 24);
        f8ctx.S[13] = (byte)((long)f8ctx.S[13] ^ f8ctx.J >> 16);
        f8ctx.S[14] = (byte)((long)f8ctx.S[14] ^ f8ctx.J >> 8);
        f8ctx.S[15] = (byte)((long)f8ctx.S[15] ^ f8ctx.J >> 0);
        ++f8ctx.J;
        cipher.processBlock(f8ctx.S, 0, f8ctx.S, 0);
        for (i = 0; i < len; ++i) {
            out[outOff + i] = (byte)(in[inOff + i] ^ f8ctx.S[i]);
        }
    }

    class F8Context {
        public byte[] S;
        public byte[] ivAccent;
        long J;

        F8Context() {
        }
    }
}

