/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.bccontrib.macs.SkeinMac;
import org.jitsi.bccontrib.params.ParametersForSkein;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.srtp.SRTPCipherCTR;
import org.jitsi.impl.neomedia.transform.srtp.SRTPCipherF8;
import org.jitsi.impl.neomedia.transform.srtp.SRTPPolicy;

public class SRTCPCryptoContext {
    private static final long REPLAY_WINDOW_SIZE = 64L;
    private final int ssrc;
    private byte[] mki;
    private int receivedIndex = 0;
    private int sentIndex = 0;
    private long replayWindow;
    private byte[] masterKey;
    private byte[] masterSalt;
    private byte[] encKey;
    private byte[] authKey;
    private byte[] saltKey;
    private final SRTPPolicy policy;
    private Mac mac;
    private BlockCipher cipher = null;
    private BlockCipher cipherF8 = null;
    private final SRTPCipherCTR cipherCtr = new SRTPCipherCTR();
    private final byte[] tagStore;
    private final byte[] ivStore = new byte[16];
    private final byte[] rbStore = new byte[4];
    private final byte[] tempStore = new byte[100];

    public SRTCPCryptoContext(int ssrc) {
        this.ssrc = ssrc;
        this.mki = null;
        this.masterKey = null;
        this.masterSalt = null;
        this.encKey = null;
        this.authKey = null;
        this.saltKey = null;
        this.policy = null;
        this.tagStore = null;
    }

    public SRTCPCryptoContext(int ssrc, byte[] masterK, byte[] masterS, SRTPPolicy policyIn) {
        this.ssrc = ssrc;
        this.mki = null;
        this.policy = policyIn;
        this.masterKey = new byte[this.policy.getEncKeyLength()];
        System.arraycopy(masterK, 0, this.masterKey, 0, this.policy.getEncKeyLength());
        this.masterSalt = new byte[this.policy.getSaltKeyLength()];
        System.arraycopy(masterS, 0, this.masterSalt, 0, this.policy.getSaltKeyLength());
        switch (this.policy.getEncType()) {
            case 0: {
                this.encKey = null;
                this.saltKey = null;
                break;
            }
            case 2: {
                this.cipherF8 = new AESFastEngine();
            }
            case 1: {
                this.cipher = new AESFastEngine();
                this.encKey = new byte[this.policy.getEncKeyLength()];
                this.saltKey = new byte[this.policy.getSaltKeyLength()];
                break;
            }
            case 4: {
                this.cipherF8 = new TwofishEngine();
            }
            case 3: {
                this.cipher = new TwofishEngine();
                this.encKey = new byte[this.policy.getEncKeyLength()];
                this.saltKey = new byte[this.policy.getSaltKeyLength()];
            }
        }
        switch (this.policy.getAuthType()) {
            case 0: {
                this.authKey = null;
                this.tagStore = null;
                break;
            }
            case 1: {
                this.mac = new HMac((Digest)new SHA1Digest());
                this.authKey = new byte[this.policy.getAuthKeyLength()];
                this.tagStore = new byte[this.mac.getMacSize()];
                break;
            }
            case 2: {
                this.mac = new SkeinMac();
                this.authKey = new byte[this.policy.getAuthKeyLength()];
                this.tagStore = new byte[this.policy.getAuthTagLength()];
                break;
            }
            default: {
                this.tagStore = null;
            }
        }
    }

    public void close() {
        Arrays.fill(this.masterKey, (byte)0);
        Arrays.fill(this.masterSalt, (byte)0);
    }

    public int getAuthTagLength() {
        return this.policy.getAuthTagLength();
    }

    public int getMKILength() {
        if (this.mki != null) {
            return this.mki.length;
        }
        return 0;
    }

    public int getSSRC() {
        return this.ssrc;
    }

    public void transformPacket(RawPacket pkt) {
        boolean encrypt = false;
        if (this.policy.getEncType() == 1 || this.policy.getEncType() == 3) {
            this.processPacketAESCM(pkt, this.sentIndex);
            encrypt = true;
        } else if (this.policy.getEncType() == 2 || this.policy.getEncType() == 4) {
            this.processPacketAESF8(pkt, this.sentIndex);
            encrypt = true;
        }
        int index = 0;
        if (encrypt) {
            index = this.sentIndex | Integer.MIN_VALUE;
        }
        pkt.grow(4 + this.policy.getAuthTagLength());
        if (this.policy.getAuthType() != 0) {
            this.authenticatePacket(pkt, index);
            pkt.append(this.rbStore, 4);
            pkt.append(this.tagStore, this.policy.getAuthTagLength());
        }
        ++this.sentIndex;
        this.sentIndex &= Integer.MAX_VALUE;
    }

    public boolean reverseTransformPacket(RawPacket pkt) {
        int index;
        boolean decrypt = false;
        int tagLength = this.policy.getAuthTagLength();
        int indexEflag = pkt.getSRTCPIndex(tagLength);
        if ((indexEflag & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            decrypt = true;
        }
        if (!this.checkReplay(index = indexEflag & Integer.MAX_VALUE)) {
            return false;
        }
        if (this.policy.getAuthType() != 0) {
            pkt.readRegionToBuff(pkt.getLength() - tagLength, tagLength, this.tempStore);
            pkt.shrink(tagLength + 4);
            this.authenticatePacket(pkt, indexEflag);
            for (int i = 0; i < tagLength; ++i) {
                if ((this.tempStore[i] & 0xFF) == (this.tagStore[i] & 0xFF)) continue;
                return false;
            }
        }
        if (decrypt) {
            if (this.policy.getEncType() == 1 || this.policy.getEncType() == 3) {
                this.processPacketAESCM(pkt, index);
            } else if (this.policy.getEncType() == 2 || this.policy.getEncType() == 4) {
                this.processPacketAESF8(pkt, index);
            }
        }
        this.update(index);
        return true;
    }

    public void processPacketAESCM(RawPacket pkt, int index) {
        int ssrc = pkt.getRTCPSSRC();
        this.ivStore[0] = this.saltKey[0];
        this.ivStore[1] = this.saltKey[1];
        this.ivStore[2] = this.saltKey[2];
        this.ivStore[3] = this.saltKey[3];
        this.ivStore[4] = (byte)(ssrc >> 24 & 0xFF ^ this.saltKey[4]);
        this.ivStore[5] = (byte)(ssrc >> 16 & 0xFF ^ this.saltKey[5]);
        this.ivStore[6] = (byte)(ssrc >> 8 & 0xFF ^ this.saltKey[6]);
        this.ivStore[7] = (byte)(ssrc & 0xFF ^ this.saltKey[7]);
        this.ivStore[8] = this.saltKey[8];
        this.ivStore[9] = this.saltKey[9];
        this.ivStore[10] = (byte)(index >> 24 & 0xFF ^ this.saltKey[10]);
        this.ivStore[11] = (byte)(index >> 16 & 0xFF ^ this.saltKey[11]);
        this.ivStore[12] = (byte)(index >> 8 & 0xFF ^ this.saltKey[12]);
        this.ivStore[13] = (byte)(index & 0xFF ^ this.saltKey[13]);
        this.ivStore[15] = 0;
        this.ivStore[14] = 0;
        int payloadOffset = 8;
        int payloadLength = pkt.getLength() - 8;
        this.cipherCtr.process(this.cipher, pkt.getBuffer(), pkt.getOffset() + 8, payloadLength, this.ivStore);
    }

    public void processPacketAESF8(RawPacket pkt, int index) {
        this.ivStore[0] = 0;
        this.ivStore[1] = 0;
        this.ivStore[2] = 0;
        this.ivStore[3] = 0;
        this.ivStore[4] = (byte)((index |= Integer.MIN_VALUE) >> 24);
        this.ivStore[5] = (byte)(index >> 16);
        this.ivStore[6] = (byte)(index >> 8);
        this.ivStore[7] = (byte)index;
        System.arraycopy(pkt.getBuffer(), pkt.getOffset(), this.ivStore, 8, 8);
        int payloadOffset = 8;
        int payloadLength = pkt.getLength() - (4 + this.policy.getAuthTagLength());
        SRTPCipherF8.process(this.cipher, pkt.getBuffer(), pkt.getOffset() + 8, payloadLength, this.ivStore, this.cipherF8);
    }

    private void authenticatePacket(RawPacket pkt, int index) {
        this.mac.update(pkt.getBuffer(), 0, pkt.getLength());
        this.rbStore[0] = (byte)(index >> 24);
        this.rbStore[1] = (byte)(index >> 16);
        this.rbStore[2] = (byte)(index >> 8);
        this.rbStore[3] = (byte)index;
        this.mac.update(this.rbStore, 0, this.rbStore.length);
        this.mac.doFinal(this.tagStore, 0);
    }

    boolean checkReplay(int index) {
        long delta = index - this.receivedIndex;
        if (delta > 0L) {
            return true;
        }
        if (-delta > 64L) {
            return false;
        }
        return (this.replayWindow >> (int)(-delta) & 1L) == 0L;
    }

    private void computeIv(byte label) {
        for (int i = 0; i < 14; ++i) {
            this.ivStore[i] = this.masterSalt[i];
        }
        this.ivStore[7] = (byte)(this.ivStore[7] ^ label);
        this.ivStore[15] = 0;
        this.ivStore[14] = 0;
    }

    public void deriveSrtcpKeys() {
        byte label = 3;
        this.computeIv(label);
        KeyParameter encryptionKey = new KeyParameter(this.masterKey);
        this.cipher.init(true, (CipherParameters)encryptionKey);
        Arrays.fill(this.masterKey, (byte)0);
        this.cipherCtr.getCipherStream(this.cipher, this.encKey, this.policy.getEncKeyLength(), this.ivStore);
        if (this.authKey != null) {
            label = 4;
            this.computeIv(label);
            this.cipherCtr.getCipherStream(this.cipher, this.authKey, this.policy.getAuthKeyLength(), this.ivStore);
            switch (this.policy.getAuthType()) {
                case 1: {
                    KeyParameter key = new KeyParameter(this.authKey);
                    this.mac.init((CipherParameters)key);
                    break;
                }
                case 2: {
                    ParametersForSkein pfs = new ParametersForSkein((CipherParameters)new KeyParameter(this.authKey), 512, this.tagStore.length * 8);
                    this.mac.init((CipherParameters)pfs);
                }
            }
        }
        Arrays.fill(this.authKey, (byte)0);
        label = 5;
        this.computeIv(label);
        this.cipherCtr.getCipherStream(this.cipher, this.saltKey, this.policy.getSaltKeyLength(), this.ivStore);
        Arrays.fill(this.masterSalt, (byte)0);
        if (this.cipherF8 != null) {
            SRTPCipherF8.deriveForIV(this.cipherF8, this.encKey, this.saltKey);
        }
        encryptionKey = new KeyParameter(this.encKey);
        this.cipher.init(true, (CipherParameters)encryptionKey);
        Arrays.fill(this.encKey, (byte)0);
    }

    private void update(int index) {
        int delta = this.receivedIndex - index;
        if (delta > 0) {
            this.replayWindow <<= delta;
            this.replayWindow |= 1L;
        } else {
            this.replayWindow |= (long)(1 << delta);
        }
        this.receivedIndex = index;
    }

    public SRTCPCryptoContext deriveContext(int ssrc) {
        return new SRTCPCryptoContext(ssrc, this.masterKey, this.masterSalt, this.policy);
    }
}

