/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.colibri;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.RTPLevelRelayType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ParameterPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.service.neomedia.MediaDirection;
import org.jivesoftware.smack.packet.IQ;

public class ColibriConferenceIQ
extends IQ {
    public static final String ELEMENT_NAME = "conference";
    public static final String ID_ATTR_NAME = "id";
    public static final String NAMESPACE = "http://jitsi.org/protocol/colibri";
    public static final int[] NO_SSRCS = new int[0];
    private final List<Content> contents = new LinkedList<Content>();
    private String id;

    public boolean addContent(String contentName) {
        return this.addContent(new Content(contentName));
    }

    public boolean addContent(Content content) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        return this.contents.contains(content) ? false : this.contents.add(content);
    }

    public String getChildElementXML() {
        List<Content> contents;
        StringBuilder xml = new StringBuilder();
        xml.append('<').append(ELEMENT_NAME);
        xml.append(" xmlns='").append(NAMESPACE).append('\'');
        String id = this.getID();
        if (id != null) {
            xml.append(' ').append(ID_ATTR_NAME).append("='").append(id).append('\'');
        }
        if ((contents = this.getContents()).size() == 0) {
            xml.append(" />");
        } else {
            xml.append('>');
            for (Content content : contents) {
                content.toXML(xml);
            }
            xml.append("</").append(ELEMENT_NAME).append('>');
        }
        return xml.toString();
    }

    public Content getContent(String contentName) {
        for (Content content : this.getContents()) {
            if (!contentName.equals(content.getName())) continue;
            return content;
        }
        return null;
    }

    public List<Content> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    public String getID() {
        return this.id;
    }

    public Content getOrCreateContent(String contentName) {
        Content content = this.getContent(contentName);
        if (content == null) {
            content = new Content(contentName);
            this.addContent(content);
        }
        return content;
    }

    public boolean removeContent(Content content) {
        return this.contents.remove(content);
    }

    public void setID(String id) {
        this.id = id;
    }

    public static class SctpConnection
    extends ChannelCommon {
        public static final String ELEMENT_NAME = "sctpconnection";
        public static final String PORT_ATTR_NAME = "port";
        private int port = 5000;

        public SctpConnection() {
            super(ELEMENT_NAME);
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        @Override
        protected void printAttributes(StringBuilder xml) {
            xml.append(' ').append(PORT_ATTR_NAME).append("='").append(this.getPort()).append('\'');
        }

        @Override
        protected boolean hasContent() {
            return false;
        }

        @Override
        protected void printContent(StringBuilder xml) {
        }
    }

    public static class Content {
        public static final String ELEMENT_NAME = "content";
        public static final String NAME_ATTR_NAME = "name";
        private final List<Channel> channels = new LinkedList<Channel>();
        private final List<SctpConnection> sctpConnections = new LinkedList<SctpConnection>();
        private String name;

        public Content() {
        }

        public Content(String name) {
            this.setName(name);
        }

        public boolean addChannel(Channel channel) {
            if (channel == null) {
                throw new NullPointerException("channel");
            }
            return this.channels.contains(channel) ? false : this.channels.add(channel);
        }

        public Channel getChannel(int channelIndex) {
            return this.getChannels().get(channelIndex);
        }

        public Channel getChannel(String channelID) {
            for (Channel channel : this.getChannels()) {
                if (!channelID.equals(channel.getID())) continue;
                return channel;
            }
            return null;
        }

        public int getChannelCount() {
            return this.getChannels().size();
        }

        public List<Channel> getChannels() {
            return Collections.unmodifiableList(this.channels);
        }

        public boolean addSctpConnection(SctpConnection conn) {
            if (conn == null) {
                throw new NullPointerException("Sctp connection");
            }
            return !this.sctpConnections.contains(conn) && this.sctpConnections.add(conn);
        }

        public List<SctpConnection> getSctpConnections() {
            return Collections.unmodifiableList(this.sctpConnections);
        }

        public String getName() {
            return this.name;
        }

        public boolean removeChannel(Channel channel) {
            return this.channels.remove(channel);
        }

        public void setName(String name) {
            if (name == null) {
                throw new NullPointerException(NAME_ATTR_NAME);
            }
            this.name = name;
        }

        public void toXML(StringBuilder xml) {
            xml.append('<').append(ELEMENT_NAME);
            xml.append(' ').append(NAME_ATTR_NAME).append("='").append(this.getName()).append('\'');
            List<Channel> channels = this.getChannels();
            List<SctpConnection> connections = this.getSctpConnections();
            if (channels.size() == 0 && connections.size() == 0) {
                xml.append(" />");
            } else {
                xml.append('>');
                for (Channel channel : channels) {
                    channel.toXML(xml);
                }
                for (SctpConnection conn : connections) {
                    conn.toXML(xml);
                }
                xml.append("</").append(ELEMENT_NAME).append('>');
            }
        }
    }

    public static class Channel
    extends ChannelCommon {
        public static final String DIRECTION_ATTR_NAME = "direction";
        public static final String ELEMENT_NAME = "channel";
        @Deprecated
        public static final String HOST_ATTR_NAME = "host";
        public static final String ID_ATTR_NAME = "id";
        public static final String LAST_N_ATTR_NAME = "last-n";
        @Deprecated
        public static final String RTCP_PORT_ATTR_NAME = "rtcpport";
        public static final String RTP_LEVEL_RELAY_TYPE_ATTR_NAME = "rtp-level-relay-type";
        @Deprecated
        public static final String RTP_PORT_ATTR_NAME = "rtpport";
        public static final String SSRC_ELEMENT_NAME = "ssrc";
        private MediaDirection direction;
        @Deprecated
        private String host;
        private String id;
        private Integer lastN;
        private final List<PayloadTypePacketExtension> payloadTypes = new ArrayList<PayloadTypePacketExtension>();
        @Deprecated
        private int rtcpPort;
        private RTPLevelRelayType rtpLevelRelayType;
        @Deprecated
        private int rtpPort;
        private final List<SourcePacketExtension> sources = new LinkedList<SourcePacketExtension>();
        private int[] ssrcs = NO_SSRCS;

        public Channel() {
            super(ELEMENT_NAME);
        }

        public boolean addPayloadType(PayloadTypePacketExtension payloadType) {
            if (payloadType == null) {
                throw new NullPointerException("payloadType");
            }
            payloadType.setNamespace(null);
            for (ParameterPacketExtension p : payloadType.getParameters()) {
                p.setNamespace(null);
            }
            return this.payloadTypes.contains(payloadType) ? false : this.payloadTypes.add(payloadType);
        }

        public synchronized boolean addSource(SourcePacketExtension source) {
            if (source == null) {
                throw new NullPointerException("source");
            }
            return this.sources.contains(source) ? false : this.sources.add(source);
        }

        public synchronized boolean addSSRC(int ssrc) {
            for (int i = 0; i < this.ssrcs.length; ++i) {
                if (this.ssrcs[i] != ssrc) continue;
                return false;
            }
            int[] newSSRCs = new int[this.ssrcs.length + 1];
            System.arraycopy(this.ssrcs, 0, newSSRCs, 0, this.ssrcs.length);
            newSSRCs[this.ssrcs.length] = ssrc;
            this.ssrcs = newSSRCs;
            return true;
        }

        public MediaDirection getDirection() {
            return this.direction == null ? MediaDirection.SENDRECV : this.direction;
        }

        @Deprecated
        public String getHost() {
            return this.host;
        }

        public String getID() {
            return this.id;
        }

        public Integer getLastN() {
            return this.lastN;
        }

        public List<PayloadTypePacketExtension> getPayloadTypes() {
            return Collections.unmodifiableList(this.payloadTypes);
        }

        @Deprecated
        public int getRTCPPort() {
            return this.rtcpPort;
        }

        public RTPLevelRelayType getRTPLevelRelayType() {
            return this.rtpLevelRelayType;
        }

        @Deprecated
        public int getRTPPort() {
            return this.rtpPort;
        }

        public synchronized List<SourcePacketExtension> getSources() {
            return new ArrayList<SourcePacketExtension>(this.sources);
        }

        public synchronized int[] getSSRCs() {
            return this.ssrcs.length == 0 ? NO_SSRCS : (int[])this.ssrcs.clone();
        }

        public boolean removePayloadType(PayloadTypePacketExtension payloadType) {
            return this.payloadTypes.remove(payloadType);
        }

        public synchronized boolean removeSource(SourcePacketExtension source) {
            return this.sources.remove(source);
        }

        public synchronized boolean removeSSRC(int ssrc) {
            if (this.ssrcs.length == 1) {
                if (this.ssrcs[0] == ssrc) {
                    this.ssrcs = NO_SSRCS;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.ssrcs.length; ++i) {
                if (this.ssrcs[i] != ssrc) continue;
                int[] newSSRCs = new int[this.ssrcs.length - 1];
                if (i != 0) {
                    System.arraycopy(this.ssrcs, 0, newSSRCs, 0, i);
                }
                if (i != newSSRCs.length) {
                    System.arraycopy(this.ssrcs, i + 1, newSSRCs, i, newSSRCs.length - i);
                }
                this.ssrcs = newSSRCs;
                return true;
            }
            return false;
        }

        public void setDirection(MediaDirection direction) {
            this.direction = direction;
        }

        @Deprecated
        public void setHost(String host) {
            this.host = host;
        }

        public void setID(String id) {
            this.id = id;
        }

        public void setLastN(Integer lastN) {
            this.lastN = lastN;
        }

        @Deprecated
        public void setRTCPPort(int rtcpPort) {
            this.rtcpPort = rtcpPort;
        }

        public void setRTPLevelRelayType(RTPLevelRelayType rtpLevelRelayType) {
            this.rtpLevelRelayType = rtpLevelRelayType;
        }

        public void setRTPLevelRelayType(String s) {
            this.setRTPLevelRelayType(RTPLevelRelayType.parseRTPLevelRelayType(s));
        }

        @Deprecated
        public void setRTPPort(int rtpPort) {
            this.rtpPort = rtpPort;
        }

        public void setSSRCs(int[] ssrcs) {
            this.ssrcs = ssrcs == null || ssrcs.length == 0 ? NO_SSRCS : (int[])ssrcs.clone();
        }

        @Override
        protected void printAttributes(StringBuilder xml) {
            int rtpPort;
            RTPLevelRelayType rtpLevelRelayType;
            int rtcpPort;
            Integer lastN;
            String id;
            String host;
            MediaDirection direction = this.getDirection();
            if (direction != null && direction != MediaDirection.SENDRECV) {
                xml.append(' ').append(DIRECTION_ATTR_NAME).append("='").append(direction.toString()).append('\'');
            }
            if ((host = this.getHost()) != null) {
                xml.append(' ').append(HOST_ATTR_NAME).append("='").append(host).append('\'');
            }
            if ((id = this.getID()) != null) {
                xml.append(' ').append("id").append("='").append(id).append('\'');
            }
            if ((lastN = this.getLastN()) != null) {
                xml.append(' ').append(LAST_N_ATTR_NAME).append("='").append(lastN).append('\'');
            }
            if ((rtcpPort = this.getRTCPPort()) > 0) {
                xml.append(' ').append(RTCP_PORT_ATTR_NAME).append("='").append(rtcpPort).append('\'');
            }
            if ((rtpLevelRelayType = this.getRTPLevelRelayType()) != null) {
                xml.append(' ').append(RTP_LEVEL_RELAY_TYPE_ATTR_NAME).append("='").append((Object)rtpLevelRelayType).append('\'');
            }
            if ((rtpPort = this.getRTPPort()) > 0) {
                xml.append(' ').append(RTP_PORT_ATTR_NAME).append("='").append(rtpPort).append('\'');
            }
        }

        @Override
        protected boolean hasContent() {
            List<PayloadTypePacketExtension> payloadTypes = this.getPayloadTypes();
            boolean hasPayloadTypes = !payloadTypes.isEmpty();
            List<SourcePacketExtension> sources = this.getSources();
            boolean hasSources = !sources.isEmpty();
            int[] ssrcs = this.getSSRCs();
            boolean hasSSRCs = ssrcs.length != 0;
            return hasPayloadTypes || hasSources || hasSSRCs;
        }

        @Override
        protected void printContent(StringBuilder xml) {
            List<PayloadTypePacketExtension> payloadTypes = this.getPayloadTypes();
            List<SourcePacketExtension> sources = this.getSources();
            int[] ssrcs = this.getSSRCs();
            for (PayloadTypePacketExtension payloadType : payloadTypes) {
                xml.append(payloadType.toXML());
            }
            for (SourcePacketExtension source : sources) {
                xml.append(source.toXML());
            }
            for (int i = 0; i < ssrcs.length; ++i) {
                xml.append('<').append(SSRC_ELEMENT_NAME).append('>').append(Long.toString((long)ssrcs[i] & 0xFFFFFFFFL)).append("</").append(SSRC_ELEMENT_NAME).append('>');
            }
        }
    }

    public static abstract class ChannelCommon {
        public static final String ENDPOINT_ATTR_NAME = "endpoint";
        public static final String EXPIRE_ATTR_NAME = "expire";
        public static final int EXPIRE_NOT_SPECIFIED = -1;
        public static final String INITIATOR_ATTR_NAME = "initiator";
        private String endpoint;
        private int expire = -1;
        private Boolean initiator;
        private IceUdpTransportPacketExtension transport;
        private String elementName;

        protected ChannelCommon(String elementName) {
            this.elementName = elementName;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public int getExpire() {
            return this.expire;
        }

        public IceUdpTransportPacketExtension getTransport() {
            return this.transport;
        }

        public Boolean isInitiator() {
            return this.initiator;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setExpire(int expire) {
            if (expire != -1 && expire < 0) {
                throw new IllegalArgumentException(EXPIRE_ATTR_NAME);
            }
            this.expire = expire;
        }

        public void setInitiator(Boolean initiator) {
            this.initiator = initiator;
        }

        public void setTransport(IceUdpTransportPacketExtension transport) {
            this.transport = transport;
        }

        protected abstract void printAttributes(StringBuilder var1);

        protected abstract boolean hasContent();

        protected abstract void printContent(StringBuilder var1);

        public void toXML(StringBuilder xml) {
            boolean hasTransport;
            Boolean initiator;
            int expire;
            xml.append('<').append(this.elementName);
            String endpoint = this.getEndpoint();
            if (endpoint != null) {
                xml.append(' ').append(ENDPOINT_ATTR_NAME).append("='").append(endpoint).append('\'');
            }
            if ((expire = this.getExpire()) >= 0) {
                xml.append(' ').append(EXPIRE_ATTR_NAME).append("='").append(expire).append('\'');
            }
            if ((initiator = this.isInitiator()) != null) {
                xml.append(' ').append(INITIATOR_ATTR_NAME).append("='").append(initiator).append('\'');
            }
            this.printAttributes(xml);
            IceUdpTransportPacketExtension transport = this.getTransport();
            boolean bl = hasTransport = transport != null;
            if (hasTransport || this.hasContent()) {
                xml.append('>');
                if (this.hasContent()) {
                    this.printContent(xml);
                }
                if (hasTransport) {
                    xml.append(transport.toXML());
                }
                xml.append("</").append(this.elementName).append('>');
            } else {
                xml.append(" />");
            }
        }
    }
}

