/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.ulaw;

import com.ibm.media.codec.audio.AudioCodec;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    private static final byte[] lutTableH = new byte[256];
    private static final byte[] lutTableL = new byte[256];

    public JavaDecoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("ULAW")};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "Mu-Law Decoder";
    }

    @Override
    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Object[]{new SilenceSuppressionAdapter(this, false, false)};
        }
        return this.controls;
    }

    @Override
    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", af.getSampleRate(), 16, af.getChannels(), 0, 1)};
        return this.supportedOutputFormats;
    }

    private void initTables() {
        for (int i = 0; i < 256; ++i) {
            int input = ~i;
            int mantissa = ((input & 0xF) << 3) + 132;
            int segment = (input & 0x70) >> 4;
            int value = mantissa << segment;
            value -= 132;
            if ((input & 0x80) != 0) {
                value = -value;
            }
            JavaDecoder.lutTableL[i] = (byte)value;
            JavaDecoder.lutTableH[i] = (byte)(value >> 8);
        }
    }

    @Override
    public void open() {
        this.initTables();
    }

    @Override
    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        byte[] inData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, inData.length * 2);
        int inpLength = inputBuffer.getLength();
        int outLength = 2 * inpLength;
        int inOffset = inputBuffer.getOffset();
        int outOffset = outputBuffer.getOffset();
        for (int i = 0; i < inpLength; ++i) {
            int temp = inData[inOffset++] & 0xFF;
            outData[outOffset++] = lutTableL[temp];
            outData[outOffset++] = lutTableH[temp];
        }
        this.updateOutput(outputBuffer, this.outputFormat, outLength, outputBuffer.getOffset());
        return 0;
    }
}

