/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.jinglesdp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ParameterPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RTPHdrExtPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RemoteCandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.service.protocol.media.DynamicPayloadTypeRegistry;
import net.java.sip.communicator.service.protocol.media.DynamicRTPExtensionsRegistry;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.format.AudioMediaFormat;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.service.neomedia.format.MediaFormatFactory;

public class JingleUtils {
    private static final Logger logger = Logger.getLogger(JingleUtils.class);

    public static RtpDescriptionPacketExtension getRtpDescription(ContentPacketExtension content) {
        return content.getFirstChildOfType(RtpDescriptionPacketExtension.class);
    }

    public static List<MediaFormat> extractFormats(RtpDescriptionPacketExtension description, DynamicPayloadTypeRegistry ptRegistry) {
        ArrayList<MediaFormat> mediaFmts = new ArrayList<MediaFormat>();
        List<PayloadTypePacketExtension> payloadTypes = description.getPayloadTypes();
        for (PayloadTypePacketExtension ptExt : payloadTypes) {
            MediaFormat format = JingleUtils.payloadTypeToMediaFormat(ptExt, ptRegistry);
            if (format == null) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Unsupported remote format: " + ptExt.toXML()));
                continue;
            }
            mediaFmts.add(format);
        }
        return mediaFmts;
    }

    public static MediaFormat payloadTypeToMediaFormat(PayloadTypePacketExtension payloadType, DynamicPayloadTypeRegistry ptRegistry) {
        return JingleUtils.payloadTypeToMediaFormat(payloadType, JabberActivator.getMediaService(), ptRegistry);
    }

    public static MediaFormat payloadTypeToMediaFormat(PayloadTypePacketExtension payloadType, MediaService mediaService, DynamicPayloadTypeRegistry ptRegistry) {
        byte pt = (byte)payloadType.getID();
        boolean unknown = false;
        List<ParameterPacketExtension> params = payloadType.getParameters();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        HashMap<String, String> advancedMap = new HashMap<String, String>();
        for (ParameterPacketExtension param : params) {
            String paramName = param.getName();
            if ("imageattr".equals(paramName)) {
                advancedMap.put(paramName, param.getValue());
                continue;
            }
            paramsMap.put(paramName, param.getValue());
        }
        for (String attr : payloadType.getAttributeNames()) {
            if (!attr.equals("width") && !attr.equals("height")) continue;
            paramsMap.put(attr, payloadType.getAttributeAsString(attr));
        }
        MediaFormatFactory formatFactory = mediaService.getFormatFactory();
        MediaFormat format = formatFactory.createMediaFormat(pt, payloadType.getName(), (double)payloadType.getClockrate(), payloadType.getChannels(), -1.0f, paramsMap, advancedMap);
        if (format == null) {
            unknown = true;
            format = formatFactory.createUnknownMediaFormat(MediaType.AUDIO);
        }
        if (ptRegistry != null && pt >= 96 && pt <= 127) {
            ptRegistry.addMapping(format, pt);
        }
        return unknown ? null : format;
    }

    public static List<RTPExtension> extractRTPExtensions(RtpDescriptionPacketExtension desc, DynamicRTPExtensionsRegistry extMap) {
        ArrayList<RTPExtension> extensionsList = new ArrayList<RTPExtension>();
        List<RTPHdrExtPacketExtension> extmapList = desc.getExtmapList();
        for (RTPHdrExtPacketExtension extmap : extmapList) {
            RTPExtension rtpExtension = new RTPExtension(extmap.getURI(), JingleUtils.getDirection(extmap.getSenders(), false), extmap.getAttributes());
            if (rtpExtension == null) continue;
            extensionsList.add(rtpExtension);
        }
        return extensionsList;
    }

    public static ContentPacketExtension.SendersEnum getSenders(MediaDirection direction, boolean initiatorPerspective) {
        if (direction == MediaDirection.SENDRECV) {
            return ContentPacketExtension.SendersEnum.both;
        }
        if (direction == MediaDirection.INACTIVE) {
            return ContentPacketExtension.SendersEnum.none;
        }
        if (initiatorPerspective) {
            if (direction == MediaDirection.SENDONLY) {
                return ContentPacketExtension.SendersEnum.initiator;
            }
            return ContentPacketExtension.SendersEnum.responder;
        }
        if (direction == MediaDirection.SENDONLY) {
            return ContentPacketExtension.SendersEnum.responder;
        }
        return ContentPacketExtension.SendersEnum.initiator;
    }

    public static MediaDirection getDirection(ContentPacketExtension content, boolean initiatorPerspective) {
        ContentPacketExtension.SendersEnum senders = content.getSenders();
        return JingleUtils.getDirection(senders, initiatorPerspective);
    }

    public static MediaDirection getDirection(ContentPacketExtension.SendersEnum senders, boolean initiatorPerspective) {
        if (senders == null) {
            return MediaDirection.SENDRECV;
        }
        if (senders == ContentPacketExtension.SendersEnum.initiator) {
            if (initiatorPerspective) {
                return MediaDirection.SENDONLY;
            }
            return MediaDirection.RECVONLY;
        }
        if (senders == ContentPacketExtension.SendersEnum.responder) {
            if (initiatorPerspective) {
                return MediaDirection.RECVONLY;
            }
            return MediaDirection.SENDONLY;
        }
        if (senders == ContentPacketExtension.SendersEnum.both) {
            return MediaDirection.SENDRECV;
        }
        return MediaDirection.INACTIVE;
    }

    public static MediaStreamTarget extractDefaultTarget(ContentPacketExtension content) {
        IceUdpTransportPacketExtension transport = content.getFirstChildOfType(IceUdpTransportPacketExtension.class);
        return transport == null ? null : JingleUtils.extractDefaultTarget(transport);
    }

    public static MediaStreamTarget extractDefaultTarget(IceUdpTransportPacketExtension transport) {
        InetSocketAddress rtcpTarget;
        CandidatePacketExtension rtpCand = JingleUtils.getFirstCandidate(transport, 1);
        if (rtpCand == null) {
            return null;
        }
        InetAddress rtpAddress = null;
        try {
            rtpAddress = NetworkUtils.getInetAddress((String)rtpCand.getIP());
        }
        catch (UnknownHostException exc) {
            throw new IllegalArgumentException("Failed to parse address " + rtpCand.getIP(), exc);
        }
        int rtpPort = rtpCand.getPort();
        InetSocketAddress rtpTarget = new InetSocketAddress(rtpAddress, rtpPort);
        CandidatePacketExtension rtcpCand = JingleUtils.getFirstCandidate(transport, 2);
        if (rtcpCand == null) {
            rtcpTarget = new InetSocketAddress(rtpAddress, rtpPort + 1);
        } else {
            InetAddress rtcpAddress = null;
            try {
                rtcpAddress = NetworkUtils.getInetAddress((String)rtcpCand.getIP());
            }
            catch (UnknownHostException exc) {
                throw new IllegalArgumentException("Failed to parse address " + rtcpCand.getIP(), exc);
            }
            int rtcpPort = rtcpCand.getPort();
            rtcpTarget = new InetSocketAddress(rtcpAddress, rtcpPort);
        }
        return new MediaStreamTarget(rtpTarget, rtcpTarget);
    }

    public static CandidatePacketExtension getFirstCandidate(ContentPacketExtension content, int componentID) {
        IceUdpTransportPacketExtension transport = content.getFirstChildOfType(IceUdpTransportPacketExtension.class);
        return transport == null ? null : JingleUtils.getFirstCandidate(transport, componentID);
    }

    public static CandidatePacketExtension getFirstCandidate(IceUdpTransportPacketExtension transport, int componentID) {
        for (CandidatePacketExtension cand : transport.getCandidateList()) {
            if (cand instanceof RemoteCandidatePacketExtension || cand.getComponent() != componentID) continue;
            return cand;
        }
        return null;
    }

    public static ContentPacketExtension createDescription(ContentPacketExtension.CreatorEnum creator, String contentName, ContentPacketExtension.SendersEnum senders, List<MediaFormat> formats, List<RTPExtension> rtpExtensions, DynamicPayloadTypeRegistry dynamicPayloadTypes, DynamicRTPExtensionsRegistry rtpExtensionsRegistry) {
        ContentPacketExtension content = new ContentPacketExtension();
        RtpDescriptionPacketExtension description = new RtpDescriptionPacketExtension();
        content.setCreator(creator);
        content.setName(contentName);
        if (senders != null && senders != ContentPacketExtension.SendersEnum.both) {
            content.setSenders(senders);
        }
        content.addChildExtension(description);
        description.setMedia(formats.get(0).getMediaType().toString());
        for (MediaFormat fmt : formats) {
            description.addPayloadType(JingleUtils.formatToPayloadType(fmt, dynamicPayloadTypes));
        }
        if (rtpExtensions != null && rtpExtensions.size() > 0) {
            for (RTPExtension extension : rtpExtensions) {
                byte extID = rtpExtensionsRegistry.obtainExtensionMapping(extension);
                URI uri = extension.getURI();
                MediaDirection extDirection = extension.getDirection();
                String attributes = extension.getExtensionAttributes();
                ContentPacketExtension.SendersEnum sendersEnum = JingleUtils.getSenders(extDirection, false);
                RTPHdrExtPacketExtension ext = new RTPHdrExtPacketExtension();
                ext.setURI(uri);
                ext.setSenders(sendersEnum);
                ext.setID(Byte.toString(extID));
                ext.setAttributes(attributes);
                description.addChildExtension(ext);
            }
        }
        return content;
    }

    public static PayloadTypePacketExtension formatToPayloadType(MediaFormat format, DynamicPayloadTypeRegistry ptRegistry) {
        ParameterPacketExtension ext;
        PayloadTypePacketExtension ptExt = new PayloadTypePacketExtension();
        byte payloadType = format.getRTPPayloadType();
        if (payloadType == -1) {
            payloadType = ptRegistry.obtainPayloadTypeNumber(format);
        }
        ptExt.setId(payloadType);
        ptExt.setName(format.getEncoding());
        if (format instanceof AudioMediaFormat) {
            ptExt.setChannels(((AudioMediaFormat)format).getChannels());
        }
        ptExt.setClockrate((int)format.getClockRate());
        for (Map.Entry entry : format.getFormatParameters().entrySet()) {
            ext = new ParameterPacketExtension();
            ext.setName((String)entry.getKey());
            ext.setValue((String)entry.getValue());
            ptExt.addParameter(ext);
        }
        for (Map.Entry entry : format.getAdvancedAttributes().entrySet()) {
            ext = new ParameterPacketExtension();
            ext.setName((String)entry.getKey());
            ext.setValue((String)entry.getValue());
            ptExt.addParameter(ext);
        }
        return ptExt;
    }

    public static MediaType getMediaType(ContentPacketExtension content) {
        String mediaTypeStr;
        if (content == null) {
            return null;
        }
        RtpDescriptionPacketExtension desc = JingleUtils.getRtpDescription(content);
        if (desc != null && (mediaTypeStr = desc.getMedia()) != null) {
            return MediaType.parseString((String)mediaTypeStr);
        }
        return null;
    }
}

