/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.util.HashSet;
import java.util.Set;
import weblogic.xml.babel.baseparser.SymbolTable;
import weblogic.xml.babel.baseparser.SymbolTableException;
import weblogic.xml.babel.stream.CanonicalWriter;

public class ScopeManager {
    private SymbolTable namespaces = new SymbolTable();
    private Set needToWrite = new HashSet();

    public ScopeManager() {
        this.namespaces.openScope();
        this.namespaces.put("xmlns", "");
    }

    public void put(String string, String string2) {
        this.namespaces.put(string, string2);
    }

    public boolean inRootElement() {
        return this.namespaces.getDepth() > 1;
    }

    public void checkPrefixMap(String string, String string2) {
        if ("xml".equals(string) && CanonicalWriter.XML_PREFIX_NS.equals(string2)) {
            return;
        }
        string = this.getPrefix(string);
        String string3 = null;
        try {
            string3 = this.namespaces.get(string);
        }
        catch (SymbolTableException symbolTableException) {
            // empty catch block
        }
        if (string3 == null || !string3.equals(string2)) {
            this.needToWrite.add(string);
            this.namespaces.put(string, string2);
        }
    }

    public boolean needToWriteNS(String string) {
        string = this.getPrefix(string);
        return this.needToWrite.contains(string);
    }

    private String getPrefix(String string) {
        if (string.equals("")) {
            return "xmlns";
        }
        return string;
    }

    public void wroteNS(String string) {
        this.needToWrite.remove(string);
    }

    public void openScope() {
        this.namespaces.openScope();
    }

    public void closeScope() {
        this.namespaces.closeScope();
    }
}

