/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import weblogic.utils.PlatformConstants;

public interface NestedThrowable {
    public Throwable getNested();

    public String superToString();

    public void superPrintStackTrace(PrintStream var1);

    public void superPrintStackTrace(PrintWriter var1);

    public static class Util {
        public static String toString(NestedThrowable nestedThrowable) {
            Throwable throwable = nestedThrowable.getNested();
            if (throwable == null) {
                return nestedThrowable.superToString();
            }
            return nestedThrowable.superToString() + " - with nested exception:" + PlatformConstants.EOL + "[" + Util.nestedToString(throwable) + "]";
        }

        private static String nestedToString(Throwable throwable) {
            if (throwable instanceof InvocationTargetException) {
                InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
                return throwable.toString() + " - with target exception:" + PlatformConstants.EOL + "[" + invocationTargetException.getTargetException().toString() + "]";
            }
            return throwable.toString();
        }

        public static void printStackTrace(NestedThrowable nestedThrowable, PrintStream printStream) {
            Throwable throwable = nestedThrowable.getNested();
            if (throwable != null) {
                throwable.printStackTrace(printStream);
                printStream.println("--------------- nested within: ------------------");
            }
            nestedThrowable.superPrintStackTrace(printStream);
        }

        public static void printStackTrace(NestedThrowable nestedThrowable, PrintWriter printWriter) {
            Throwable throwable = nestedThrowable.getNested();
            if (throwable != null) {
                throwable.printStackTrace(printWriter);
                printWriter.println("--------------- nested within: ------------------");
            }
            nestedThrowable.superPrintStackTrace(printWriter);
        }
    }
}

