/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.JDBCTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SQLExec
extends JDBCTask {
    private int goodSql;
    private int totalSql;
    private Connection conn;
    private Vector filesets;
    private Statement statement;
    private File srcFile;
    private String sqlCommand;
    private Vector transactions;
    private String delimiter;
    private String delimiterType;
    private boolean print;
    private boolean showheaders;
    private File output;
    private String onError;
    private String encoding;
    private boolean append;
    private boolean keepformat;
    private boolean escapeProcessing;

    public void setSrc(File file) {
        this.srcFile = file;
    }

    public void addText(String string) {
        this.sqlCommand = this.sqlCommand + string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public Transaction createTransaction() {
        Transaction transaction = new Transaction();
        this.transactions.addElement(transaction);
        return transaction;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setDelimiterType(DelimiterType delimiterType) {
        this.delimiterType = delimiterType.getValue();
    }

    public void setPrint(boolean bl) {
        this.print = bl;
    }

    public void setShowheaders(boolean bl) {
        this.showheaders = bl;
    }

    public void setOutput(File file) {
        this.output = file;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setOnerror(OnError onError) {
        this.onError = onError.getValue();
    }

    public void setKeepformat(boolean bl) {
        this.keepformat = bl;
    }

    public void setEscapeProcessing(boolean bl) {
        this.escapeProcessing = bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Vector vector = (Vector)this.transactions.clone();
        String string = this.sqlCommand;
        this.sqlCommand = this.sqlCommand.trim();
        try {
            Transaction transaction;
            Object object;
            DirectoryScanner directoryScanner;
            if (this.srcFile == null && this.sqlCommand.length() == 0 && this.filesets.isEmpty() && this.transactions.size() == 0) {
                throw new BuildException("Source file or fileset, transactions or sql statement must be set!", this.getLocation());
            }
            if (this.srcFile != null && !this.srcFile.exists()) {
                throw new BuildException("Source file does not exist!", this.getLocation());
            }
            int n = 0;
            block19: while (true) {
                if (n >= this.filesets.size()) {
                    Transaction transaction2 = this.createTransaction();
                    transaction2.setSrc(this.srcFile);
                    transaction2.addText(this.sqlCommand);
                    this.conn = this.getConnection();
                    if (this.isValidRdbms(this.conn)) break;
                    Object var4_15 = null;
                    this.transactions = vector;
                    this.sqlCommand = string;
                    return;
                }
                FileSet fileSet = (FileSet)this.filesets.elementAt(n);
                directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                File file = fileSet.getDir(this.getProject());
                object = directoryScanner.getIncludedFiles();
                int n2 = 0;
                while (true) {
                    if (n2 >= ((String[])object).length) {
                        ++n;
                        continue block19;
                    }
                    transaction = this.createTransaction();
                    transaction.setSrc(new File(file, object[n2]));
                    ++n2;
                }
                break;
            }
            try {
                try {
                    this.statement = this.conn.createStatement();
                    this.statement.setEscapeProcessing(this.escapeProcessing);
                    object = System.out;
                    try {
                        if (this.output != null) {
                            this.log("Opening PrintStream to output file " + this.output, 3);
                            object = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output.getAbsolutePath(), this.append)));
                        }
                        Enumeration enumeration = this.transactions.elements();
                        while (enumeration.hasMoreElements()) {
                            ((Transaction)enumeration.nextElement()).runTransaction((PrintStream)object);
                            if (this.isAutocommit()) continue;
                            this.log("Committing transaction", 3);
                            this.conn.commit();
                        }
                    }
                    catch (Throwable throwable) {
                        transaction = null;
                        if (object == null) throw throwable;
                        if (object == System.out) throw throwable;
                        ((PrintStream)object).close();
                        throw throwable;
                    }
                    {
                        transaction = null;
                        if (object != null && object != System.out) {
                            ((PrintStream)object).close();
                        }
                    }
                }
                catch (IOException iOException) {
                    if (this.isAutocommit()) throw new BuildException(iOException, this.getLocation());
                    if (this.conn == null) throw new BuildException(iOException, this.getLocation());
                    if (!this.onError.equals("abort")) throw new BuildException(iOException, this.getLocation());
                    try {
                        this.conn.rollback();
                        throw new BuildException(iOException, this.getLocation());
                    }
                    catch (SQLException sQLException) {}
                    throw new BuildException(iOException, this.getLocation());
                }
                catch (SQLException sQLException) {
                    if (this.isAutocommit()) throw new BuildException(sQLException, this.getLocation());
                    if (this.conn == null) throw new BuildException(sQLException, this.getLocation());
                    if (!this.onError.equals("abort")) throw new BuildException(sQLException, this.getLocation());
                    try {
                        this.conn.rollback();
                        throw new BuildException(sQLException, this.getLocation());
                    }
                    catch (SQLException sQLException2) {}
                    throw new BuildException(sQLException, this.getLocation());
                }
            }
            catch (Throwable throwable) {
                directoryScanner = null;
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (this.conn == null) throw throwable;
                    this.conn.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            {
                directoryScanner = null;
            }
            try {}
            catch (SQLException sQLException) {}
            if (this.statement != null) {
                this.statement.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
            this.log(this.goodSql + " of " + this.totalSql + " SQL statements executed successfully");
        }
        catch (Throwable throwable) {
            Object var4_16 = null;
            this.transactions = vector;
            this.sqlCommand = string;
            throw throwable;
        }
        {
            Object var4_17 = null;
            this.transactions = vector;
            this.sqlCommand = string;
            return;
        }
    }

    protected void runStatements(Reader reader, PrintStream printStream) throws SQLException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            StringTokenizer stringTokenizer;
            if (!this.keepformat) {
                string = string.trim();
            }
            string = this.getProject().replaceProperties(string);
            if (!this.keepformat && (string.startsWith("//") || string.startsWith("--") || (stringTokenizer = new StringTokenizer(string)).hasMoreTokens() && "REM".equalsIgnoreCase(string2 = stringTokenizer.nextToken()))) continue;
            if (!this.keepformat) {
                stringBuffer.append(" " + string);
            } else {
                stringBuffer.append("\n" + string);
            }
            if (!this.keepformat && string.indexOf("--") >= 0) {
                stringBuffer.append("\n");
            }
            if ((!this.delimiterType.equals("normal") || !stringBuffer.toString().endsWith(this.delimiter)) && (!this.delimiterType.equals("row") || !string.equals(this.delimiter))) continue;
            this.execSQL(stringBuffer.substring(0, stringBuffer.length() - this.delimiter.length()), printStream);
            stringBuffer.replace(0, stringBuffer.length(), "");
        }
        if (!stringBuffer.equals("")) {
            this.execSQL(stringBuffer.toString(), printStream);
        }
    }

    protected void execSQL(String string, PrintStream printStream) throws SQLException {
        if ("".equals(string.trim())) {
            return;
        }
        try {
            Serializable serializable;
            ++this.totalSql;
            this.log("SQL: " + string, 3);
            int n = 0;
            int n2 = 0;
            ResultSet resultSet = null;
            boolean bl = this.statement.execute(string);
            n = this.statement.getUpdateCount();
            resultSet = this.statement.getResultSet();
            do {
                if (!bl) {
                    if (n != -1) {
                        n2 += n;
                    }
                } else if (this.print) {
                    this.printResults(printStream);
                }
                bl = this.statement.getMoreResults();
                n = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
            } while (bl);
            this.log(n2 + " rows affected", 3);
            if (this.print) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(n2 + " rows affected");
                printStream.println(serializable);
            }
            serializable = this.conn.getWarnings();
            while (serializable != null) {
                this.log(serializable + " sql warning", 3);
                serializable = ((SQLWarning)serializable).getNextWarning();
            }
            this.conn.clearWarnings();
            ++this.goodSql;
        }
        catch (SQLException sQLException) {
            this.log("Failed to execute: " + string, 0);
            if (!this.onError.equals("continue")) {
                throw sQLException;
            }
            this.log(sQLException.toString(), 0);
        }
    }

    protected void printResults(PrintStream printStream) throws SQLException {
        ResultSet resultSet = null;
        resultSet = this.statement.getResultSet();
        if (resultSet != null) {
            int n;
            this.log("Processing new result set.", 3);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            StringBuffer stringBuffer = new StringBuffer();
            if (this.showheaders) {
                n = 1;
                while (n < n2) {
                    stringBuffer.append(resultSetMetaData.getColumnName(n));
                    stringBuffer.append(",");
                    ++n;
                }
                stringBuffer.append(resultSetMetaData.getColumnName(n2));
                printStream.println(stringBuffer);
                stringBuffer = new StringBuffer();
            }
            while (resultSet.next()) {
                n = 1;
                int n3 = 1;
                while (n3 <= n2) {
                    String string = resultSet.getString(n3);
                    if (string != null) {
                        string = string.trim();
                    }
                    if (n != 0) {
                        n = 0;
                    } else {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(string);
                    ++n3;
                }
                printStream.println(stringBuffer);
                stringBuffer = new StringBuffer();
            }
        }
        printStream.println();
    }

    private final /* synthetic */ void this() {
        this.goodSql = 0;
        this.totalSql = 0;
        this.conn = null;
        this.filesets = new Vector();
        this.statement = null;
        this.srcFile = null;
        this.sqlCommand = "";
        this.transactions = new Vector();
        this.delimiter = ";";
        this.delimiterType = "normal";
        this.print = false;
        this.showheaders = true;
        this.output = null;
        this.onError = "abort";
        this.encoding = null;
        this.append = false;
        this.keepformat = false;
        this.escapeProcessing = true;
    }

    public SQLExec() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Transaction {
        private File tSrcFile;
        private String tSqlCommand;

        public void setSrc(File file) {
            this.tSrcFile = file;
        }

        public void addText(String string) {
            this.tSqlCommand = this.tSqlCommand + string;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void runTransaction(PrintStream printStream) throws IOException, SQLException {
            if (this.tSqlCommand.length() != 0) {
                SQLExec.this.log("Executing commands", 2);
                SQLExec.this.runStatements(new StringReader(this.tSqlCommand), printStream);
            }
            if (this.tSrcFile == null) return;
            SQLExec.this.log("Executing file: " + this.tSrcFile.getAbsolutePath(), 2);
            InputStreamReader inputStreamReader = SQLExec.this.encoding == null ? new FileReader(this.tSrcFile) : new InputStreamReader((InputStream)new FileInputStream(this.tSrcFile), SQLExec.this.encoding);
            try {
                SQLExec.this.runStatements(inputStreamReader, printStream);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ((Reader)inputStreamReader).close();
                throw throwable;
            }
            {
                Object var4_5 = null;
            }
            ((Reader)inputStreamReader).close();
        }

        private final /* synthetic */ void this() {
            this.tSrcFile = null;
            this.tSqlCommand = "";
        }

        public Transaction() {
            this.this();
        }
    }

    public static class DelimiterType
    extends EnumeratedAttribute {
        public static final String NORMAL = "normal";
        public static final String ROW = "row";

        public String[] getValues() {
            return new String[]{NORMAL, ROW};
        }
    }

    public static class OnError
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"continue", "stop", "abort"};
        }
    }
}

