/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.parameters;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public class ExceptionResultParameters {
    public static final int TYPE = 111;
    public String className;
    public String causeClassName;
    public String message;
    public String stacktrace;

    private ExceptionResultParameters(ClientMessage flyweight) {
        boolean stackTrace_isNull;
        boolean message_isNull;
        this.className = flyweight.getStringUtf8();
        boolean causeClassName_isNull = flyweight.getBoolean();
        if (!causeClassName_isNull) {
            this.causeClassName = flyweight.getStringUtf8();
        }
        if (!(message_isNull = flyweight.getBoolean())) {
            this.message = flyweight.getStringUtf8();
        }
        if (!(stackTrace_isNull = flyweight.getBoolean())) {
            this.stacktrace = flyweight.getStringUtf8();
        }
    }

    public static ExceptionResultParameters decode(ClientMessage flyweight) {
        return new ExceptionResultParameters(flyweight);
    }

    public static ClientMessage encode(String className, String causeClassName, String message, String stacktrace) {
        int requiredDataSize = ExceptionResultParameters.calculateDataSize(className, causeClassName, message, stacktrace);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(111);
        clientMessage.set(className);
        boolean causeClassName_isNull = causeClassName == null;
        clientMessage.set(causeClassName_isNull);
        if (!causeClassName_isNull) {
            clientMessage.set(causeClassName);
        }
        boolean message_isNull = message == null;
        clientMessage.set(message_isNull);
        if (!message_isNull) {
            clientMessage.set(message);
        }
        boolean stackTrace_isNull = stacktrace == null;
        clientMessage.set(stackTrace_isNull);
        if (!stackTrace_isNull) {
            clientMessage.set(stacktrace);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static int calculateDataSize(String className, String causeClassName, String message, String stacktrace) {
        int dataSize = ClientMessage.HEADER_SIZE + ParameterUtil.calculateStringDataSize(className);
        dataSize = causeClassName == null ? ++dataSize : (dataSize += ParameterUtil.calculateStringDataSize(causeClassName));
        dataSize = message == null ? ++dataSize : (dataSize += ParameterUtil.calculateStringDataSize(message));
        dataSize = stacktrace == null ? ++dataSize : (dataSize += ParameterUtil.calculateStringDataSize(stacktrace));
        return dataSize;
    }
}

