/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapreduce.impl;

import com.hazelcast.mapreduce.impl.client.ClientCancellationRequest;
import com.hazelcast.mapreduce.impl.client.ClientJobProcessInformationRequest;
import com.hazelcast.mapreduce.impl.client.ClientMapReduceRequest;
import com.hazelcast.mapreduce.impl.task.TransferableJobProcessInformation;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FactoryIdHelper;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableHook;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collection;

public class MapReducePortableHook
implements PortableHook {
    public static final int F_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.portable.map_reduce", -23);
    public static final int CLIENT_JOB_PROCESS_INFO_REQUEST = 1;
    public static final int CLIENT_CANCELLATION_REQUEST = 2;
    public static final int CLIENT_MAP_REDUCE_REQUEST = 3;
    public static final int TRANSFERABLE_PROCESS_INFORMATION = 4;
    private static final int LENGTH = 5;

    @Override
    public int getFactoryId() {
        return F_ID;
    }

    @Override
    public PortableFactory createFactory() {
        return new PortableFactory(){
            private final ConstructorFunction<Integer, Portable>[] constructors = new ConstructorFunction[5];
            {
                this.constructors[1] = new ConstructorFunction<Integer, Portable>(){

                    @Override
                    public Portable createNew(Integer arg) {
                        return new ClientJobProcessInformationRequest();
                    }
                };
                this.constructors[2] = new ConstructorFunction<Integer, Portable>(){

                    @Override
                    public Portable createNew(Integer arg) {
                        return new ClientCancellationRequest();
                    }
                };
                this.constructors[3] = new ConstructorFunction<Integer, Portable>(){

                    @Override
                    public Portable createNew(Integer arg) {
                        return new ClientMapReduceRequest();
                    }
                };
                this.constructors[4] = new ConstructorFunction<Integer, Portable>(){

                    @Override
                    public Portable createNew(Integer arg) {
                        return new TransferableJobProcessInformation();
                    }
                };
            }

            @Override
            public Portable create(int classId) {
                return classId > 0 && classId <= this.constructors.length ? this.constructors[classId].createNew(classId) : null;
            }
        };
    }

    @Override
    public Collection<ClassDefinition> getBuiltinDefinitions() {
        return null;
    }
}

