/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.ice4j.StackProperties;
import org.ice4j.StunException;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CandidateExtendedType;
import org.ice4j.ice.CandidateTcpType;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.NetworkUtils;
import org.ice4j.ice.ServerReflexiveCandidate;
import org.ice4j.ice.TcpHostCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.GoogleTurnSSLCandidateHarvester;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.message.Message;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceTcpSocketWrapper;
import org.ice4j.socket.MultiplexingSocket;
import org.ice4j.socket.StunDatagramPacketFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexingTcpHostHarvester
extends CandidateHarvester {
    private static final Logger logger = Logger.getLogger(MultiplexingTcpHostHarvester.class.getName());
    private static final int PURGE_INTERVAL = 20;
    private static final int READ_TIMEOUT = 10000;
    private AcceptThread acceptThread;
    private boolean close = false;
    private final Map<String, WeakReference<Component>> components = new HashMap<String, WeakReference<Component>>();
    private final List<TransportAddress> localAddresses = new LinkedList<TransportAddress>();
    private final Map<InetAddress, InetAddress> mappedAddresses = new HashMap<InetAddress, InetAddress>();
    private final Set<Integer> mappedPorts = new HashSet<Integer>();
    private final List<SocketChannel> newChannels = new LinkedList<SocketChannel>();
    private int purgeCounter = 0;
    private final Selector readSelector = Selector.open();
    private ReadThread readThread;
    private final List<ServerSocketChannel> serverSocketChannels = new LinkedList<ServerSocketChannel>();
    private final boolean ssltcp;

    private static List<TransportAddress> getLocalAddresses(int port, List<NetworkInterface> interfaces) throws IOException {
        LinkedList<TransportAddress> addresses = new LinkedList<TransportAddress>();
        for (NetworkInterface iface : interfaces) {
            if (NetworkUtils.isInterfaceLoopback(iface) || !NetworkUtils.isInterfaceUp(iface) || !HostCandidateHarvester.isInterfaceAllowed(iface)) continue;
            Enumeration<InetAddress> ifaceAddresses = iface.getInetAddresses();
            while (ifaceAddresses.hasMoreElements()) {
                InetAddress addr = ifaceAddresses.nextElement();
                addresses.add(new TransportAddress(addr, port, Transport.TCP));
            }
        }
        return addresses;
    }

    public MultiplexingTcpHostHarvester(int port) throws IOException {
        this(port, false);
    }

    public MultiplexingTcpHostHarvester(int port, boolean ssltcp) throws IOException {
        this(port, Collections.list(NetworkInterface.getNetworkInterfaces()), ssltcp);
    }

    public MultiplexingTcpHostHarvester(int port, List<NetworkInterface> interfaces, boolean ssltcp) throws IOException {
        this(MultiplexingTcpHostHarvester.getLocalAddresses(port, interfaces), ssltcp);
    }

    public MultiplexingTcpHostHarvester(List<TransportAddress> transportAddresses) throws IOException {
        this(transportAddresses, false);
    }

    public MultiplexingTcpHostHarvester(List<TransportAddress> transportAddresses, boolean ssltcp) throws IOException {
        this.ssltcp = ssltcp;
        this.addLocalAddresses(transportAddresses);
        this.init();
    }

    private void addLocalAddresses(List<TransportAddress> transportAddresses) throws IOException {
        boolean useIPv6 = !StackProperties.getBoolean("org.ice4j.ipv6.DISABLED", false);
        boolean useIPv6LinkLocal = !StackProperties.getBoolean("org.ice4j.ice.harvest.DISABLE_LINK_LOCAL_ADDRESSES", false);
        String[] allowedAddressesStr = StackProperties.getStringArray("org.ice4j.ice.harvest.ALLOWED_ADDRESSES", ";");
        InetAddress[] allowedAddresses = null;
        if (allowedAddressesStr != null) {
            allowedAddresses = new InetAddress[allowedAddressesStr.length];
            for (int i = 0; i < allowedAddressesStr.length; ++i) {
                allowedAddresses[i] = InetAddress.getByName(allowedAddressesStr[i]);
            }
        }
        String[] blockedAddressesStr = StackProperties.getStringArray("org.ice4j.ice.harvest.BLOCKED_ADDRESSES", ";");
        InetAddress[] blockedAddresses = null;
        if (blockedAddressesStr != null) {
            blockedAddresses = new InetAddress[blockedAddressesStr.length];
            for (int i = 0; i < blockedAddressesStr.length; ++i) {
                blockedAddresses[i] = InetAddress.getByName(blockedAddressesStr[i]);
            }
        }
        for (TransportAddress transportAddress : transportAddresses) {
            boolean found;
            InetAddress address = transportAddress.getAddress();
            if (address.isLoopbackAddress() || !useIPv6 && address instanceof Inet6Address) continue;
            if (!useIPv6LinkLocal && address instanceof Inet6Address && address.isLinkLocalAddress()) {
                logger.info("Not using link-local address " + address + " for" + " TCP candidates.");
                continue;
            }
            if (allowedAddresses != null) {
                found = false;
                for (InetAddress allowedAddress : allowedAddresses) {
                    if (!allowedAddress.equals(address)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    logger.info("Not using " + address + " for TCP candidates, " + "because it is not in the allowed list.");
                    continue;
                }
            }
            if (blockedAddresses != null) {
                found = false;
                for (InetAddress blockedAddress : blockedAddresses) {
                    if (!blockedAddress.equals(address)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    logger.info("Not using " + address + " for TCP candidates, " + "because it is in the blocked list.");
                    continue;
                }
            }
            this.localAddresses.add(transportAddress);
        }
    }

    public void addMappedAddress(InetAddress publicAddress, InetAddress localAddress) {
        this.mappedAddresses.put(publicAddress, localAddress);
    }

    public void addMappedPort(int port) {
        this.mappedPorts.add(port);
    }

    public void close() {
        this.close = true;
    }

    private List<LocalCandidate> createLocalCandidates(Component component) {
        LinkedList<TcpHostCandidate> hostCandidates = new LinkedList<TcpHostCandidate>();
        for (TransportAddress transportAddress : this.localAddresses) {
            TcpHostCandidate tcpHostCandidate = new TcpHostCandidate(transportAddress, component);
            tcpHostCandidate.setTcpType(CandidateTcpType.PASSIVE);
            if (this.ssltcp) {
                tcpHostCandidate.setSSL(true);
            }
            hostCandidates.add(tcpHostCandidate);
        }
        LinkedList<ServerReflexiveCandidate> mappedCandidates = new LinkedList<ServerReflexiveCandidate>();
        for (Map.Entry<InetAddress, InetAddress> entry : this.mappedAddresses.entrySet()) {
            InetAddress inetAddress = entry.getValue();
            for (TcpHostCandidate base : hostCandidates) {
                TransportAddress baseTransportAddress = base.getTransportAddress();
                if (!inetAddress.equals(baseTransportAddress.getAddress())) continue;
                InetAddress publicAddress = entry.getKey();
                ServerReflexiveCandidate mappedCandidate = new ServerReflexiveCandidate(new TransportAddress(publicAddress, baseTransportAddress.getPort(), Transport.TCP), base, base.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
                if (base.isSSL()) {
                    mappedCandidate.setSSL(true);
                }
                mappedCandidate.setTcpType(CandidateTcpType.PASSIVE);
                mappedCandidates.add(mappedCandidate);
            }
        }
        LinkedList<ServerReflexiveCandidate> linkedList = new LinkedList<ServerReflexiveCandidate>();
        for (TcpHostCandidate tcpHostCandidate : hostCandidates) {
            for (Integer port : this.mappedPorts) {
                ServerReflexiveCandidate portMappedCandidate = new ServerReflexiveCandidate(new TransportAddress(tcpHostCandidate.getTransportAddress().getAddress(), (int)port, Transport.TCP), tcpHostCandidate, tcpHostCandidate.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
                if (tcpHostCandidate.isSSL()) {
                    portMappedCandidate.setSSL(true);
                }
                portMappedCandidate.setTcpType(CandidateTcpType.PASSIVE);
                linkedList.add(portMappedCandidate);
            }
        }
        for (LocalCandidate localCandidate : mappedCandidates) {
            TcpHostCandidate base = (TcpHostCandidate)localCandidate.getBase();
            for (Integer port : this.mappedPorts) {
                ServerReflexiveCandidate portMappedCandidate = new ServerReflexiveCandidate(new TransportAddress(localCandidate.getTransportAddress().getAddress(), (int)port, Transport.TCP), base, base.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
                if (base.isSSL()) {
                    portMappedCandidate.setSSL(true);
                }
                portMappedCandidate.setTcpType(CandidateTcpType.PASSIVE);
                linkedList.add(portMappedCandidate);
            }
        }
        LinkedList<LocalCandidate> linkedList2 = new LinkedList<LocalCandidate>();
        linkedList2.addAll(hostCandidates);
        linkedList2.addAll(mappedCandidates);
        linkedList2.addAll(linkedList);
        return linkedList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component getComponent(String localUfrag) {
        Map<String, WeakReference<Component>> map = this.components;
        synchronized (map) {
            WeakReference<Component> wr = this.components.get(localUfrag);
            if (wr != null) {
                Component component = (Component)wr.get();
                if (component == null) {
                    this.components.remove(localUfrag);
                }
                return component;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<LocalCandidate> harvest(Component component) {
        IceMediaStream stream = component.getParentStream();
        Agent agent = stream.getParentAgent();
        if (stream.getComponentCount() != 1 || agent.getStreamCount() != 1) {
            throw new IllegalStateException("More than one Component for an Agent, cannot harvest.");
        }
        List<LocalCandidate> candidates = this.createLocalCandidates(component);
        for (LocalCandidate candidate : candidates) {
            component.addLocalCandidate(candidate);
        }
        Map<String, WeakReference<Component>> map = this.components;
        synchronized (map) {
            this.components.put(agent.getLocalUfrag(), new WeakReference<Component>(component));
            this.purgeComponents();
        }
        return candidates;
    }

    private void init() throws IOException {
        for (TransportAddress transportAddress : this.localAddresses) {
            ServerSocketChannel channel = ServerSocketChannel.open();
            ServerSocket socket = channel.socket();
            socket.bind(new InetSocketAddress(transportAddress.getAddress(), transportAddress.getPort()));
            this.serverSocketChannels.add(channel);
        }
        this.acceptThread = new AcceptThread();
        this.acceptThread.start();
        this.readThread = new ReadThread();
        this.readThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeComponents() {
        ++this.purgeCounter;
        if (this.purgeCounter % 20 == 0) {
            Map<String, WeakReference<Component>> map = this.components;
            synchronized (map) {
                Iterator<WeakReference<Component>> i = this.components.values().iterator();
                while (i.hasNext()) {
                    if (i.next().get() != null) continue;
                    i.remove();
                }
            }
        }
    }

    private class ReadThread
    extends Thread {
        private final List<ChannelDesc> channels = new LinkedList<ChannelDesc>();

        private ReadThread() throws IOException {
            this.setName("MultiplexingTcpHostHarvester ReadThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkForNewChannels() {
            List list = MultiplexingTcpHostHarvester.this.newChannels;
            synchronized (list) {
                for (SocketChannel channel : MultiplexingTcpHostHarvester.this.newChannels) {
                    try {
                        channel.configureBlocking(false);
                        channel.register(MultiplexingTcpHostHarvester.this.readSelector, 1);
                    }
                    catch (IOException ioe) {
                        logger.info("Failed to register channel: " + ioe);
                        try {
                            channel.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    this.channels.add(new ChannelDesc(channel));
                }
                MultiplexingTcpHostHarvester.this.newChannels.clear();
            }
        }

        private void cleanup() {
            long now = System.currentTimeMillis();
            Iterator<ChannelDesc> i = this.channels.iterator();
            while (i.hasNext()) {
                ChannelDesc channelDesc = i.next();
                if (channelDesc.lastActive == -1L || now - channelDesc.lastActive <= 10000L) continue;
                i.remove();
                logger.info("Read timeout for socket: " + channelDesc.channel.socket());
                for (SelectionKey key : MultiplexingTcpHostHarvester.this.readSelector.keys()) {
                    if (!key.channel().equals(channelDesc.channel)) continue;
                    key.cancel();
                }
                try {
                    channelDesc.channel.close();
                }
                catch (IOException ioe) {
                    logger.info("Failed to close channel: " + ioe);
                }
            }
        }

        private TcpHostCandidate findCandidate(Component component, Socket socket) {
            InetAddress localAddress = socket.getLocalAddress();
            int localPort = socket.getLocalPort();
            for (LocalCandidate candidate : component.getLocalCandidates()) {
                TransportAddress transportAddress = candidate.getTransportAddress();
                if (!(candidate instanceof TcpHostCandidate) || !Transport.TCP.equals((Object)transportAddress.getTransport()) || localPort != transportAddress.getPort() || !localAddress.equals(transportAddress.getAddress())) continue;
                return (TcpHostCandidate)candidate;
            }
            return null;
        }

        private ChannelDesc findChannelDesc(SelectableChannel channel) {
            for (ChannelDesc channelDesc : this.channels) {
                if (!channelDesc.channel.equals(channel)) continue;
                return channelDesc;
            }
            return null;
        }

        private void handSocketToComponent(Socket socket, Component component, DatagramPacket datagramPacket) {
            IceProcessingState state = component.getParentStream().getParentAgent().getState();
            if (!IceProcessingState.WAITING.equals((Object)state) && !IceProcessingState.RUNNING.equals((Object)state)) {
                logger.info("Not adding a socket to an ICE agent with state " + (Object)((Object)state));
                return;
            }
            IceTcpSocketWrapper candidateSocket = null;
            IceSocketWrapper stunSocket = null;
            try {
                MultiplexingSocket multiplexing = new MultiplexingSocket(socket);
                candidateSocket = new IceTcpSocketWrapper(multiplexing);
                stunSocket = new IceTcpSocketWrapper(multiplexing.getSocket(new StunDatagramPacketFilter()));
                stunSocket = new PushBackIceSocketWrapper(stunSocket, datagramPacket);
            }
            catch (IOException ioe) {
                logger.info("Failed to create sockets: " + ioe);
            }
            TcpHostCandidate candidate = this.findCandidate(component, socket);
            if (candidate != null) {
                component.getParentStream().getParentAgent().getStunStack().addSocket(stunSocket);
                candidate.addSocket(candidateSocket);
            } else {
                logger.info("Failed to find the local candidate for socket: " + socket);
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void readFromChannel(ChannelDesc channel, SelectionKey key) {
            if (channel.buffer == null) {
                channel.buffer = MultiplexingTcpHostHarvester.this.ssltcp && !channel.sslHandshakeRead ? ByteBuffer.allocate(GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE.length) : (channel.length == -1 ? ByteBuffer.allocate(2) : ByteBuffer.allocate(channel.length));
            }
            try {
                if (channel.channel.read(channel.buffer) == -1) {
                    throw new IOException("Socket closed.");
                }
                if (channel.buffer.hasRemaining()) return;
                if (MultiplexingTcpHostHarvester.this.ssltcp && !channel.sslHandshakeRead) {
                    byte[] bytesRead = new byte[GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE.length];
                    channel.buffer.flip();
                    channel.buffer.get(bytesRead);
                    channel.buffer = null;
                    channel.sslHandshakeRead = true;
                    if (!Arrays.equals(bytesRead, GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE)) throw new IOException("Expected a pseudo ssl handshake, but received something else.");
                    ByteBuffer byteBuffer = ByteBuffer.wrap(GoogleTurnSSLCandidateHarvester.SSL_SERVER_HANDSHAKE);
                    channel.channel.write(byteBuffer);
                    return;
                } else if (channel.length == -1) {
                    channel.buffer.flip();
                    byte fb = channel.buffer.get();
                    byte sb = channel.buffer.get();
                    channel.length = (fb & 0xFF) << 8 | sb & 0xFF;
                    channel.buffer = null;
                    return;
                } else {
                    byte[] bytesRead = new byte[channel.length];
                    channel.buffer.flip();
                    channel.buffer.get(bytesRead);
                    Message stunMessage = Message.decode(bytesRead, '\u0000', (char)bytesRead.length);
                    if (stunMessage.getMessageType() != '\u0001') {
                        throw new IOException("Not a binding request");
                    }
                    UsernameAttribute usernameAttribute = (UsernameAttribute)stunMessage.getAttribute('\u0006');
                    if (usernameAttribute == null) {
                        throw new IOException("No USERNAME attribute present.");
                    }
                    String usernameString = new String(usernameAttribute.getUsername());
                    String localUfrag = usernameString.split(":")[0];
                    Component component = MultiplexingTcpHostHarvester.this.getComponent(localUfrag);
                    if (component == null) {
                        throw new IOException("No component found.");
                    }
                    key.cancel();
                    channel.channel.configureBlocking(true);
                    DatagramPacket p = new DatagramPacket(bytesRead, bytesRead.length);
                    Socket socket = channel.channel.socket();
                    p.setAddress(socket.getInetAddress());
                    p.setPort(socket.getPort());
                    this.handSocketToComponent(socket, component, p);
                    this.channels.remove(channel);
                }
                return;
            }
            catch (IOException ioe) {
                logger.info("Failed to handle TCP socket " + channel.channel.socket() + ": " + ioe);
                this.channels.remove(channel);
                key.cancel();
                try {
                    channel.channel.close();
                    return;
                }
                catch (IOException ioe2) {}
                return;
            }
            catch (StunException se) {
                logger.info("Failed to handle TCP socket " + channel.channel.socket() + ": " + se);
                this.channels.remove(channel);
                key.cancel();
                try {
                    channel.channel.close();
                    return;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int readyChannels = 0;
            while (true) {
                MultiplexingTcpHostHarvester multiplexingTcpHostHarvester = MultiplexingTcpHostHarvester.this;
                synchronized (multiplexingTcpHostHarvester) {
                    if (MultiplexingTcpHostHarvester.this.close) {
                        break;
                    }
                }
                this.cleanup();
                this.checkForNewChannels();
                try {
                    readyChannels = MultiplexingTcpHostHarvester.this.readSelector.select(5000L);
                }
                catch (IOException ioe) {
                    logger.info("Failed to select a read-ready channel.");
                }
                if (readyChannels <= 0) continue;
                Set<SelectionKey> selectedKeys = MultiplexingTcpHostHarvester.this.readSelector.selectedKeys();
                for (SelectionKey selectionKey : selectedKeys) {
                    if (!selectionKey.isReadable()) continue;
                    SelectableChannel selectedChannel = selectionKey.channel();
                    ChannelDesc channelDesc = this.findChannelDesc(selectedChannel);
                    channelDesc.lastActive = System.currentTimeMillis();
                    this.readFromChannel(channelDesc, selectionKey);
                }
                selectedKeys.clear();
            }
            Iterator<ChannelDesc> ioe = MultiplexingTcpHostHarvester.this.newChannels;
            synchronized (ioe) {
                for (SocketChannel channel : MultiplexingTcpHostHarvester.this.newChannels) {
                    try {
                        channel.close();
                    }
                    catch (IOException ioe2) {}
                }
                MultiplexingTcpHostHarvester.this.newChannels.clear();
            }
            for (ChannelDesc channelDesc : this.channels) {
                try {
                    channelDesc.channel.close();
                }
                catch (IOException ioe3) {}
            }
            this.channels.clear();
            try {
                MultiplexingTcpHostHarvester.this.readSelector.close();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
        }

        private class ChannelDesc {
            private final SocketChannel channel;
            private long lastActive = System.currentTimeMillis();
            ByteBuffer buffer = null;
            boolean sslHandshakeRead = false;
            int length = -1;

            private ChannelDesc(SocketChannel channel) {
                this.channel = channel;
            }
        }
    }

    private static class PushBackIceSocketWrapper
    extends IceSocketWrapper {
        private DatagramPacket datagramPacket;
        private final IceSocketWrapper wrapped;

        private PushBackIceSocketWrapper(IceSocketWrapper wrappedWrapper, DatagramPacket datagramPacket) {
            this.wrapped = wrappedWrapper;
            this.datagramPacket = datagramPacket;
        }

        public void close() {
            this.wrapped.close();
        }

        public InetAddress getLocalAddress() {
            return this.wrapped.getLocalAddress();
        }

        public int getLocalPort() {
            return this.wrapped.getLocalPort();
        }

        public SocketAddress getLocalSocketAddress() {
            return this.wrapped.getLocalSocketAddress();
        }

        public Socket getTCPSocket() {
            return this.wrapped.getTCPSocket();
        }

        public DatagramSocket getUDPSocket() {
            return this.wrapped.getUDPSocket();
        }

        public void receive(DatagramPacket p) throws IOException {
            if (this.datagramPacket != null) {
                int len = Math.min(p.getLength(), this.datagramPacket.getLength());
                System.arraycopy(this.datagramPacket.getData(), 0, p.getData(), 0, len);
                p.setAddress(this.datagramPacket.getAddress());
                p.setPort(this.datagramPacket.getPort());
                this.datagramPacket = null;
            } else {
                this.wrapped.receive(p);
            }
        }

        public void send(DatagramPacket p) throws IOException {
            this.wrapped.send(p);
        }
    }

    private class AcceptThread
    extends Thread {
        private final Selector selector;

        private AcceptThread() throws IOException {
            this.setName("MultiplexingTcpHostHarvester AcceptThread");
            this.setDaemon(true);
            this.selector = Selector.open();
            for (ServerSocketChannel channel : MultiplexingTcpHostHarvester.this.serverSocketChannels) {
                channel.configureBlocking(false);
                channel.register(this.selector, 16);
            }
        }

        private void notifyReadThread() {
            MultiplexingTcpHostHarvester.this.readSelector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!MultiplexingTcpHostHarvester.this.close) {
                int readyChannels;
                try {
                    readyChannels = this.selector.select(3000L);
                }
                catch (IOException ioe) {
                    logger.info("Failed to select an accept-ready socket: " + ioe);
                    break;
                }
                if (readyChannels <= 0) continue;
                IOException exception = null;
                LinkedList<SocketChannel> channelsToAdd = new LinkedList<SocketChannel>();
                for (SelectionKey key : this.selector.selectedKeys()) {
                    SocketChannel channel;
                    if (!key.isAcceptable()) continue;
                    try {
                        channel = ((ServerSocketChannel)key.channel()).accept();
                    }
                    catch (IOException ioe) {
                        exception = ioe;
                        break;
                    }
                    channelsToAdd.add(channel);
                }
                this.selector.selectedKeys().clear();
                if (!channelsToAdd.isEmpty()) {
                    List list = MultiplexingTcpHostHarvester.this.newChannels;
                    synchronized (list) {
                        MultiplexingTcpHostHarvester.this.newChannels.addAll(channelsToAdd);
                    }
                    this.notifyReadThread();
                }
                if (exception == null) continue;
                logger.info("Failed to accept a socket, whichshould have been ready to accept: " + exception);
                break;
            }
            for (ServerSocketChannel serverSocketChannel : MultiplexingTcpHostHarvester.this.serverSocketChannels) {
                try {
                    serverSocketChannel.close();
                }
                catch (IOException iOException) {}
            }
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

