/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import java.io.IOException;

public class CacheCreateConfigOperation
extends AbstractNamedOperation
implements IdentifiedDataSerializable {
    private CacheConfig config;
    private boolean isLocal;
    private transient Object response;

    public CacheCreateConfigOperation() {
    }

    public CacheCreateConfigOperation(CacheConfig config) {
        this(config, false);
    }

    public CacheCreateConfigOperation(CacheConfig config, boolean isLocal) {
        super(config.getNameWithPrefix());
        this.config = config;
        this.isLocal = isLocal;
    }

    @Override
    public void run() throws Exception {
        AbstractCacheService service = (AbstractCacheService)this.getService();
        this.response = service.createCacheConfigIfAbsent(this.config, this.isLocal);
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.config);
        out.writeBoolean(this.isLocal);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.config = (CacheConfig)in.readObject();
        this.isLocal = in.readBoolean();
    }

    @Override
    public int getId() {
        return 26;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }
}

