/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jpath.adapter;

import java.util.ArrayList;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.standard.lang.jpath.adapter.ConversionException;
import org.apache.taglibs.standard.lang.jpath.adapter.Convert;
import org.apache.taglibs.standard.lang.jpath.adapter.JSPList;
import org.apache.taglibs.standard.lang.jpath.adapter.JSPListIterationContext;
import org.apache.taglibs.standard.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.standard.lang.jpath.expression.Expression;
import org.apache.taglibs.standard.lang.jpath.expression.Predicate;

public class JSPListUnion
implements JSPList {
    private Expression predicate;
    private JSPList left;
    private JSPList right;
    private int position;
    private Object current;
    boolean first;

    public JSPListUnion(JSPList left, JSPList right) {
        this.left = left;
        this.right = right;
        this.position = 0;
        this.first = true;
    }

    public Object next() {
        if (this.first) {
            if (this.left.hasNext()) {
                this.current = this.left.next();
            } else {
                this.first = false;
                this.current = this.right.next();
            }
        } else {
            this.current = this.right.next();
        }
        ++this.position;
        return this.current;
    }

    public Object getCurrent() {
        return this.current;
    }

    public boolean hasNext() {
        boolean result = this.left.hasNext() || this.right.hasNext();
        return result;
    }

    public int getPosition() {
        return this.position;
    }

    public int getLast() {
        return this.left.getLast() + this.right.getLast();
    }

    public boolean applyPredicate(PageContext pageContext, Predicate predicate) throws ConversionException, EvaluationException {
        boolean oneItem = false;
        if (this.position != 0) {
            throw new ConversionException("You cannot apply a predicate to a JSPList that has begun to be iterated");
        }
        ArrayList<Object> predicated = new ArrayList<Object>();
        while (this.hasNext()) {
            boolean predicateTrue;
            this.next();
            Object result = predicate.evaluate(pageContext, new JSPListIterationContext(this));
            if (result instanceof Double) {
                oneItem = true;
                predicateTrue = (Double)result == (double)this.position;
            } else {
                oneItem = false;
                predicateTrue = Convert.toBoolean(result);
            }
            if (!predicateTrue) continue;
            predicated.add(this.current);
        }
        this.left = Convert.toJSPList(predicated);
        this.right = Convert.toJSPList(new ArrayList());
        this.position = 0;
        this.first = true;
        return oneItem;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

