/**
 * $RCSfile: $
 * $Revision: $
 * $Date: $
 *
 * Copyright (C) 2006 Jive Software. All rights reserved.
 *
 * This software is published under the terms of the GNU Public License (GPL),
 * a copy of which is included in this distribution.
 */

package org.jivesoftware.wildfire.pubsub.models;

import org.jivesoftware.wildfire.pubsub.Node;
import org.jivesoftware.wildfire.pubsub.NodeAffiliate;
import org.xmpp.packet.JID;

/**
 * Publishers and owners may publish items to the node.
 *
 * @author Matt Tucker
 */
public class OnlyPublishers extends PublisherModel {

    public boolean canPublish(Node node, JID entity) {
        NodeAffiliate nodeAffiliate = node.getAffiliate(entity);
        return nodeAffiliate != null && (
                nodeAffiliate.getAffiliation() == NodeAffiliate.Affiliation.publisher ||
                        nodeAffiliate.getAffiliation() == NodeAffiliate.Affiliation.owner);
    }

    public String getName() {
        return "publishers";
    }
}
