/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpFields;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringUtil;

public class CGI
extends HttpServlet {
    private static Log log = LogFactory.getLog(class$org$mortbay$servlet$CGI == null ? (class$org$mortbay$servlet$CGI = CGI.class$("org.mortbay.servlet.CGI")) : class$org$mortbay$servlet$CGI);
    protected File _docRoot;
    protected String _path;
    protected String _cmdPrefix;
    protected EnvList _env;
    static /* synthetic */ Class class$org$mortbay$servlet$CGI;

    public void init() throws ServletException {
        this._env = new EnvList();
        this._cmdPrefix = this.getInitParameter("commandPrefix");
        String tmp = this.getInitParameter("cgibinResourceBase");
        if (tmp == null) {
            tmp = this.getServletContext().getRealPath("/");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: CGI bin " + tmp));
        }
        if (tmp == null) {
            log.warn((Object)"CGI: no CGI bin !");
            throw new ServletException();
        }
        File dir = new File(tmp);
        if (!dir.exists()) {
            log.warn((Object)("CGI: CGI bin does not exist - " + dir));
            throw new ServletException();
        }
        if (!dir.canRead()) {
            log.warn((Object)("CGI: CGI bin is not readable - " + dir));
            throw new ServletException();
        }
        if (!dir.isDirectory()) {
            log.warn((Object)("CGI: CGI bin is not a directory - " + dir));
            throw new ServletException();
        }
        try {
            this._docRoot = dir.getCanonicalFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("CGI: CGI bin accepted - " + this._docRoot));
            }
        }
        catch (IOException e) {
            log.warn((Object)("CGI: CGI bin failed - " + dir));
            e.printStackTrace();
            throw new ServletException();
        }
        this._path = this.getInitParameter("Path");
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: PATH accepted - " + this._path));
        }
        if (this._path != null) {
            this._env.set("PATH", this._path);
        }
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            if (n == null || !n.startsWith("ENV_")) continue;
            this._env.set(n.substring(4), this.getInitParameter(n));
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String both;
        String pathInContext = StringUtil.nonNull(req.getServletPath()) + StringUtil.nonNull(req.getPathInfo());
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: req.getContextPath() : " + req.getContextPath()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: req.getServletPath() : " + req.getServletPath()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: req.getPathInfo()    : " + req.getPathInfo()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: _docRoot             : " + this._docRoot));
        }
        String first = both = pathInContext;
        String last = "";
        File exe = new File(this._docRoot, first);
        while ((first.endsWith("/") || !exe.exists()) && first.length() >= 0) {
            int index = first.lastIndexOf(47);
            first = first.substring(0, index);
            last = both.substring(index, both.length());
            exe = new File(this._docRoot, first);
        }
        if (first.length() == 0 || !exe.exists() || !exe.getCanonicalPath().equals(exe.getAbsolutePath()) || exe.isDirectory()) {
            res.sendError(404);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("CGI: script is " + exe));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("CGI: pathInfo is " + last));
            }
            this.exec(exe, last, req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(File command, String pathInfo, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String path = command.toString();
        File dir = command.getParentFile();
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: execing: " + path));
        }
        EnvList env = new EnvList(this._env);
        env.set("AUTH_TYPE", req.getAuthType());
        env.set("CONTENT_LENGTH", Integer.toString(req.getContentLength()));
        env.set("CONTENT_TYPE", req.getContentType());
        env.set("GATEWAY_INTERFACE", "CGI/1.1");
        env.set("PATH_INFO", pathInfo);
        env.set("PATH_TRANSLATED", req.getPathTranslated());
        env.set("QUERY_STRING", req.getQueryString());
        env.set("REMOTE_ADDR", req.getRemoteAddr());
        env.set("REMOTE_HOST", req.getRemoteHost());
        env.set("REMOTE_USER", req.getRemoteUser());
        env.set("REQUEST_METHOD", req.getMethod());
        String scriptName = req.getRequestURI().substring(0, req.getRequestURI().length() - pathInfo.length());
        env.set("SCRIPT_NAME", scriptName);
        env.set("SCRIPT_FILENAME", this.getServletContext().getRealPath(scriptName));
        env.set("SERVER_NAME", req.getServerName());
        env.set("SERVER_PORT", Integer.toString(req.getServerPort()));
        env.set("SERVER_PROTOCOL", req.getProtocol());
        env.set("SERVER_SOFTWARE", this.getServletContext().getServerInfo());
        Enumeration enm = req.getHeaderNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            String value = req.getHeader(name);
            env.set("HTTP_" + name.toUpperCase().replace('-', '_'), value);
        }
        env.set("HTTPS", req.isSecure() ? "ON" : "OFF");
        String execCmd = path;
        if (execCmd.indexOf(" ") >= 0) {
            execCmd = "\"" + execCmd + "\"";
        }
        if (this._cmdPrefix != null) {
            execCmd = this._cmdPrefix + " " + execCmd;
        }
        Process p = dir == null ? Runtime.getRuntime().exec(execCmd, env.getEnvArray()) : Runtime.getRuntime().exec(execCmd, env.getEnvArray(), dir);
        ServletInputStream inFromReq = req.getInputStream();
        OutputStream outToCgi = p.getOutputStream();
        final int inputLength = req.getContentLength();
        new Thread(new Runnable((InputStream)inFromReq, outToCgi){
            private final /* synthetic */ InputStream val$inFromReq;
            private final /* synthetic */ OutputStream val$outToCgi;
            {
                this.val$inFromReq = val$inFromReq;
                this.val$outToCgi = val$outToCgi;
            }

            public void run() {
                try {
                    if (inputLength > 0) {
                        IO.copy(this.val$inFromReq, this.val$outToCgi, (long)inputLength);
                    }
                    this.val$outToCgi.close();
                }
                catch (IOException e) {
                    LogSupport.ignore(log, e);
                }
            }
        }).start();
        try {
            LineInput li = new LineInput(p.getInputStream());
            HttpFields fields = new HttpFields();
            fields.read(li);
            String ContentStatus = "Status";
            String redirect = fields.get("Location");
            String status = fields.get(ContentStatus);
            if (status != null) {
                log.debug((Object)"Found a Status header - setting status on response");
                fields.remove(ContentStatus);
                int i = status.indexOf(32);
                if (i > 0) {
                    status = status.substring(0, i);
                }
                res.setStatus(Integer.parseInt(status));
            }
            Iterator i = fields.iterator();
            while (i.hasNext()) {
                HttpFields.Entry e = (HttpFields.Entry)i.next();
                res.addHeader(e.getKey(), e.getValue());
            }
            if (status == null && redirect != null) {
                if (!redirect.startsWith("http:/") && !redirect.startsWith("https:/")) {
                    res.sendRedirect(redirect);
                } else {
                    res.setStatus(302);
                }
            }
            IO.copy(li, (OutputStream)res.getOutputStream());
            p.waitFor();
            int exitValue = p.exitValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("CGI: p.exitValue(): " + exitValue));
            }
            if (0 != exitValue) {
                log.warn((Object)("Non-zero exit status (" + exitValue + ") from CGI program: " + path));
                if (!res.isCommitted()) {
                    res.sendError(500, "Failed to exec CGI");
                }
            }
        }
        catch (IOException e) {
            log.debug((Object)"CGI: Client closed connection!");
        }
        catch (InterruptedException ie) {
            log.debug((Object)"CGI: interrupted!");
        }
        finally {
            p.destroy();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CGI: Finished exec: " + p));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class EnvList {
        private Map envMap;

        EnvList() {
            this.envMap = new HashMap();
        }

        EnvList(EnvList l) {
            this.envMap = new HashMap(l.envMap);
        }

        public void set(String name, String value) {
            this.envMap.put(name, name + "=" + StringUtil.nonNull(value));
        }

        public String[] getEnvArray() {
            return this.envMap.values().toArray(new String[this.envMap.size()]);
        }
    }
}

