/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.tray.internal.impl;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.jdic.tray.internal.TrayIconService;
import sun.awt.image.IntegerComponentRaster;

public class WinTrayIconService
implements TrayIconService,
PopupMenuListener {
    private JPopupMenu menu;
    private Icon icon;
    private boolean autoSize;
    private boolean isShowing;
    private String caption = "JDIC TrayIcon";
    private long hicon;
    private Image oldIconImage;
    private static HashMap map = new HashMap();
    private LinkedList actionList = new LinkedList();
    private Point lastLocation = null;
    static int noIcons;
    int iconID = noIcons++;
    AnimationObserver observer;
    private final int WINDOWS_TASKBAR_ICON_WIDTH = 16;
    private final int WINDOWS_TASKBAR_ICON_HEIGHT = 16;
    JDialog popupParentFrame;
    boolean created;

    public static void removeAllIcons() {
        for (int i = 0; i < noIcons; ++i) {
            WinTrayIconService.removeIcon(i);
        }
    }

    public WinTrayIconService() {
        map.put(new Integer(this.iconID), this);
    }

    private native long createIconIndirect(int[] var1, byte[] var2, int var3, int var4, int var5, int var6, int var7);

    private native void createIcon(long var1, int var3, String var4);

    private native void updateNativeIcon(long var1, int var3, String var4);

    private native void deleteHIcon(long var1);

    private static native void removeIcon(int var0);

    public void addNotify() {
        this.observer = new AnimationObserver();
        this.updateIcon(null);
        this.created = true;
    }

    private void updateBufferedImage() {
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.menu = jPopupMenu;
        if (this.menu != null) {
            this.menu.setLightWeightPopupEnabled(false);
        }
    }

    protected long createNativeIcon(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        int n5;
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        WritableRaster writableRaster = bufferedImage.getRaster();
        byte[] byArray = new byte[n * n2 / 8];
        int n6 = nArray.length;
        for (n5 = 0; n5 < n6; ++n5) {
            int n7 = n5 / 8;
            int n8 = 1 << 7 - n5 % 8;
            if ((nArray[n5] & 0xFF000000) != 0 || n7 >= byArray.length) continue;
            int n9 = n7;
            byArray[n9] = (byte)(byArray[n9] | n8);
        }
        n5 = writableRaster.getWidth();
        if (writableRaster instanceof IntegerComponentRaster) {
            n5 = ((IntegerComponentRaster)writableRaster).getScanlineStride();
        }
        return this.createIconIndirect(((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData(), byArray, n5, writableRaster.getWidth(), writableRaster.getHeight(), n3, n4);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.isShowing = false;
        this.popupParentFrame.dispose();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.isShowing = false;
        this.popupParentFrame.dispose();
    }

    public void processEvent(int n, int n2, int n3) {
        switch (n) {
            case 512: {
                break;
            }
            case 514: {
                if (!this.isShowing) {
                    ListIterator listIterator = this.actionList.listIterator(0);
                    while (listIterator.hasNext()) {
                        ActionListener actionListener = (ActionListener)listIterator.next();
                        actionListener.actionPerformed(new ActionEvent(this, 1001, "PressAction", System.currentTimeMillis(), 0));
                    }
                    break;
                }
                this.popupParentFrame.toFront();
                break;
            }
            case 517: {
                if (!this.isShowing) {
                    this.isShowing = true;
                    this.popupParentFrame = new JDialog();
                    GraphicsConfiguration graphicsConfiguration = this.popupParentFrame.getGraphicsConfiguration();
                    Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
                    if (n2 < insets.left) {
                        n2 = insets.left;
                    }
                    if (n3 < insets.top) {
                        n3 = insets.top;
                    }
                    this.popupParentFrame.setBounds(n2, n3, 1, 1);
                    this.popupParentFrame.setVisible(true);
                    this.menu.show(this.popupParentFrame, 0, 0);
                    this.menu.addPopupMenuListener(this);
                }
                this.popupParentFrame.toFront();
            }
        }
        this.lastLocation = new Point(n2, n3);
    }

    public static synchronized void notifyEvent(int n, final int n2, final int n3, final int n4) {
        final WinTrayIconService winTrayIconService = (WinTrayIconService)map.get(new Integer(n));
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    winTrayIconService.processEvent(n2, n3, n4);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIcon(Image image) {
        if (this.icon != null) {
            Graphics2D graphics2D;
            if (image == null) {
                image = new BufferedImage(this.icon.getIconWidth(), this.icon.getIconHeight(), 2);
                graphics2D = (Graphics2D)((BufferedImage)image).getGraphics();
                graphics2D.setComposite(AlphaComposite.Src);
                this.icon.paintIcon(this.observer, graphics2D, 0, 0);
                this.oldIconImage = image;
            }
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            try {
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.drawImage(image, 0, 0, 16, 16, null);
            }
            finally {
                graphics2D.dispose();
            }
            bufferedImage.flush();
            if (this.hicon != 0L) {
                this.deleteHIcon(this.hicon);
            }
            this.hicon = this.createNativeIcon(bufferedImage, 16, 16, 0, 0);
            if (this.created) {
                this.updateNativeIcon(this.hicon, this.iconID, this.caption);
            } else {
                this.createIcon(this.hicon, this.iconID, this.caption);
            }
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.created) {
            this.observer.setUpdate(false);
            this.observer = new AnimationObserver();
            this.updateIcon(null);
        }
    }

    public void setCaption(String string) {
        this.caption = string;
        if (this.created) {
            this.observer.setUpdate(false);
            this.observer = new AnimationObserver();
            this.updateIcon(null);
        }
    }

    public void setIconAutoSize(boolean bl) {
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionList.remove(actionListener);
    }

    public Point getLocationOnScreen() {
        return this.lastLocation;
    }

    void remove() {
        WinTrayIconService.removeIcon(this.iconID);
        if (this.hicon != 0L) {
            this.deleteHIcon(this.hicon);
        }
        this.created = false;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                WinTrayIconService.removeAllIcons();
            }
        });
    }

    private class AnimationObserver
    extends Component {
        boolean update = true;

        private AnimationObserver() {
        }

        public void setUpdate(boolean bl) {
            this.update = bl;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (this.update && WinTrayIconService.this.created) {
                WinTrayIconService.this.updateIcon(image);
            }
            return this.update;
        }
    }
}

