/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPObject;

public final class CallIdentifier
extends SIPObject {
    private static final long serialVersionUID = 7314773655675451377L;
    protected String localId;
    protected String host;

    public CallIdentifier() {
    }

    public CallIdentifier(String string, String string2) {
        this.localId = string;
        this.host = string2;
    }

    public CallIdentifier(String string) throws IllegalArgumentException {
        this.setCallID(string);
    }

    public String encode() {
        if (this.host != null) {
            return this.localId + "@" + this.host;
        }
        return this.localId;
    }

    public boolean equals(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        CallIdentifier callIdentifier = (CallIdentifier)object;
        if (this.localId.compareTo(callIdentifier.localId) != 0) {
            return false;
        }
        if (this.host == callIdentifier.host) {
            return true;
        }
        if (this.host == null && callIdentifier.host != null || this.host != null && callIdentifier.host == null) {
            return false;
        }
        return this.host.compareToIgnoreCase(callIdentifier.host) == 0;
    }

    public String getLocalId() {
        return this.localId;
    }

    public String getHost() {
        return this.host;
    }

    public void setLocalId(String string) {
        this.localId = string;
    }

    public void setCallID(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("NULL!");
        }
        int n = string.indexOf(64);
        if (n == -1) {
            this.localId = string;
            this.host = null;
        } else {
            this.localId = string.substring(0, n);
            this.host = string.substring(n + 1, string.length());
            if (this.localId == null || this.host == null) {
                throw new IllegalArgumentException("CallID  must be token@token or token");
            }
        }
    }

    public void setHost(String string) {
        this.host = string;
    }
}

