/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util.call;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingServer;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.UtilActivator;
import net.java.sip.communicator.util.account.AccountUtils;
import net.java.sip.communicator.util.call.ContactPhoneUtil;

public class MetaContactPhoneUtil {
    private static final Logger logger = Logger.getLogger(MetaContactPhoneUtil.class);
    private MetaContact metaContact;
    private Hashtable<Contact, List<String>> phones = new Hashtable();
    private Hashtable<Contact, List<String>> videoPhones = new Hashtable();
    private boolean hasPhones = false;
    private boolean hasVideoDetail = false;
    private boolean routingForVideoEnabled = false;
    private boolean routingForDesktopEnabled = false;

    public static MetaContactPhoneUtil getPhoneUtil(MetaContact metaContact) {
        return new MetaContactPhoneUtil(metaContact);
    }

    protected MetaContactPhoneUtil(MetaContact metaContact) {
        this.metaContact = metaContact;
    }

    public MetaContact getMetaContact() {
        return this.metaContact;
    }

    public List<String> getPhones(Contact contact) {
        return this.getPhones(contact, null, true);
    }

    public List<String> getVideoPhones(Contact contact, OperationSetServerStoredContactInfo.DetailsResponseListener listener) {
        if (!this.metaContact.containsContact(contact)) {
            return new ArrayList<String>();
        }
        if (this.videoPhones.containsKey(contact)) {
            return this.videoPhones.get(contact);
        }
        List<String> phonesList = ContactPhoneUtil.getContactAdditionalPhones(contact, listener, true, true);
        if (phonesList == null) {
            return null;
        }
        if (phonesList.size() > 0) {
            this.hasVideoDetail = true;
        }
        this.videoPhones.put(contact, phonesList);
        this.isVideoCallEnabled(contact);
        this.isDesktopSharingEnabled(contact);
        return phonesList;
    }

    public List<String> getPhones(Contact contact, OperationSetServerStoredContactInfo.DetailsResponseListener listener, boolean localized) {
        if (!this.metaContact.containsContact(contact)) {
            return new ArrayList<String>();
        }
        if (this.phones.containsKey(contact)) {
            return this.phones.get(contact);
        }
        List<String> phonesList = ContactPhoneUtil.getContactAdditionalPhones(contact, listener, false, localized);
        if (phonesList == null) {
            return null;
        }
        if (phonesList.size() > 0) {
            this.hasPhones = true;
        }
        this.phones.put(contact, phonesList);
        return phonesList;
    }

    public boolean isVideoCallEnabled(OperationSetServerStoredContactInfo.DetailsResponseListener listener) {
        if (!this.checkMetaContactVideoPhones(listener)) {
            return false;
        }
        return this.metaContact.getDefaultContact(OperationSetVideoTelephony.class) != null || this.routingForVideoEnabled || this.hasVideoDetail;
    }

    public boolean isVideoCallEnabled() {
        return this.isVideoCallEnabled((OperationSetServerStoredContactInfo.DetailsResponseListener)null);
    }

    public boolean isVideoCallEnabled(Contact contact) {
        if (!this.metaContact.containsContact(contact)) {
            return false;
        }
        if (!this.checkContactPhones(contact)) {
            return false;
        }
        boolean bl = this.routingForVideoEnabled = ConfigurationUtils.isRouteVideoAndDesktopUsingPhoneNumberEnabled() && this.phones.containsKey(contact) && this.phones.get(contact).size() > 0 && AccountUtils.getOpSetRegisteredProviders(OperationSetVideoTelephony.class, null, null).size() > 0;
        return contact.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class) != null && this.hasContactCapabilities(contact, OperationSetVideoTelephony.class) || this.routingForVideoEnabled;
    }

    public boolean isDesktopSharingEnabled(OperationSetServerStoredContactInfo.DetailsResponseListener listener) {
        if (!this.checkMetaContactVideoPhones(listener)) {
            return false;
        }
        return this.metaContact.getDefaultContact(OperationSetDesktopSharingServer.class) != null || this.routingForDesktopEnabled || this.hasVideoDetail;
    }

    public boolean isDesktopSharingEnabled() {
        return this.isDesktopSharingEnabled((OperationSetServerStoredContactInfo.DetailsResponseListener)null);
    }

    public boolean isDesktopSharingEnabled(Contact contact) {
        if (!this.metaContact.containsContact(contact)) {
            return false;
        }
        if (!this.checkContactPhones(contact)) {
            return false;
        }
        boolean bl = this.routingForDesktopEnabled = ConfigurationUtils.isRouteVideoAndDesktopUsingPhoneNumberEnabled() && this.phones.containsKey(contact) && this.phones.get(contact).size() > 0 && AccountUtils.getOpSetRegisteredProviders(OperationSetDesktopSharingServer.class, null, null).size() > 0;
        return contact.getProtocolProvider().getOperationSet(OperationSetDesktopSharingServer.class) != null && this.hasContactCapabilities(contact, OperationSetDesktopSharingServer.class) || this.routingForDesktopEnabled;
    }

    public boolean isCallEnabled(OperationSetServerStoredContactInfo.DetailsResponseListener listener) {
        return this.isCallEnabled(listener, true);
    }

    public boolean isCallEnabled(OperationSetServerStoredContactInfo.DetailsResponseListener listener, boolean checkForTelephonyOpSet) {
        if (!this.checkMetaContactPhones(listener)) {
            return false;
        }
        boolean hasPhoneCheck = this.hasPhones;
        if (checkForTelephonyOpSet) {
            boolean bl = hasPhoneCheck = this.hasPhones && AccountUtils.getRegisteredProviders(OperationSetBasicTelephony.class).size() > 0;
        }
        return this.metaContact.getDefaultContact(OperationSetBasicTelephony.class) != null || hasPhoneCheck;
    }

    public boolean isCallEnabled() {
        return this.isCallEnabled(null, true);
    }

    public boolean isCallEnabled(boolean checkForTelephonyOpSet) {
        return this.isCallEnabled(null, checkForTelephonyOpSet);
    }

    public boolean isCallEnabled(Contact contact) {
        if (!this.checkContactPhones(contact)) {
            return false;
        }
        return contact.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class) != null && this.hasContactCapabilities(contact, OperationSetBasicTelephony.class);
    }

    private boolean checkMetaContactPhones() {
        return this.checkMetaContactPhones(null);
    }

    private boolean checkMetaContactPhones(OperationSetServerStoredContactInfo.DetailsResponseListener l) {
        Iterator contactIterator = this.metaContact.getContacts();
        while (contactIterator.hasNext()) {
            List<String> phones;
            Contact contact = (Contact)contactIterator.next();
            if (this.phones.containsKey(contact) || (phones = this.getPhones(contact, l, false)) != null) continue;
            return false;
        }
        return true;
    }

    private boolean checkMetaContactVideoPhones(OperationSetServerStoredContactInfo.DetailsResponseListener l) {
        Iterator contactIterator = this.metaContact.getContacts();
        while (contactIterator.hasNext()) {
            List<String> phones;
            Contact contact = (Contact)contactIterator.next();
            if (this.videoPhones.containsKey(contact) || (phones = this.getVideoPhones(contact, l)) != null) continue;
            return false;
        }
        return true;
    }

    private boolean checkContactPhones(Contact contact) {
        if (!this.phones.containsKey(contact)) {
            List<String> phones = this.getPhones(contact);
            if (phones == null) {
                return false;
            }
            this.isVideoCallEnabled(contact);
            this.isDesktopSharingEnabled(contact);
        }
        return true;
    }

    private boolean hasContactCapabilities(Contact contact, Class<? extends OperationSet> opSet) {
        OperationSetContactCapabilities capOpSet = (OperationSetContactCapabilities)contact.getProtocolProvider().getOperationSet(OperationSetContactCapabilities.class);
        if (capOpSet == null) {
            return true;
        }
        return capOpSet.getOperationSet(contact, opSet) != null;
    }

    protected String getLocalizedPhoneNumber(ServerStoredDetails.GenericDetail d) {
        if (d instanceof ServerStoredDetails.WorkPhoneDetail) {
            return UtilActivator.getResources().getI18NString("service.gui.WORK_PHONE");
        }
        if (d instanceof ServerStoredDetails.MobilePhoneDetail) {
            return UtilActivator.getResources().getI18NString("service.gui.MOBILE_PHONE");
        }
        if (d instanceof ServerStoredDetails.VideoDetail) {
            return UtilActivator.getResources().getI18NString("service.gui.VIDEO_PHONE");
        }
        return UtilActivator.getResources().getI18NString("service.gui.HOME");
    }
}

