/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.opus;

import java.awt.Component;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.opus.Opus;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.service.neomedia.control.FECDecoderControl;
import org.jitsi.util.Logger;

public class JNIDecoder
extends AbstractCodec2
implements FECDecoderControl {
    private static final Logger logger = Logger.getLogger(JNIDecoder.class);
    private static final Format[] SUPPORTED_INPUT_FORMATS = new Format[]{new AudioFormat("opus/rtp")};
    private static final Format[] SUPPORTED_OUTPUT_FORMATS = new Format[]{new AudioFormat("LINEAR", 48000.0, 16, 1, AbstractAudioRenderer.NATIVE_AUDIO_FORMAT_ENDIAN, 1, -1, -1.0, Format.byteArray)};
    private int channels = 1;
    private long decoder = 0L;
    private int lastFrameSizeInSamplesPerChannel;
    private long lastSeqNo = 0x7FFFFFFFFFFFFFFEL;
    private int nbDecodedFec = 0;
    private int outputFrameSize;
    private int outputSampleRate;

    public JNIDecoder() {
        super("Opus JNI Decoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.features = 0x3000000;
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
        this.addControl(this);
    }

    @Override
    protected void doClose() {
        if (this.decoder != 0L) {
            Opus.decoder_destroy(this.decoder);
            this.decoder = 0L;
        }
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        if (this.decoder == 0L) {
            this.decoder = Opus.decoder_create(this.outputSampleRate, this.channels);
            if (this.decoder == 0L) {
                throw new ResourceUnavailableException("opus_decoder_create");
            }
            this.lastFrameSizeInSamplesPerChannel = 0;
            this.lastSeqNo = 0x7FFFFFFFFFFFFFFEL;
        }
    }

    @Override
    protected int doProcess(Buffer inBuf, Buffer outBuf) {
        int ret;
        boolean decodeFEC;
        Format inFormat = inBuf.getFormat();
        if (inFormat != null && inFormat != this.inputFormat && !inFormat.equals(this.inputFormat) && null == this.setInputFormat(inFormat)) {
            return 1;
        }
        long seqNo = inBuf.getSequenceNumber();
        if ((4 & inBuf.getFlags()) != 0) {
            this.lastSeqNo = seqNo;
            return 4;
        }
        int lostSeqNoCount = JNIDecoder.calculateLostSeqNoCount(this.lastSeqNo, seqNo);
        boolean bl = decodeFEC = lostSeqNoCount > 0 && lostSeqNoCount <= 3 && this.lastFrameSizeInSamplesPerChannel != 0;
        if (decodeFEC && (inBuf.getFlags() & 0x10000) != 0) {
            decodeFEC = false;
            if (logger.isTraceEnabled()) {
                logger.trace("Not decoding FEC/PLC for " + seqNo + " because of Buffer.FLAG_SKIP_FEC.");
            }
        }
        byte[] in = (byte[])inBuf.getData();
        int inOffset = inBuf.getOffset();
        int inLength = inBuf.getLength();
        int outOffset = 0;
        int outLength = 0;
        int totalFrameSizeInSamplesPerChannel = 0;
        if (decodeFEC) {
            byte[] out;
            inLength = lostSeqNoCount == 1 ? inLength : 0;
            int frameSizeInSamplesPerChannel = Opus.decode(this.decoder, in, inOffset, inLength, out = JNIDecoder.validateByteArraySize(outBuf, outOffset + this.lastFrameSizeInSamplesPerChannel * this.outputFrameSize, outOffset != 0), outOffset, this.lastFrameSizeInSamplesPerChannel, 1);
            if (frameSizeInSamplesPerChannel > 0) {
                int frameSizeInBytes = frameSizeInSamplesPerChannel * this.outputFrameSize;
                outLength += frameSizeInBytes;
                outOffset += frameSizeInBytes;
                totalFrameSizeInSamplesPerChannel += frameSizeInSamplesPerChannel;
                outBuf.setFlags(outBuf.getFlags() | (in == null || inLength == 0 ? 0x2000000 : 0x1000000));
                ++this.nbDecodedFec;
            }
            this.lastSeqNo = JNIDecoder.incrementSeqNo(this.lastSeqNo);
        } else {
            int frameSizeInSamplesPerChannel = Opus.decoder_get_nb_samples(this.decoder, in, inOffset, inLength);
            byte[] out = JNIDecoder.validateByteArraySize(outBuf, outOffset + frameSizeInSamplesPerChannel * this.outputFrameSize, outOffset != 0);
            if ((frameSizeInSamplesPerChannel = Opus.decode(this.decoder, in, inOffset, inLength, out, outOffset, frameSizeInSamplesPerChannel, 0)) > 0) {
                int frameSizeInBytes = frameSizeInSamplesPerChannel * this.outputFrameSize;
                outLength += frameSizeInBytes;
                outOffset += frameSizeInBytes;
                totalFrameSizeInSamplesPerChannel += frameSizeInSamplesPerChannel;
                outBuf.setFlags(outBuf.getFlags() & 0xFCFFFFFF);
                this.lastFrameSizeInSamplesPerChannel = frameSizeInSamplesPerChannel;
            }
            this.lastSeqNo = seqNo;
        }
        int n = ret = this.lastSeqNo == seqNo ? 0 : 2;
        if (outLength > 0) {
            outBuf.setDuration((long)(totalFrameSizeInSamplesPerChannel * this.channels) * 1000L * 1000L / (long)this.outputSampleRate);
            outBuf.setFormat(this.getOutputFormat());
            outBuf.setLength(outLength);
            outBuf.setOffset(0);
            outBuf.setSequenceNumber(this.lastSeqNo);
        } else {
            ret |= 4;
        }
        return ret;
    }

    @Override
    public int fecPacketsDecoded() {
        return this.nbDecodedFec;
    }

    @Override
    public Component getControlComponent() {
        return null;
    }

    @Override
    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        AudioFormat af = (AudioFormat)inputFormat;
        return new Format[]{new AudioFormat("LINEAR", af.getSampleRate(), 16, 1, AbstractAudioRenderer.NATIVE_AUDIO_FORMAT_ENDIAN, 1, -1, -1.0, Format.byteArray)};
    }

    @Override
    public Format setInputFormat(Format format) {
        Format inFormat = super.setInputFormat(format);
        if (inFormat != null && this.outputFormat == null) {
            this.setOutputFormat(SUPPORTED_OUTPUT_FORMATS[0]);
        }
        return inFormat;
    }

    @Override
    public Format setOutputFormat(Format format) {
        Format setOutputFormat = super.setOutputFormat(format);
        if (setOutputFormat != null) {
            AudioFormat af = (AudioFormat)setOutputFormat;
            this.outputFrameSize = af.getSampleSizeInBits() / 8 * af.getChannels();
            this.outputSampleRate = (int)af.getSampleRate();
        }
        return setOutputFormat;
    }

    static {
        Opus.assertOpusIsFunctional();
    }
}

