/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.examples;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import com.hazelcast.logging.ILogger;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleMapTest {
    private static final String NAMESPACE = "default";
    private static final long STATS_SECONDS = 10L;
    private final HazelcastInstance instance;
    private final ILogger logger;
    private final Stats stats = new Stats();
    private final int threadCount;
    private final int entryCount;
    private final int valueSize;
    private final int getPercentage;
    private final int putPercentage;
    private final boolean load;

    public SimpleMapTest(int threadCount, int entryCount, int valueSize, int getPercentage, int putPercentage, boolean load) {
        this.threadCount = threadCount;
        this.entryCount = entryCount;
        this.valueSize = valueSize;
        this.getPercentage = getPercentage;
        this.putPercentage = putPercentage;
        this.load = load;
        Config cfg = new XmlConfigBuilder().build();
        cfg.getManagementCenterConfig().setEnabled(true);
        this.instance = Hazelcast.newHazelcastInstance(cfg);
        this.logger = this.instance.getLoggingService().getLogger("SimpleMapTest");
    }

    public static void main(String[] input) throws InterruptedException {
        int threadCount = 40;
        int entryCount = 10000;
        int valueSize = 1000;
        int getPercentage = 40;
        int putPercentage = 40;
        boolean load = false;
        if (input != null && input.length > 0) {
            for (String arg : input) {
                if ((arg = arg.trim()).startsWith("t")) {
                    threadCount = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("c")) {
                    entryCount = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("v")) {
                    valueSize = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("g")) {
                    getPercentage = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("p")) {
                    putPercentage = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (!arg.startsWith("load")) continue;
                load = true;
            }
        } else {
            System.out.println("Help: sh test.sh t200 v130 p10 g85 ");
            System.out.println("means 200 threads, value-size 130 bytes, 10% put, 85% get");
            System.out.println();
        }
        SimpleMapTest test = new SimpleMapTest(threadCount, entryCount, valueSize, getPercentage, putPercentage, load);
        test.start();
    }

    private void start() throws InterruptedException {
        this.printVariables();
        ExecutorService es = Executors.newFixedThreadPool(this.threadCount);
        this.startPrintStats();
        this.load(es);
        this.run(es);
    }

    private void run(ExecutorService es) {
        final IMap map = this.instance.getMap(NAMESPACE);
        for (int i = 0; i < this.threadCount; ++i) {
            es.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            int key = (int)(Math.random() * (double)SimpleMapTest.this.entryCount);
                            int operation = (int)(Math.random() * 100.0);
                            if (operation < SimpleMapTest.this.getPercentage) {
                                map.get(String.valueOf(key));
                                ((SimpleMapTest)SimpleMapTest.this).stats.gets.incrementAndGet();
                                continue;
                            }
                            if (operation < SimpleMapTest.this.getPercentage + SimpleMapTest.this.putPercentage) {
                                map.put(String.valueOf(key), SimpleMapTest.this.createValue());
                                ((SimpleMapTest)SimpleMapTest.this).stats.puts.incrementAndGet();
                                continue;
                            }
                            map.remove(String.valueOf(key));
                            ((SimpleMapTest)SimpleMapTest.this).stats.removes.incrementAndGet();
                        }
                    }
                    catch (HazelcastInstanceNotActiveException ignored) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private Object createValue() {
        return new byte[this.valueSize];
    }

    private void load(ExecutorService es) throws InterruptedException {
        if (!this.load) {
            return;
        }
        final IMap map = this.instance.getMap(NAMESPACE);
        Member thisMember = this.instance.getCluster().getLocalMember();
        LinkedList<String> lsOwnedEntries = new LinkedList<String>();
        for (int i = 0; i < this.entryCount; ++i) {
            String key = String.valueOf(i);
            Partition partition = this.instance.getPartitionService().getPartition(key);
            if (!thisMember.equals(partition.getOwner())) continue;
            lsOwnedEntries.add(key);
        }
        final CountDownLatch latch = new CountDownLatch(lsOwnedEntries.size());
        for (final String ownedKey : lsOwnedEntries) {
            es.execute(new Runnable(){

                @Override
                public void run() {
                    map.put(ownedKey, SimpleMapTest.this.createValue());
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    private void startPrintStats() {
        new Thread(){
            {
                this.setDaemon(true);
                this.setName("PrintStats." + SimpleMapTest.this.instance.getName());
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(10000L);
                        SimpleMapTest.this.stats.printAndReset();
                    }
                }
                catch (InterruptedException ignored) {
                    return;
                }
            }
        }.start();
    }

    private void printVariables() {
        this.logger.info("Starting Test with ");
        this.logger.info("Thread Count: " + this.threadCount);
        this.logger.info("Entry Count: " + this.entryCount);
        this.logger.info("Value Size: " + this.valueSize);
        this.logger.info("Get Percentage: " + this.getPercentage);
        this.logger.info("Put Percentage: " + this.putPercentage);
        this.logger.info("Remove Percentage: " + (100 - (this.putPercentage + this.getPercentage)));
        this.logger.info("Load: " + this.load);
    }

    static {
        System.setProperty("hazelcast.version.check.enabled", "false");
        System.setProperty("hazelcast.socket.bind.any", "false");
        System.setProperty("java.net.preferIPv4Stack", "true");
    }

    private class Stats {
        public AtomicLong gets = new AtomicLong();
        public AtomicLong puts = new AtomicLong();
        public AtomicLong removes = new AtomicLong();

        private Stats() {
        }

        public void printAndReset() {
            long getsNow = this.gets.getAndSet(0L);
            long putsNow = this.puts.getAndSet(0L);
            long removesNow = this.removes.getAndSet(0L);
            long total = getsNow + putsNow + removesNow;
            SimpleMapTest.this.logger.info("total= " + total + ", gets:" + getsNow + ", puts:" + putsNow + ", removes:" + removesNow);
            SimpleMapTest.this.logger.info("Operations per Second : " + total / 10L);
        }
    }
}

