/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import org.ice4j.StunException;
import org.ice4j.attribute.Attribute;

public class NonceAttribute
extends Attribute {
    public static final String NAME = "NONCE";
    private byte[] nonce = null;

    NonceAttribute() {
        super('\u0015');
    }

    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        this.nonce = new byte[length];
        System.arraycopy(attributeValue, offset, this.nonce, 0, length);
    }

    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength() + this.getDataLength() % 4];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.nonce, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    public char getDataLength() {
        return (char)this.nonce.length;
    }

    public String getName() {
        return NAME;
    }

    public byte[] getNonce() {
        return this.nonce == null ? null : (byte[])this.nonce.clone();
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce == null ? null : (byte[])nonce.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NonceAttribute)) {
            return false;
        }
        NonceAttribute att = (NonceAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.nonce, this.nonce);
    }
}

