/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcUtil;

public class BcPublicKeyDataDecryptorFactory
implements PublicKeyDataDecryptorFactory {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private PGPPrivateKey privKey;

    public BcPublicKeyDataDecryptorFactory(PGPPrivateKey pGPPrivateKey) {
        this.privKey = pGPPrivateKey;
    }

    public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
        try {
            AsymmetricBlockCipher asymmetricBlockCipher = BcImplProvider.createPublicKeyCipher(n);
            AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPrivateKey(this.privKey);
            BufferedAsymmetricBlockCipher bufferedAsymmetricBlockCipher = new BufferedAsymmetricBlockCipher(asymmetricBlockCipher);
            bufferedAsymmetricBlockCipher.init(false, (CipherParameters)asymmetricKeyParameter);
            if (n == 2 || n == 1) {
                byte[] byArray2 = byArray[0];
                bufferedAsymmetricBlockCipher.processBytes(byArray2, 2, byArray2.length - 2);
            } else {
                BcPGPKeyConverter bcPGPKeyConverter = new BcPGPKeyConverter();
                ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)bcPGPKeyConverter.getPrivateKey(this.privKey);
                int n2 = (elGamalPrivateKeyParameters.getParameters().getP().bitLength() + 7) / 8;
                byte[] byArray3 = new byte[n2];
                byte[] byArray4 = byArray[0];
                if (byArray4.length - 2 > n2) {
                    bufferedAsymmetricBlockCipher.processBytes(byArray4, 3, byArray4.length - 3);
                } else {
                    System.arraycopy(byArray4, 2, byArray3, byArray3.length - (byArray4.length - 2), byArray4.length - 2);
                    bufferedAsymmetricBlockCipher.processBytes(byArray3, 0, byArray3.length);
                }
                byArray4 = byArray[1];
                for (int i = 0; i != byArray3.length; ++i) {
                    byArray3[i] = 0;
                }
                if (byArray4.length - 2 > n2) {
                    bufferedAsymmetricBlockCipher.processBytes(byArray4, 3, byArray4.length - 3);
                } else {
                    System.arraycopy(byArray4, 2, byArray3, byArray3.length - (byArray4.length - 2), byArray4.length - 2);
                    bufferedAsymmetricBlockCipher.processBytes(byArray3, 0, byArray3.length);
                }
            }
            return bufferedAsymmetricBlockCipher.doFinal();
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("exception encrypting session info: " + invalidCipherTextException.getMessage(), (Exception)((Object)invalidCipherTextException));
        }
    }

    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }
}

