/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jrobin.cmd.RrdCreateCmd;
import org.jrobin.cmd.RrdDumpCmd;
import org.jrobin.cmd.RrdFetchCmd;
import org.jrobin.cmd.RrdGraphCmd;
import org.jrobin.cmd.RrdInfoCmd;
import org.jrobin.cmd.RrdLastCmd;
import org.jrobin.cmd.RrdRestoreCmd;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.cmd.RrdTuneCmd;
import org.jrobin.cmd.RrdUpdateCmd;
import org.jrobin.cmd.RrdXportCmd;
import org.jrobin.core.RrdException;

public class RrdCommander {
    private static final RrdToolCmd[] rrdCommands = new RrdToolCmd[]{new RrdCreateCmd(), new RrdUpdateCmd(), new RrdLastCmd(), new RrdFetchCmd(), new RrdDumpCmd(), new RrdRestoreCmd(), new RrdXportCmd(), new RrdGraphCmd(), new RrdTuneCmd(), new RrdInfoCmd()};

    public static synchronized boolean isStandardOutUsed() {
        return RrdToolCmd.isStandardOutUsed();
    }

    public static synchronized void setStandardOutUsed(boolean bl) {
        RrdToolCmd.setStandardOutUsed(bl);
    }

    public static synchronized boolean isRrdDbPoolUsed() {
        return RrdToolCmd.isRrdDbPoolUsed();
    }

    public static synchronized void setRrdDbPoolUsed(boolean bl) {
        RrdToolCmd.setRrdDbPoolUsed(bl);
    }

    public static synchronized Object execute(String string) throws IOException, RrdException {
        String string2;
        String string3 = string.trim();
        if (string3.startsWith(string2 = "rrdtool ")) {
            string3 = string3.substring(string2.length());
        }
        for (RrdToolCmd rrdToolCmd : rrdCommands) {
            if (!string3.startsWith(rrdToolCmd.getCmdType() + " ")) continue;
            return rrdToolCmd.executeCommand(string3);
        }
        throw new RrdException("Unknown RRDTool command: " + string);
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.println("== JRobin's RRDTool commander ==");
        System.out.println("Type a RRDTool command after the dollar sign and press Enter.");
        System.out.println("Start your RRDTool command with 'create', 'update', 'fetch' etc.");
        System.out.println("Start line with 'create', 'update', 'fetch' etc.");
        System.out.println("Enter dot ('.') to bail out");
        System.out.println("Current directory is: " + new File(".").getCanonicalPath());
        System.out.println("================================");
        RrdToolCmd.setRrdDbPoolUsed(false);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        block2: while (true) {
            try {
                while (true) {
                    System.out.print("$ ");
                    String string = bufferedReader.readLine().trim();
                    if (string.length() <= 0) continue;
                    if (string.startsWith(".")) break block2;
                    RrdCommander.execute(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }
}

