/*
 * Decompiled with CFR 0.152.
 */
package org.hn.sleek.jmml;

import java.util.HashMap;
import java.util.Hashtable;
import org.hn.sleek.jmml.Contact;
import org.hn.sleek.jmml.MSNException;

public class ContactList {
    private static final int MSN_INTERNAL_FL = 1;
    private static final int MSN_INTERNAL_AL = 2;
    private static final int MSN_INTERNAL_BL = 4;
    private static final int MSN_INTERNAL_RL = 8;
    static final String RAW_NONE = "NONE";
    static final String RAW_AL = "AL";
    static final String RAW_BL = "BL";
    static final String RAW_RL = "RL";
    static final String RAW_FL = "FL";
    public static final int NONE = -1;
    public static final int ALLOW_LIST = 0;
    public static final int BLOCK_LIST = 1;
    public static final int REVERSE_LIST = 2;
    public static final int FORWARD_LIST = 3;
    static HashMap hContactListMap = new HashMap();
    HashMap hContacts = new HashMap();
    long nContactListVersion = 0L;

    ContactList() {
    }

    public void setContactListVersion(long nContactListVersion) {
        this.nContactListVersion = nContactListVersion;
    }

    public long getContactListVersion() {
        return this.nContactListVersion;
    }

    synchronized void addToContactList(Contact contact) {
        this.hContacts.put(contact.getUserName(), contact);
    }

    synchronized void removeFromContactList(Contact contact) {
        contact.clearListType();
        this.hContacts.remove(contact.getUserName());
    }

    synchronized void removeAll() {
        this.hContacts.clear();
    }

    static synchronized Hashtable parseListType(String strRawList) {
        Integer iListType = (Integer)hContactListMap.get(strRawList.trim());
        Hashtable<Integer, Integer> hLists = new Hashtable<Integer, Integer>();
        if (iListType != null) {
            hLists.put(iListType, iListType);
        } else {
            Integer iValue;
            int nAllLists = Integer.parseInt(strRawList.trim());
            if ((nAllLists & 2) != 0) {
                iValue = (Integer)hContactListMap.get(RAW_AL);
                hLists.put(iValue, iValue);
            }
            if ((nAllLists & 1) != 0) {
                iValue = (Integer)hContactListMap.get(RAW_FL);
                hLists.put(iValue, iValue);
            }
            if ((nAllLists & 4) != 0) {
                iValue = (Integer)hContactListMap.get(RAW_BL);
                hLists.put(iValue, iValue);
            }
            if ((nAllLists & 8) != 0) {
                iValue = (Integer)hContactListMap.get(RAW_RL);
                hLists.put(iValue, iValue);
            }
        }
        return hLists;
    }

    static String parseListType(int nListType) {
        switch (nListType) {
            case 3: {
                return RAW_FL;
            }
            case 1: {
                return RAW_BL;
            }
            case 0: {
                return RAW_AL;
            }
            case 2: {
                return RAW_RL;
            }
        }
        return RAW_NONE;
    }

    static Integer parseListTypeToInteger(String strRawList) {
        return (Integer)hContactListMap.get(strRawList);
    }

    public Contact[] getContacts() {
        HashMap clone = (HashMap)this.hContacts.clone();
        return (Contact[])clone.values().toArray();
    }

    public Contact getContact(String strUserName) throws MSNException {
        Contact contact = (Contact)this.hContacts.get(strUserName);
        if (contact == null) {
            throw new MSNException(2);
        }
        return contact;
    }

    static {
        hContactListMap.put(RAW_AL, new Integer(0));
        hContactListMap.put(RAW_BL, new Integer(1));
        hContactListMap.put(RAW_RL, new Integer(2));
        hContactListMap.put(RAW_FL, new Integer(3));
    }
}

