/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.p2p;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sf.cindy.util.ByteBufferUtils;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnProtocol;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.message.p2p.DisplayPictureDuel;
import net.sf.jml.message.p2p.DisplayPictureDuelManager;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingMSG;
import net.sf.jml.util.Charset;

public abstract class MsnP2PMessage
extends MsnMimeMessage {
    protected static final int BINARY_HEADER_LEN = 48;
    protected static final int BINARY_FOOTER_LEN = 4;
    protected static final String KEY_P2P_DEST = "P2P-Dest";
    protected static final int FLAG_NONE = 0;
    protected static final int FLAG_ACK = 2;
    protected static final int FLAG_BYE_ACK = 64;
    protected static final int FLAG_DATA = 32;
    protected static final int FLAG_BYE = 128;
    private final ByteBuffer binaryHeader = ByteBuffer.allocate(48).order(ByteOrder.LITTLE_ENDIAN);
    private final ByteBuffer binaryFooter = ByteBuffer.allocate(4);

    public MsnP2PMessage() {
        this.setContentType("application/x-msnmsgrp2p");
    }

    public void setP2PDest(String string) {
        this.headers.setProperty(KEY_P2P_DEST, string);
    }

    public String getP2PDest() {
        return this.headers.getProperty(KEY_P2P_DEST);
    }

    public void setAppId(int n) {
        this.binaryFooter.putInt(0, n);
    }

    public int getAppId() {
        return this.binaryFooter.getInt(0);
    }

    public void setSessionId(int n) {
        this.binaryHeader.putInt(0, n);
    }

    public int getSessionId() {
        return this.binaryHeader.getInt(0);
    }

    public void setIdentifier(int n) {
        this.binaryHeader.putInt(4, n);
    }

    public int getIdentifier() {
        return this.binaryHeader.getInt(4);
    }

    protected void setOffset(long l) {
        this.binaryHeader.putLong(8, l);
    }

    protected long getOffset() {
        return this.binaryHeader.getLong(8);
    }

    protected void setTotalLength(long l) {
        this.binaryHeader.putLong(16, l);
    }

    protected long getTotalLength() {
        return this.binaryHeader.getLong(16);
    }

    protected void setCurrentLength(int n) {
        this.binaryHeader.putInt(24, n);
    }

    protected int getCurrentLength() {
        return this.binaryHeader.getInt(24);
    }

    public void setFlag(int n) {
        this.binaryHeader.putInt(28, n);
    }

    protected int getFlag() {
        return this.binaryHeader.getInt(28);
    }

    public void setField7(int n) {
        this.binaryHeader.putInt(32, n);
    }

    public int getField7() {
        return this.binaryHeader.getInt(32);
    }

    public void setField8(int n) {
        this.binaryHeader.putInt(36, n);
    }

    public int getField8() {
        return this.binaryHeader.getInt(36);
    }

    public void setField9(long l) {
        this.binaryHeader.putLong(40, l);
    }

    public long getField9() {
        return this.binaryHeader.getLong(40);
    }

    protected void parseMessage(byte[] byArray) {
        ByteBuffer byteBuffer = Charset.encode("\r\n\r\n");
        int n = ByteBufferUtils.indexOf((ByteBuffer)ByteBuffer.wrap(byArray), (ByteBuffer)byteBuffer);
        String string = n == -1 ? Charset.decode(byArray) : Charset.decode(byArray, 0, n);
        this.headers.parseString(string);
        this.binaryHeader.put(byArray, n += byteBuffer.remaining(), 48);
        this.binaryHeader.flip();
        this.parseP2PBody(ByteBuffer.wrap(byArray, n += 48, byArray.length - n - 4));
        this.binaryFooter.put(byArray, byArray.length - 4, 4);
        this.binaryFooter.flip();
    }

    public OutgoingMSG[] toOutgoingMsg(MsnProtocol msnProtocol) {
        OutgoingMSG outgoingMSG = new OutgoingMSG(msnProtocol);
        outgoingMSG.setMsgType(OutgoingMSG.TYPE_MSNC1);
        byte[] byArray = Charset.encodeAsByteArray(this.toString());
        byte[] byArray2 = this.bodyToMessage();
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + 48 + byArray2.length + 4);
        byteBuffer.put(byArray);
        byteBuffer.put(this.binaryHeader);
        byteBuffer.put(byArray2);
        byteBuffer.put(this.binaryFooter);
        outgoingMSG.setMsg(byteBuffer.array());
        return new OutgoingMSG[]{outgoingMSG};
    }

    protected abstract void parseP2PBody(ByteBuffer var1);

    protected abstract byte[] bodyToMessage();

    protected void messageReceived(MsnSession msnSession, MsnContact msnContact) {
        DisplayPictureDuel displayPictureDuel = DisplayPictureDuelManager.getDuelManager().get(this.getField7());
        if (displayPictureDuel != null) {
            displayPictureDuel.process(this, msnContact);
        }
    }
}

