/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.StringUtils;

public class VCardTempXUpdatePresenceExtension
implements PacketExtension,
PacketInterceptor {
    public static final String ELEMENT_NAME = "x";
    public static final String NAMESPACE = "vcard-temp:x:update";
    private String imageSha1 = null;
    private String xmlString = null;

    public VCardTempXUpdatePresenceExtension(byte[] imageBytes) {
        this.computeXML();
        this.updateImage(imageBytes);
    }

    public boolean updateImage(byte[] imageBytes) {
        boolean isImageUpdated = false;
        String tmpImageSha1 = VCardTempXUpdatePresenceExtension.getImageSha1(imageBytes);
        if (tmpImageSha1 != this.imageSha1) {
            this.imageSha1 = tmpImageSha1;
            this.computeXML();
            isImageUpdated = true;
        }
        return isImageUpdated;
    }

    public static String getImageSha1(byte[] image) {
        String imageSha1 = null;
        try {
            if (image != null) {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                imageSha1 = StringUtils.encodeHex((byte[])messageDigest.digest(image));
            }
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        return imageSha1;
    }

    private void computeXML() {
        StringBuilder stringBuilder = new StringBuilder("<" + this.getElementName() + " xmlns='" + this.getNamespace() + "'>");
        if (this.imageSha1 == null) {
            stringBuilder.append("<photo/>");
        } else {
            stringBuilder.append("<photo>" + this.imageSha1 + "</photo>");
        }
        stringBuilder.append("</" + this.getElementName() + ">");
        this.xmlString = stringBuilder.toString();
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String toXML() {
        return this.xmlString;
    }

    public void interceptPacket(Packet packet) {
        packet.addExtension((PacketExtension)this);
    }
}

