/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.LinkedList;
import org.jitsi.videobridge.osgi.OSGi;
import org.jitsi.videobridge.xmpp.ComponentImpl;
import org.jivesoftware.whack.ExternalComponentManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.xmpp.component.Component;

public class Main {
    private static final String APIS_ARG_NAME = "--apis=";
    private static final String DOMAIN_ARG_NAME = "--domain=";
    private static final Object exitSyncRoot = new Object();
    private static final String HOST_ARG_NAME = "--host=";
    private static final String HOST_ARG_VALUE = "localhost";
    private static final String MAX_PORT_ARG_NAME = "--max-port=";
    private static final String MAX_PORT_ARG_VALUE = "20000";
    private static final String MIN_PORT_ARG_NAME = "--min-port=";
    private static final String MIN_PORT_ARG_VALUE = "10000";
    private static final String PORT_ARG_NAME = "--port=";
    private static final int PORT_ARG_VALUE = 5275;
    private static final String SECRET_ARG_NAME = "--secret=";
    private static final String SUBDOMAIN_ARG_NAME = "--subdomain=";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        LinkedList<String> apis = new LinkedList<String>();
        String host = null;
        String maxPort = MAX_PORT_ARG_VALUE;
        String minPort = MIN_PORT_ARG_VALUE;
        int port = 5275;
        String secret = "";
        String domain = null;
        String componentSubdomain = null;
        for (String arg : args) {
            if (arg.startsWith(APIS_ARG_NAME)) {
                for (String api : arg.substring(APIS_ARG_NAME.length()).split(",")) {
                    if (api == null || api.length() == 0 || apis.contains(api)) continue;
                    apis.add(api);
                }
                continue;
            }
            if (arg.startsWith(DOMAIN_ARG_NAME)) {
                domain = arg.substring(DOMAIN_ARG_NAME.length());
                continue;
            }
            if (arg.startsWith(HOST_ARG_NAME)) {
                host = arg.substring(HOST_ARG_NAME.length());
                continue;
            }
            if (arg.startsWith(MAX_PORT_ARG_NAME)) {
                maxPort = arg.substring(MAX_PORT_ARG_NAME.length());
                continue;
            }
            if (arg.startsWith(MIN_PORT_ARG_NAME)) {
                minPort = arg.substring(MIN_PORT_ARG_NAME.length());
                continue;
            }
            if (arg.startsWith(PORT_ARG_NAME)) {
                port = Integer.parseInt(arg.substring(PORT_ARG_NAME.length()));
                continue;
            }
            if (arg.startsWith(SECRET_ARG_NAME)) {
                secret = arg.substring(SECRET_ARG_NAME.length());
                continue;
            }
            if (!arg.startsWith(SUBDOMAIN_ARG_NAME)) continue;
            componentSubdomain = arg.substring(SUBDOMAIN_ARG_NAME.length());
        }
        if (apis.isEmpty()) {
            apis.add("xmpp");
        }
        if (host == null) {
            host = domain == null ? HOST_ARG_VALUE : domain;
        }
        System.setProperty("org.jitsi.videobridge.rest", Boolean.toString(apis.contains("rest")));
        System.setProperty("org.jitsi.videobridge.xmpp", Boolean.toString(apis.contains("xmpp")));
        if (maxPort != null && maxPort.length() != 0) {
            System.setProperty("net.java.sip.communicator.service.media.MAX_PORT_NUMBER", maxPort);
            System.setProperty("net.java.sip.communicator.service.protocol.MAX_MEDIA_PORT_NUMBER", maxPort);
        }
        if (minPort != null && minPort.length() != 0) {
            System.setProperty("net.java.sip.communicator.service.media.MIN_PORT_NUMBER", minPort);
            System.setProperty("net.java.sip.communicator.service.protocol.MIN_MEDIA_PORT_NUMBER", minPort);
        }
        OSGi.start(new BundleActivator(){

            public void start(BundleContext bundleContext) throws Exception {
            }

            public void stop(BundleContext bundleContext) throws Exception {
            }
        });
        if (apis.contains("xmpp")) {
            ExternalComponentManager componentManager = new ExternalComponentManager(host, port);
            String subdomain = "jitsi-videobridge";
            if (componentSubdomain != null) {
                subdomain = componentSubdomain;
            }
            componentManager.setMultipleAllowed(subdomain, true);
            componentManager.setSecretKey(subdomain, secret);
            if (domain != null) {
                componentManager.setServerName(domain);
            }
            ComponentImpl component = new ComponentImpl();
            componentManager.addComponent(subdomain, (Component)component);
            while (true) {
                boolean interrupted = false;
                Object object = exitSyncRoot;
                synchronized (object) {
                    try {
                        exitSyncRoot.wait();
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                }
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
            }
        }
    }
}

