/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.simulcast;

import java.net.DatagramPacket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.util.Logger;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.simulcast.SimulcastLayer;
import org.jitsi.videobridge.simulcast.SimulcastReceiver;
import org.jitsi.videobridge.simulcast.SimulcastReceiverOptions;
import org.jitsi.videobridge.simulcast.StringCompiler;
import org.jitsi.videobridge.simulcast.messages.SimulcastMessagesMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulcastManager
extends PropertyChangeNotifier {
    private static final Logger logger = Logger.getLogger(SimulcastManager.class);
    private static final SimulcastMessagesMapper mapper = new SimulcastMessagesMapper();
    protected static final int SIMULCAST_LAYER_ORDER_HQ = 1;
    public static final int SIMULCAST_LAYER_ORDER_LQ = 0;
    protected static final int SIMULCAST_LAYER_ORDER_INIT = 0;
    public static final int SIMULCAST_LAYER_ORDER_NO_OVERRIDE = -1;
    protected static final String SIMULCAST_LAYERS_PROPERTY = SimulcastManager.class.getName() + ".simulcastLayers";
    private SortedSet<SimulcastLayer> simulcastLayers;
    private final Object simulcastLayersSyncRoot = new Object();
    private final Map<SimulcastManager, SimulcastReceiver> simulcastReceivers = new WeakHashMap<SimulcastManager, SimulcastReceiver>();
    private final VideoChannel videoChannel;

    public SimulcastManager(VideoChannel videoChannel) {
        this.videoChannel = videoChannel;
    }

    public boolean accept(byte[] buffer, int offset, int length, VideoChannel peerVC) {
        long ssrc;
        SimulcastManager peerSM;
        boolean accept = true;
        if (peerVC != null && (peerSM = peerVC.getSimulcastManager()) != null && peerSM.hasLayers() && (ssrc = (long)this.readSSRC(buffer, offset, length) & 0xFFFFFFFFL) > 0L) {
            accept = this.accept(ssrc, peerVC);
        }
        return accept;
    }

    public boolean accept(long ssrc, VideoChannel peerVC) {
        SimulcastReceiver sr;
        SimulcastManager peerSM;
        boolean accept = true;
        if (ssrc > 0L && peerVC != null && (peerSM = peerVC.getSimulcastManager()) != null && peerSM.hasLayers() && (sr = this.getOrCreateSimulcastReceiver(peerSM)) != null) {
            accept = sr.accept(ssrc);
        }
        return accept;
    }

    public void acceptedDataInputStreamDatagramPacket(DatagramPacket p) {
        if (this.hasLayers() && p != null) {
            int acceptedSSRC = this.readSSRC(p.getData(), p.getOffset(), p.getLength());
            SortedSet<SimulcastLayer> layers = null;
            SimulcastLayer acceptedLayer = null;
            if (acceptedSSRC != 0) {
                layers = this.getSimulcastLayers();
                for (SimulcastLayer layer : layers) {
                    if ((int)layer.getPrimarySSRC() != acceptedSSRC) continue;
                    acceptedLayer = layer;
                    break;
                }
            }
            if (acceptedLayer == null) {
                return;
            }
            acceptedLayer.acceptedDataInputStreamDatagramPacket(p);
            if (acceptedLayer == layers.first()) {
                for (SimulcastLayer layer : layers) {
                    if (acceptedLayer == layer) continue;
                    layer.maybeTimeout();
                }
            } else {
                acceptedLayer.touch();
            }
        }
    }

    public long getIncomingBitrate(SimulcastManager peerSM, boolean noOverride) {
        long bitrate = 0L;
        if (peerSM == null || !peerSM.hasLayers()) {
            return bitrate;
        }
        SimulcastReceiver sr = this.getOrCreateSimulcastReceiver(peerSM);
        if (sr != null) {
            bitrate = sr.getIncomingBitrate(noOverride);
        }
        return bitrate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimulcastReceiver getOrCreateSimulcastReceiver(SimulcastManager peerSM) {
        SimulcastReceiver sr = null;
        if (peerSM != null && peerSM.hasLayers()) {
            Map<SimulcastManager, SimulcastReceiver> map = this.simulcastReceivers;
            synchronized (map) {
                if (!this.simulcastReceivers.containsKey((Object)peerSM)) {
                    sr = new SimulcastReceiver(this, peerSM);
                    this.simulcastReceivers.put(peerSM, sr);
                } else {
                    sr = this.simulcastReceivers.get((Object)peerSM);
                }
            }
        }
        return sr;
    }

    protected SimulcastLayer getSimulcastLayer(int targetOrder) {
        SimulcastLayer next = null;
        SortedSet<SimulcastLayer> layers = this.getSimulcastLayers();
        if (layers != null && !layers.isEmpty()) {
            Iterator it = layers.iterator();
            int currentLayer = 0;
            while (it.hasNext() && currentLayer++ <= targetOrder) {
                next = (SimulcastLayer)it.next();
            }
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<SimulcastLayer> getSimulcastLayers() {
        Object object = this.simulcastLayersSyncRoot;
        synchronized (object) {
            return this.simulcastLayers == null ? null : new TreeSet<SimulcastLayer>(this.simulcastLayers);
        }
    }

    public VideoChannel getVideoChannel() {
        return this.videoChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLayers() {
        Object object = this.simulcastLayersSyncRoot;
        synchronized (object) {
            return this.simulcastLayers != null && this.simulcastLayers.size() > 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean override(int overrideOrder) {
        Map<SimulcastManager, SimulcastReceiver> map = this.simulcastReceivers;
        synchronized (map) {
            Integer oldOverrideOrder = SimulcastReceiver.initOptions.getOverrideOrder();
            if (oldOverrideOrder == null || oldOverrideOrder != overrideOrder) {
                SimulcastReceiver.initOptions.setOverrideOrder(overrideOrder);
                if (!this.simulcastReceivers.isEmpty()) {
                    SimulcastReceiverOptions options = new SimulcastReceiverOptions();
                    options.setOverrideOrder(overrideOrder);
                    for (SimulcastReceiver sr : this.simulcastReceivers.values()) {
                        sr.configure(options);
                    }
                }
                return true;
            }
            return false;
        }
    }

    private int readSSRC(byte[] buffer, int offset, int length) {
        int v;
        if (length >= 12 && (v = (buffer[offset] & 0xC0) >>> 6) == 2) {
            return RTPTranslatorImpl.readInt((byte[])buffer, (int)(offset + 8));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSimulcastLayers(SortedSet<SimulcastLayer> simulcastLayers) {
        Object object = this.simulcastLayersSyncRoot;
        synchronized (object) {
            this.simulcastLayers = simulcastLayers;
        }
        new Thread(new Runnable(){

            public void run() {
                SimulcastManager.this.firePropertyChange(SIMULCAST_LAYERS_PROPERTY, null, null);
            }
        }).start();
        if (logger.isDebugEnabled()) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("self", this.videoChannel.getEndpoint());
            map.put("simulcastLayers", mapper.toJson(simulcastLayers));
            StringCompiler sc = new StringCompiler(map);
            logger.debug((Object)sc.c("{self.id} signals {simulcastLayers}"));
        }
    }
}

