/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.ratecontrol;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.ratecontrol.BitrateAdaptor;
import org.jitsi.videobridge.ratecontrol.BitrateController;
import org.jitsi.videobridge.ratecontrol.SimulcastAdaptor;
import org.jitsi.videobridge.simulcast.StringCompiler;
import org.osgi.framework.BundleContext;

public class VideoChannelLastNAdaptor
implements BitrateAdaptor {
    private static final String MIN_ENDPOINTS_BEFORE_HQ_DROP_PNAME = VideoChannelLastNAdaptor.class.getName() + ".MIN_ENDPOINTS_BEFORE_HQ_DROP";
    private static int MIN_ENDPOINTS_BEFORE_HQ_DROP = 2;
    private static final String MAX_STAY_AT_ZERO_MS_PNAME = VideoChannelLastNAdaptor.class.getName() + ".MAX_STAY_AT_ZERO_MS";
    private static int MAX_STAY_AT_ZERO_MS = 60000;
    private static final Logger logger = Logger.getLogger(VideoChannelLastNAdaptor.class);
    private final BitrateController bitrateController;
    private SimulcastAdaptor slaveSimulcastAdaptor;
    private boolean initialLastNSet = false;
    private static boolean configurationInitialized = false;
    private long lastNonZeroLastN = -1L;

    public VideoChannelLastNAdaptor(BitrateController bitrateController) {
        this.bitrateController = bitrateController;
        if (bitrateController.getChannel().getAdaptiveSimulcast()) {
            this.slaveSimulcastAdaptor = new SimulcastAdaptor(bitrateController);
        }
        this.initializeConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConfiguration() {
        Class<VideoChannelLastNAdaptor> clazz = VideoChannelLastNAdaptor.class;
        synchronized (VideoChannelLastNAdaptor.class) {
            if (configurationInitialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            configurationInitialized = true;
            VideoChannel channel = this.bitrateController.getChannel();
            ConfigurationService cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)channel.getBundleContext(), ConfigurationService.class);
            if (cfg != null) {
                MIN_ENDPOINTS_BEFORE_HQ_DROP = cfg.getInt(MIN_ENDPOINTS_BEFORE_HQ_DROP_PNAME, MIN_ENDPOINTS_BEFORE_HQ_DROP);
                MAX_STAY_AT_ZERO_MS = cfg.getInt(MAX_STAY_AT_ZERO_MS_PNAME, MAX_STAY_AT_ZERO_MS);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private int setInitialLastN(int lastN) {
        VideoChannel channel = this.bitrateController.getChannel();
        int endpointsCount = 0;
        List<WeakReference<Endpoint>> lastNEndpoints = channel.getLastNEndpoints();
        Endpoint thisEndpoint = channel.getEndpoint();
        for (WeakReference<Endpoint> wr : lastNEndpoints) {
            Endpoint endpoint = (Endpoint)wr.get();
            if (endpoint == null || endpoint.equals(thisEndpoint)) continue;
            ++endpointsCount;
        }
        if (lastN < 0 || lastN > endpointsCount) {
            lastN = endpointsCount;
            channel.setLastN(endpointsCount);
        }
        return lastN;
    }

    public boolean touch() {
        List<WeakReference<Endpoint>> lastNEndpoints;
        long now = System.currentTimeMillis();
        VideoChannel channel = this.bitrateController.getChannel();
        int lastN = channel.getLastN();
        if (lastN > 0) {
            this.lastNonZeroLastN = now;
        }
        if ((lastNEndpoints = channel.getLastNEndpoints()) == null) {
            return false;
        }
        if (!this.initialLastNSet) {
            lastN = this.setInitialLastN(lastN);
            this.initialLastNSet = true;
        }
        if (lastN == 0 && this.lastNonZeroLastN != -1L && now - this.lastNonZeroLastN > (long)MAX_STAY_AT_ZERO_MS) {
            channel.setLastN(1);
            return false;
        }
        return true;
    }

    public boolean increase() {
        VideoChannel channel = this.bitrateController.getChannel();
        Endpoint thisEndpoint = channel.getEndpoint();
        int lastN = channel.getLastN();
        int numEndpointsThatFitIn = this.bitrateController.calcNumEndpointsThatFitIn();
        boolean increased = false;
        if (numEndpointsThatFitIn > MIN_ENDPOINTS_BEFORE_HQ_DROP && this.slaveSimulcastAdaptor != null && this.slaveSimulcastAdaptor.increase()) {
            numEndpointsThatFitIn = this.bitrateController.calcNumEndpointsThatFitIn();
            increased = true;
        }
        if (numEndpointsThatFitIn > lastN) {
            if (logger.isDebugEnabled()) {
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("self", thisEndpoint);
                map.put("numEndpointsThatFitIn", numEndpointsThatFitIn);
                map.put("lastN", lastN);
                map.put("newN", lastN + 1);
                StringCompiler sc = new StringCompiler(map);
                logger.debug((Object)sc.c("The uplink between the bridge and {self.id} receives {receivingEndpointsCount} but it can support {numEndpointsThatFitIn}. Conservatively increasing lastN to {newN}."));
            }
            channel.setLastN(lastN + 1);
            increased = true;
        }
        return increased;
    }

    public boolean decrease() {
        VideoChannel channel = this.bitrateController.getChannel();
        Endpoint thisEndpoint = channel.getEndpoint();
        int lastN = channel.getLastN();
        int numEndpointsThatFitIn = this.bitrateController.calcNumEndpointsThatFitIn();
        boolean decreased = false;
        if (numEndpointsThatFitIn <= MIN_ENDPOINTS_BEFORE_HQ_DROP && this.slaveSimulcastAdaptor != null && this.slaveSimulcastAdaptor.decrease()) {
            numEndpointsThatFitIn = this.bitrateController.calcNumEndpointsThatFitIn();
            decreased = true;
        }
        if (numEndpointsThatFitIn < lastN) {
            int newn = Math.min(numEndpointsThatFitIn - 1, lastN / 2);
            if (newn < 0) {
                newn = 0;
            }
            if (logger.isDebugEnabled()) {
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("self", thisEndpoint);
                map.put("numEndpointsThatFitIn", numEndpointsThatFitIn);
                map.put("lastN", lastN);
                map.put("newN", newn);
                StringCompiler sc = new StringCompiler(map);
                logger.debug((Object)sc.c("The uplink between the bridge and {self.id} currently receives {receivingEndpointsCount} but it can only support {numEndpointsThatFitIn}. Aggressively reducing lastN to {newN}."));
            }
            channel.setLastN(newn);
            decreased = true;
        }
        return decreased;
    }
}

