/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEndpointManager;
import com.hazelcast.client.impl.ClientEndpointImpl;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.NodeEngine;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;

public class ClientEndpointManagerImpl
implements ClientEndpointManager {
    private static final int DESTROY_ENDPOINT_DELAY_MS = 1111;
    private final ILogger logger;
    private final ClientEngineImpl clientEngine;
    private final NodeEngine nodeEngine;
    private final ConcurrentMap<Connection, ClientEndpoint> endpoints = new ConcurrentHashMap<Connection, ClientEndpoint>();

    public ClientEndpointManagerImpl(ClientEngineImpl clientEngine, NodeEngine nodeEngine) {
        this.clientEngine = clientEngine;
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(ClientEndpointManager.class);
    }

    @Override
    public Set<ClientEndpoint> getEndpoints(String clientUuid) {
        HashSet<ClientEndpoint> endpointSet = new HashSet<ClientEndpoint>();
        for (ClientEndpoint endpoint : this.endpoints.values()) {
            if (!clientUuid.equals(endpoint.getUuid())) continue;
            endpointSet.add(endpoint);
        }
        return endpointSet;
    }

    @Override
    public ClientEndpoint getEndpoint(Connection conn) {
        return (ClientEndpoint)this.endpoints.get(conn);
    }

    @Override
    public void registerEndpoint(ClientEndpoint endpoint) {
        Connection conn = endpoint.getConnection();
        if (this.endpoints.putIfAbsent(conn, endpoint) != null) {
            this.logger.severe("An endpoint already exists for connection:" + conn);
        }
    }

    @Override
    public void removeEndpoint(ClientEndpoint endpoint) {
        this.removeEndpoint(endpoint, false);
    }

    @Override
    public void removeEndpoint(ClientEndpoint ce, boolean closeImmediately) {
        ClientEndpointImpl endpoint = (ClientEndpointImpl)ce;
        this.endpoints.remove(endpoint.getConnection());
        this.logger.info("Destroying " + endpoint);
        try {
            endpoint.destroy();
        }
        catch (LoginException e) {
            this.logger.warning(e);
        }
        final Connection connection = endpoint.getConnection();
        if (closeImmediately) {
            try {
                connection.close();
            }
            catch (Throwable e) {
                this.logger.warning("While closing client connection: " + connection, e);
            }
        } else {
            this.nodeEngine.getExecutionService().schedule(new Runnable(){

                @Override
                public void run() {
                    if (connection.live()) {
                        try {
                            connection.close();
                        }
                        catch (Throwable e) {
                            ClientEndpointManagerImpl.this.logger.warning("While closing client connection: " + e.toString());
                        }
                    }
                }
            }, 1111L, TimeUnit.MILLISECONDS);
        }
        this.clientEngine.sendClientEvent(endpoint);
    }

    public void removeEndpoints(String memberUuid) {
        Iterator iterator = this.endpoints.values().iterator();
        while (iterator.hasNext()) {
            ClientEndpoint endpoint = (ClientEndpoint)iterator.next();
            String ownerUuid = endpoint.getPrincipal().getOwnerUuid();
            if (!memberUuid.equals(ownerUuid)) continue;
            iterator.remove();
            this.removeEndpoint(endpoint, true);
        }
    }

    @Override
    public void clear() {
        this.endpoints.clear();
    }

    @Override
    public Collection<ClientEndpoint> getEndpoints() {
        Collection<ClientEndpoint> tmp = this.endpoints.values();
        return tmp;
    }

    @Override
    public int size() {
        return this.endpoints.size();
    }
}

