/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.BasicJitterBufferBehaviour;
import net.sf.fmj.media.rtp.RTPSourceStream;

class VideoJitterBufferBehaviour
extends BasicJitterBufferBehaviour {
    private static final int BUF_CHECK_INTERVAL = 7000;
    private static final int DEFAULT_PKTS_TO_BUFFER = 90;
    private static final int DEFAULT_VIDEO_RATE = 15;
    private static final int FUDGE = 5;
    private static final VideoFormat H264 = new VideoFormat("h264/rtp");
    private static final int MIN_BUF_CHECK = 10000;
    private static final VideoFormat MPEG = new VideoFormat("mpeg/rtp");
    private int fps = 15;
    private int framesEst = 0;
    private long lastCheckTime = 0L;
    private long lastPktSeq = 0L;
    private int maxPktsToBuffer = 0;
    private int pktsEst;
    private int pktsPerFrame = 15;
    private int tooMuchBufferingCount = 0;

    public VideoJitterBufferBehaviour(RTPSourceStream stream) {
        super(stream);
    }

    private void cutByHalf() {
        int capacity = this.q.getCapacity() / 2;
        if (capacity > 0) {
            this.q.setCapacity(capacity);
        }
    }

    protected void dropFirstPkt() {
        if (MPEG.matches(this.stream.getFormat())) {
            this.dropMpegPkt();
        } else {
            super.dropFirstPkt();
        }
    }

    private void dropMpegPkt() {
        int i;
        int j = -1;
        int k = -1;
        int count = this.q.getFillCount();
        for (i = 0; i < count; ++i) {
            int l;
            Buffer buffer = this.q.getFill(i);
            byte[] abyte0 = (byte[])buffer.getData();
            int i1 = abyte0[(l = buffer.getOffset()) + 2] & 7;
            if (i1 > 2) {
                k = i;
                break;
            }
            if (i1 != 2 || j != -1) continue;
            j = i;
        }
        if (k == -1) {
            i = j != -1 ? j : 0;
        }
        this.q.dropFill(i);
    }

    public boolean isAdaptive() {
        return true;
    }

    protected int monitorQSize(Buffer buffer) {
        int aprxBufferLengthInPkts;
        BufferControl bc;
        super.monitorQSize(buffer);
        this.pktsEst = this.lastPktSeq + 1L == buffer.getSequenceNumber() ? ++this.pktsEst : 1;
        this.lastPktSeq = buffer.getSequenceNumber();
        Format format = this.stream.getFormat();
        if (MPEG.matches(format)) {
            int k;
            byte[] abyte0 = (byte[])buffer.getData();
            int k1 = abyte0[(k = buffer.getOffset()) + 2] & 7;
            if (k1 < 3 && (buffer.getFlags() & 0x800) != 0) {
                this.pktsPerFrame = (this.pktsPerFrame + this.pktsEst) / 2;
                this.pktsEst = 0;
            }
            this.fps = 30;
        } else if (H264.matches(format)) {
            this.pktsPerFrame = 300;
            this.fps = 15;
        }
        if ((buffer.getFlags() & 0x800) != 0) {
            this.pktsPerFrame = (this.pktsPerFrame + this.pktsEst) / 2;
            this.pktsEst = 0;
            ++this.framesEst;
            long l = System.currentTimeMillis();
            if (l - this.lastCheckTime >= 1000L) {
                this.lastCheckTime = l;
                this.fps = (this.fps + this.framesEst) / 2;
                this.framesEst = 0;
                if (this.fps > 30) {
                    this.fps = 30;
                }
            }
        }
        if ((bc = this.getBufferControl()) != null) {
            aprxBufferLengthInPkts = (int)(bc.getBufferLength() * (long)this.fps / 1000L);
            if (aprxBufferLengthInPkts <= 0) {
                aprxBufferLengthInPkts = 1;
            }
            aprxBufferLengthInPkts = this.pktsPerFrame * aprxBufferLengthInPkts;
        } else {
            aprxBufferLengthInPkts = 90;
        }
        this.maxPktsToBuffer = H264.matches(format) ? 200 : (this.maxPktsToBuffer > 0 ? (this.maxPktsToBuffer + aprxBufferLengthInPkts) / 2 : aprxBufferLengthInPkts);
        int size = this.q.getCapacity();
        int i1 = this.q.getFillCount();
        if (size > 10000 && i1 < size / 4) {
            if (this.tooMuchBufferingCount++ > this.pktsPerFrame * this.fps * 7000) {
                this.cutByHalf();
                this.tooMuchBufferingCount = 0;
            }
        } else if (i1 >= size / 2 && size < this.maxPktsToBuffer) {
            aprxBufferLengthInPkts = size + size / 2;
            if (aprxBufferLengthInPkts > this.maxPktsToBuffer) {
                aprxBufferLengthInPkts = this.maxPktsToBuffer;
            }
            this.q.setCapacity(aprxBufferLengthInPkts + 5);
            size = this.q.getCapacity();
            Log.comment("RTP video buffer size: " + size + " pkts, " + aprxBufferLengthInPkts * this.stats.getSizePerPacket() + " bytes.\n");
            this.tooMuchBufferingCount = 0;
        } else {
            this.tooMuchBufferingCount = 0;
        }
        return aprxBufferLengthInPkts;
    }

    public void reset() {
        super.reset();
        this.tooMuchBufferingCount = 0;
    }
}

