/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPPacket;

public class RTCPAPPPacket
extends RTCPPacket {
    int ssrc;
    int name;
    int subtype;
    byte[] data;

    public RTCPAPPPacket(int ssrc, int name, int subtype, byte[] data) {
        this.ssrc = ssrc;
        this.name = name;
        this.subtype = subtype;
        this.data = data;
        this.type = 204;
        this.received = false;
        if ((data.length & 3) != 0) {
            throw new IllegalArgumentException("Bad data length");
        }
        if (subtype < 0 || subtype > 31) {
            throw new IllegalArgumentException("Bad subtype");
        }
    }

    public RTCPAPPPacket(RTCPPacket parent) {
        super(parent);
        this.type = 204;
    }

    void assemble(DataOutputStream out) throws IOException {
        out.writeByte(128 + this.subtype);
        out.writeByte(204);
        out.writeShort(2 + (this.data.length >> 2));
        out.writeInt(this.ssrc);
        out.writeInt(this.name);
        out.write(this.data);
    }

    public int calcLength() {
        return 12 + this.data.length;
    }

    public String nameString(int name) {
        return "" + (char)(name >>> 24) + (char)(name >>> 16 & 0xFF) + (char)(name >>> 8 & 0xFF) + (char)(name & 0xFF);
    }

    public String toString() {
        return "\tRTCP APP Packet from SSRC " + this.ssrc + " with name " + this.nameString(this.name) + " and subtype " + this.subtype + "\n\tData (length " + this.data.length + "): " + new String(this.data) + "\n";
    }
}

