/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Random;
import net.java.sip.communicator.service.dns.DnssecException;
import net.java.sip.communicator.service.dns.DnssecRuntimeException;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.SRVRecord;
import net.java.sip.communicator.util.UtilActivator;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.TextParseException;

public class NetworkUtils {
    private static final Logger logger = Logger.getLogger(NetworkUtils.class);
    public static final String IN6_ADDR_ANY = "::0";
    public static final String IN4_ADDR_ANY = "0.0.0.0";
    public static final String IN_ADDR_ANY = NetworkUtils.determineAnyAddress();
    private static final int IN6_ADDR_SIZE = 16;
    private static final int IN6_ADDR_TOKEN_SIZE = 2;
    private static final int IN4_ADDR_SIZE = 4;
    public static final int MAX_PORT_NUMBER = 65535;
    public static final int MIN_PORT_NUMBER = 1024;
    private static Random portNumberGenerator = new Random();
    public static final String PNAME_DNS_ALWAYS_ABSOLUTE = "net.java.sip.communicator.util.dns.DNSSEC_ALWAYS_ABSOLUTE";
    public static final boolean PDEFAULT_DNS_ALWAYS_ABSOLUTE = false;
    private static final Random random = new Random();

    public static boolean isWindowsAutoConfiguredIPv4Address(InetAddress add) {
        return (add.getAddress()[0] & 0xFF) == 169 && (add.getAddress()[1] & 0xFF) == 254;
    }

    public static boolean isLinkLocalIPv4Address(InetAddress add) {
        if (add instanceof Inet4Address) {
            byte[] address = add.getAddress();
            if ((address[0] & 0xFF) == 10) {
                return true;
            }
            if ((address[0] & 0xFF) == 172 && (address[1] & 0xFF) >= 16 && address[1] <= 31) {
                return true;
            }
            return (address[0] & 0xFF) == 192 && (address[1] & 0xFF) == 168;
        }
        return false;
    }

    public static int getRandomPortNumber() {
        return NetworkUtils.getRandomPortNumber(1024, 65535);
    }

    public static int getRandomPortNumber(int min, int max) {
        return portNumberGenerator.nextInt(max - min) + min;
    }

    public static int getRandomPortNumber(int min, int max, boolean pair) {
        if (pair) {
            int delta = max - min;
            int port = NetworkUtils.getRandomPortNumber(min, min + (delta /= 2));
            return port * 2;
        }
        return NetworkUtils.getRandomPortNumber(min, max);
    }

    public static boolean isIPv4Address(String address) {
        return NetworkUtils.strToIPv4(address) != null;
    }

    public static boolean isIPv6Address(String address) {
        return NetworkUtils.strToIPv6(address) != null;
    }

    public static boolean isValidIPAddress(String address) {
        if (address == null || address.length() == 0) {
            return false;
        }
        boolean ipv6Expected = false;
        if (address.charAt(0) == '[') {
            if (address.length() > 2 && address.charAt(address.length() - 1) == ']') {
                address = address.substring(1, address.length() - 1);
                ipv6Expected = true;
            } else {
                return false;
            }
        }
        if (Character.digit(address.charAt(0), 16) != -1 || address.charAt(0) == ':') {
            byte[] addr = null;
            addr = NetworkUtils.strToIPv4(address);
            if (addr == null) {
                addr = NetworkUtils.strToIPv6(address);
            } else if (ipv6Expected) {
                return false;
            }
            if (addr != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] strToIPv4(String ipv4AddrStr) {
        if (ipv4AddrStr == null) return null;
        if (ipv4AddrStr.length() == 0) {
            return null;
        }
        byte[] address = new byte[4];
        String[] tokens = ipv4AddrStr.split("\\.", -1);
        try {
            switch (tokens.length) {
                case 1: {
                    long currentTkn = Long.parseLong(tokens[0]);
                    if (currentTkn < 0L) return null;
                    if (currentTkn > 0xFFFFFFFFL) {
                        return null;
                    }
                    address[0] = (byte)(currentTkn >> 24 & 0xFFL);
                    address[1] = (byte)((currentTkn & 0xFFFFFFL) >> 16 & 0xFFL);
                    address[2] = (byte)((currentTkn & 0xFFFFL) >> 8 & 0xFFL);
                    address[3] = (byte)(currentTkn & 0xFFL);
                    return address;
                }
                case 2: {
                    long currentTkn = Integer.parseInt(tokens[0]);
                    if (currentTkn < 0L) return null;
                    if (currentTkn > 255L) {
                        return null;
                    }
                    address[0] = (byte)(currentTkn & 0xFFL);
                    currentTkn = Integer.parseInt(tokens[1]);
                    if (currentTkn < 0L) return null;
                    if (currentTkn > 0xFFFFFFL) {
                        return null;
                    }
                    address[1] = (byte)(currentTkn >> 16 & 0xFFL);
                    address[2] = (byte)((currentTkn & 0xFFFFL) >> 8 & 0xFFL);
                    address[3] = (byte)(currentTkn & 0xFFL);
                    return address;
                }
                case 3: {
                    long currentTkn;
                    int i = 0;
                    while (true) {
                        if (i >= 2) {
                            currentTkn = Integer.parseInt(tokens[2]);
                            if (currentTkn < 0L) return null;
                            if (currentTkn <= 65535L) break;
                            return null;
                        }
                        currentTkn = Integer.parseInt(tokens[i]);
                        if (currentTkn < 0L) return null;
                        if (currentTkn > 255L) {
                            return null;
                        }
                        address[i] = (byte)(currentTkn & 0xFFL);
                        ++i;
                    }
                    address[2] = (byte)(currentTkn >> 8 & 0xFFL);
                    address[3] = (byte)(currentTkn & 0xFFL);
                    return address;
                }
                case 4: {
                    int i = 0;
                    while (i < 4) {
                        long currentTkn = Integer.parseInt(tokens[i]);
                        if (currentTkn < 0L) return null;
                        if (currentTkn > 255L) {
                            return null;
                        }
                        address[i] = (byte)(currentTkn & 0xFFL);
                        ++i;
                    }
                    return address;
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static byte[] strToIPv6(String ipv6AddrStr) {
        if (ipv6AddrStr == null || ipv6AddrStr.length() < 2) {
            return null;
        }
        char[] addrBuff = ipv6AddrStr.toCharArray();
        byte[] dst = new byte[16];
        int srcb_length = addrBuff.length;
        int scopeID = ipv6AddrStr.indexOf("%");
        if (scopeID == srcb_length - 1) {
            return null;
        }
        if (scopeID != -1) {
            srcb_length = scopeID;
        }
        int colonIndex = -1;
        int i = 0;
        int j = 0;
        if (addrBuff[i] == ':' && addrBuff[++i] != ':') {
            return null;
        }
        int curtok = i;
        boolean sawtDigit = false;
        int currentTkn = 0;
        while (i < srcb_length) {
            char currentChar;
            int chval;
            if ((chval = Character.digit(currentChar = addrBuff[i++], 16)) != -1) {
                currentTkn <<= 4;
                if ((currentTkn |= chval) > 65535) {
                    return null;
                }
                sawtDigit = true;
                continue;
            }
            if (currentChar == ':') {
                curtok = i;
                if (!sawtDigit) {
                    if (colonIndex != -1) {
                        return null;
                    }
                    colonIndex = j;
                    continue;
                }
                if (i == srcb_length) {
                    return null;
                }
                if (j + 2 > 16) {
                    return null;
                }
                dst[j++] = (byte)(currentTkn >> 8 & 0xFF);
                dst[j++] = (byte)(currentTkn & 0xFF);
                sawtDigit = false;
                currentTkn = 0;
                continue;
            }
            if (currentChar == '.' && j + 4 <= 16) {
                String ia4 = ipv6AddrStr.substring(curtok, srcb_length);
                int dot_count = 0;
                int index = 0;
                while ((index = ia4.indexOf(46, index)) != -1) {
                    ++dot_count;
                    ++index;
                }
                if (dot_count != 3) {
                    return null;
                }
                byte[] v4addr = NetworkUtils.strToIPv4(ia4);
                if (v4addr == null) {
                    return null;
                }
                int k = 0;
                while (k < 4) {
                    dst[j++] = v4addr[k];
                    ++k;
                }
                sawtDigit = false;
                break;
            }
            return null;
        }
        if (sawtDigit) {
            if (j + 2 > 16) {
                return null;
            }
            dst[j++] = (byte)(currentTkn >> 8 & 0xFF);
            dst[j++] = (byte)(currentTkn & 0xFF);
        }
        if (colonIndex != -1) {
            int n = j - colonIndex;
            if (j == 16) {
                return null;
            }
            i = 1;
            while (i <= n) {
                dst[16 - i] = dst[colonIndex + n - i];
                dst[colonIndex + n - i] = 0;
                ++i;
            }
            j = 16;
        }
        if (j != 16) {
            return null;
        }
        byte[] newdst = NetworkUtils.mappedIPv4ToRealIPv4(dst);
        if (newdst != null) {
            return newdst;
        }
        return dst;
    }

    public static SRVRecord[] getSRVRecords(String domain) throws ParseException, DnssecException {
        return NetworkUtils.getSRVRecords(domain, true);
    }

    public static SRVRecord[] getSRVRecords(String domain, boolean useDNSCache) throws ParseException, DnssecException {
        Record[] records = null;
        try {
            Lookup lookup2 = NetworkUtils.createLookup(domain, 33);
            if (!useDNSCache) {
                lookup2.setCache(new Cache());
            }
            records = lookup2.run();
        }
        catch (TextParseException tpe) {
            logger.error("Failed to parse domain=" + domain, tpe);
            throw new ParseException(tpe.getMessage(), 0);
        }
        catch (DnssecRuntimeException e) {
            throw new DnssecException(e);
        }
        if (records == null) {
            return null;
        }
        SRVRecord[] srvRecords = new SRVRecord[records.length];
        int i = 0;
        while (i < records.length) {
            org.xbill.DNS.SRVRecord srvRecord = (org.xbill.DNS.SRVRecord)records[i];
            srvRecords[i] = new SRVRecord(srvRecord);
            ++i;
        }
        NetworkUtils.sortSrvRecord(srvRecords);
        if (logger.isTraceEnabled()) {
            logger.trace("DNS SRV query for domain " + domain + " returned:");
            i = 0;
            while (i < srvRecords.length) {
                if (logger.isTraceEnabled()) {
                    logger.trace(srvRecords[i]);
                }
                ++i;
            }
        }
        return srvRecords;
    }

    public static SRVRecord getSRVRecord(String service, String proto, String domain) throws ParseException, DnssecException {
        SRVRecord[] records = NetworkUtils.getSRVRecords("_" + service + "._" + proto + "." + domain, true);
        if (records == null || records.length == 0) {
            return null;
        }
        return records[0];
    }

    public static SRVRecord[] getSRVRecords(String service, String proto, String domain) throws ParseException, DnssecException {
        return NetworkUtils.getSRVRecords(service, proto, domain, true);
    }

    public static SRVRecord[] getSRVRecords(String service, String proto, String domain, boolean useDNSCache) throws ParseException, DnssecException {
        SRVRecord[] records = NetworkUtils.getSRVRecords("_" + service + "._" + proto + "." + domain, useDNSCache);
        if (records == null || records.length == 0) {
            return null;
        }
        return records;
    }

    public static String[][] getNAPTRRecords(String domain) throws ParseException, DnssecException {
        Record[] records = null;
        try {
            Lookup lookup2 = NetworkUtils.createLookup(domain, 35);
            records = lookup2.run();
        }
        catch (TextParseException tpe) {
            logger.error("Failed to parse domain=" + domain, tpe);
            throw new ParseException(tpe.getMessage(), 0);
        }
        catch (DnssecRuntimeException e) {
            throw new DnssecException(e);
        }
        if (records == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("No NAPTRs found for " + domain);
            }
            return null;
        }
        String[][] recVals = new String[records.length][4];
        int i = 0;
        while (i < records.length) {
            NAPTRRecord r = (NAPTRRecord)records[i];
            recVals[i][0] = "" + r.getOrder();
            recVals[i][1] = NetworkUtils.getProtocolFromNAPTRRecords(r.getService());
            String replacement = r.getReplacement().toString();
            recVals[i][2] = replacement.endsWith(".") ? replacement.substring(0, replacement.length() - 1) : replacement;
            recVals[i][3] = "" + r.getPreference();
            ++i;
        }
        Arrays.sort(recVals, new Comparator<String[]>(){

            @Override
            public int compare(String[] array1, String[] array2) {
                int order = Integer.parseInt(array1[0]) - Integer.parseInt(array2[0]);
                if (order != 0) {
                    return order;
                }
                int preference = Integer.parseInt(array1[3]) - Integer.parseInt(array2[3]);
                if (preference != 0) {
                    return preference;
                }
                int protocol = NetworkUtils.getProtocolPriority(array1[1]) - NetworkUtils.getProtocolPriority(array2[1]);
                return protocol;
            }
        });
        if (logger.isTraceEnabled()) {
            logger.trace("NAPTRs for " + domain + "=" + Arrays.toString((Object[])recVals));
        }
        return recVals;
    }

    private static String getProtocolFromNAPTRRecords(String service) {
        if (service.equalsIgnoreCase("SIP+D2U")) {
            return "UDP";
        }
        if (service.equalsIgnoreCase("SIP+D2T")) {
            return "TCP";
        }
        if (service.equalsIgnoreCase("SIPS+D2T")) {
            return "TLS";
        }
        return null;
    }

    private static int getProtocolPriority(String protocol) {
        if (protocol.equals("TLS")) {
            return 0;
        }
        if (protocol.equals("TCP")) {
            return 1;
        }
        return 2;
    }

    public static InetAddress getInetAddress(String hostAddress) throws UnknownHostException {
        if (hostAddress == null || hostAddress.length() == 0) {
            throw new UnknownHostException(String.valueOf(hostAddress) + " is not a valid host address");
        }
        if (hostAddress.charAt(0) == '[') {
            if (hostAddress.length() > 2 && hostAddress.charAt(hostAddress.length() - 1) == ']') {
                hostAddress = hostAddress.substring(1, hostAddress.length() - 1);
            } else {
                throw new UnknownHostException(hostAddress);
            }
        }
        if (NetworkUtils.isValidIPAddress(hostAddress)) {
            byte[] addr = null;
            addr = NetworkUtils.strToIPv4(hostAddress);
            if (addr == null) {
                addr = NetworkUtils.strToIPv6(hostAddress);
            }
            return InetAddress.getByAddress(hostAddress, addr);
        }
        return InetAddress.getByName(hostAddress);
    }

    public static InetSocketAddress[] getAandAAAARecords(String domain, int port) throws ParseException, DnssecException {
        byte[] address = null;
        address = NetworkUtils.strToIPv4(domain);
        if (address != null || (address = NetworkUtils.strToIPv6(domain)) != null) {
            try {
                return new InetSocketAddress[]{new InetSocketAddress(InetAddress.getByAddress(domain, address), port)};
            }
            catch (UnknownHostException e) {
                logger.error("Unable to create InetAddress for <" + domain + ">", e);
                return null;
            }
        }
        LinkedList<InetSocketAddress> addresses = new LinkedList<InetSocketAddress>();
        boolean v6lookup = Boolean.getBoolean("java.net.preferIPv6Addresses");
        int i = 0;
        while (i < 2) {
            Lookup lookup2;
            try {
                lookup2 = NetworkUtils.createLookup(domain, v6lookup ? 28 : 1);
            }
            catch (TextParseException tpe) {
                logger.error("Failed to parse domain <" + domain + ">", tpe);
                throw new ParseException(tpe.getMessage(), 0);
            }
            Record[] records = null;
            try {
                records = lookup2.run();
            }
            catch (DnssecRuntimeException e) {
                throw new DnssecException(e);
            }
            if (records != null) {
                Record[] recordArray = records;
                int n = records.length;
                int n2 = 0;
                while (n2 < n) {
                    Record r = recordArray[n2];
                    try {
                        addresses.add(new InetSocketAddress(InetAddress.getByAddress(domain, v6lookup ? ((AAAARecord)r).getAddress().getAddress() : ((ARecord)r).getAddress().getAddress()), port));
                    }
                    catch (UnknownHostException e) {
                        logger.error("Invalid record returned from DNS", e);
                    }
                    ++n2;
                }
            }
            v6lookup = !v6lookup;
            ++i;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("A or AAAA addresses: " + addresses);
        }
        return addresses.toArray(new InetSocketAddress[0]);
    }

    public static InetSocketAddress getARecord(String domain, int port) throws ParseException, DnssecException {
        Record[] records;
        byte[] address = NetworkUtils.strToIPv4(domain);
        if (address != null) {
            try {
                return new InetSocketAddress(InetAddress.getByAddress(domain, address), port);
            }
            catch (UnknownHostException e) {
                logger.error("Unable to create InetAddress for <" + domain + ">", e);
                return null;
            }
        }
        try {
            Lookup lookup2 = NetworkUtils.createLookup(domain, 1);
            records = lookup2.run();
        }
        catch (TextParseException tpe) {
            logger.error("Failed to parse domain=" + domain, tpe);
            throw new ParseException(tpe.getMessage(), 0);
        }
        catch (DnssecRuntimeException e) {
            throw new DnssecException(e);
        }
        if (records != null && records.length > 0) {
            if (logger.isTraceEnabled()) {
                logger.trace("A record for " + domain + "=" + ((ARecord)records[0]).getAddress());
            }
            try {
                return new InetSocketAddress(InetAddress.getByAddress(domain, ((ARecord)records[0]).getAddress().getAddress()), port);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("No A record found for " + domain);
        }
        return null;
    }

    public static InetSocketAddress getAAAARecord(String domain, int port) throws ParseException, DnssecException {
        Record[] records;
        byte[] address = NetworkUtils.strToIPv6(domain);
        if (address != null) {
            try {
                return new InetSocketAddress(InetAddress.getByAddress(domain, address), port);
            }
            catch (UnknownHostException e) {
                logger.error("Unable to create InetAddress for <" + domain + ">", e);
                return null;
            }
        }
        try {
            Lookup lookup2 = NetworkUtils.createLookup(domain, 28);
            records = lookup2.run();
        }
        catch (TextParseException tpe) {
            logger.error("Failed to parse domain=" + domain, tpe);
            throw new ParseException(tpe.getMessage(), 0);
        }
        catch (DnssecRuntimeException e) {
            throw new DnssecException(e);
        }
        if (records != null && records.length > 0) {
            if (logger.isTraceEnabled()) {
                logger.trace("AAAA record for " + domain + "=" + ((AAAARecord)records[0]).getAddress());
            }
            try {
                return new InetSocketAddress(InetAddress.getByAddress(domain, ((AAAARecord)records[0]).getAddress().getAddress()), port);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("No AAAA record found for " + domain);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static String determineAnyAddress() {
        try {
            ifaces = NetworkInterface.getNetworkInterfaces();
            if (true) ** GOTO lbl13
        }
        catch (SocketException e) {
            if (NetworkUtils.logger.isDebugEnabled()) {
                NetworkUtils.logger.debug("Couldn't retrieve local interfaces.", e);
            }
            return "0.0.0.0";
        }
        do {
            addrs = ifaces.nextElement().getInetAddresses();
            while (addrs.hasMoreElements()) {
                if (!(addrs.nextElement() instanceof Inet6Address)) continue;
                return "::0";
            }
lbl13:
            // 2 sources

        } while (ifaces.hasMoreElements());
        return "0.0.0.0";
    }

    public static boolean isValidPortNumber(int port) {
        return 1024 < port && port < 65535;
    }

    public static byte[] mappedIPv4ToRealIPv4(byte[] addr) {
        if (NetworkUtils.isMappedIPv4Addr(addr)) {
            byte[] newAddr = new byte[4];
            System.arraycopy(addr, 12, newAddr, 0, 16);
            return newAddr;
        }
        return null;
    }

    private static boolean isMappedIPv4Addr(byte[] address) {
        if (address.length < 16) {
            return false;
        }
        return address[0] == 0 && address[1] == 0 && address[2] == 0 && address[3] == 0 && address[4] == 0 && address[5] == 0 && address[6] == 0 && address[7] == 0 && address[8] == 0 && address[9] == 0 && address[10] == -1 && address[11] == -1;
    }

    private static Lookup createLookup(String domain, int type) throws TextParseException {
        if (UtilActivator.getConfigurationService().getBoolean(PNAME_DNS_ALWAYS_ABSOLUTE, false) && !Name.fromString(domain).isAbsolute()) {
            domain = String.valueOf(domain) + ".";
        }
        Lookup lookup2 = new Lookup(domain, type);
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Active DNS servers in default resolver: ");
            String[] stringArray = ResolverConfig.getCurrentConfig().servers();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                sb.append(s);
                sb.append(", ");
                ++n2;
            }
            logger.trace(sb.toString());
        }
        return lookup2;
    }

    public static int compareDnsNames(String dns1, String dns2) throws ParseException {
        try {
            return Name.fromString(dns1).compareTo(Name.fromString(dns2));
        }
        catch (TextParseException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static void sortSrvRecord(SRVRecord[] srvRecords) {
        Arrays.sort(srvRecords, new Comparator<SRVRecord>(){

            @Override
            public int compare(SRVRecord obj1, SRVRecord obj2) {
                return obj1.getPriority() - obj2.getPriority();
            }
        });
        NetworkUtils.sortSrvRecordByWeight(srvRecords);
    }

    private static void sortSrvRecordByWeight(SRVRecord[] srvRecords) {
        int currentPriority = srvRecords[0].getPriority();
        int startIndex = 0;
        int i = 0;
        while (i < srvRecords.length) {
            if (currentPriority != srvRecords[i].getPriority()) {
                NetworkUtils.sortSrvRecordPriorityByWeight(srvRecords, startIndex, i);
                startIndex = i;
                currentPriority = srvRecords[i].getPriority();
            }
            ++i;
        }
    }

    private static void sortSrvRecordPriorityByWeight(SRVRecord[] srvRecords, int startIndex, int endIndex) {
        while (startIndex < endIndex) {
            int randomWeight = NetworkUtils.getRandomWeight(srvRecords, startIndex, endIndex);
            NetworkUtils.moveSelectedSRVRecord(srvRecords, startIndex, endIndex, randomWeight);
            ++startIndex;
        }
    }

    private static int getRandomWeight(SRVRecord[] srvRecords, int startIndex, int endIndex) {
        int totalPriorityWeight = 0;
        int i = startIndex;
        while (i < endIndex) {
            totalPriorityWeight += srvRecords[i].getWeight();
            ++i;
        }
        return random.nextInt(totalPriorityWeight + 1);
    }

    private static void moveSelectedSRVRecord(SRVRecord[] srvRecords, int startIndex, int endIndex, int selectedWeight) {
        int totalPriorityWeight = 0;
        int i = startIndex;
        while (i < endIndex) {
            if ((totalPriorityWeight += srvRecords[i].getWeight()) >= selectedWeight) {
                SRVRecord tmpSrvRecord = srvRecords[startIndex];
                srvRecords[startIndex] = srvRecords[i];
                srvRecords[i] = tmpSrvRecord;
                return;
            }
            ++i;
        }
    }

    public static void clearDefaultDNSCache() {
        Cache defaultCache = Lookup.getDefaultCache(1);
        defaultCache.clearCache();
    }
}

