/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ElementKind;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.path.MessageAndPath;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConstraintValidatorContextImpl
implements ConstraintValidatorContext {
    private static final Log log = LoggerFactory.make();
    private final List<String> parameterNameProvider;
    private final List<MessageAndPath> messageAndPaths = CollectionHelper.newArrayList(3);
    private final PathImpl basePath;
    private final ConstraintDescriptor<?> constraintDescriptor;
    private boolean defaultDisabled;

    public ConstraintValidatorContextImpl(List<String> parameterNames, PathImpl propertyPath, ConstraintDescriptor<?> constraintDescriptor) {
        this.parameterNameProvider = parameterNames;
        this.basePath = propertyPath;
        this.constraintDescriptor = constraintDescriptor;
    }

    public final void disableDefaultConstraintViolation() {
        this.defaultDisabled = true;
    }

    public final String getDefaultConstraintMessageTemplate() {
        return (String)this.constraintDescriptor.getAttributes().get("message");
    }

    public final ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String messageTemplate) {
        return new ConstraintViolationBuilderImpl(this.parameterNameProvider, messageTemplate, PathImpl.createCopy(this.basePath));
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(ConstraintValidatorContext.class)) {
            return type.cast(this);
        }
        throw log.getTypeNotSupportedForUnwrappingException(type);
    }

    public final ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraintDescriptor;
    }

    public final List<MessageAndPath> getMessageAndPathList() {
        if (this.defaultDisabled && this.messageAndPaths.size() == 0) {
            throw log.getAtLeastOneCustomMessageMustBeCreatedException();
        }
        ArrayList<MessageAndPath> returnedMessageAndPaths = new ArrayList<MessageAndPath>(this.messageAndPaths);
        if (!this.defaultDisabled) {
            returnedMessageAndPaths.add(new MessageAndPath(this.getDefaultConstraintMessageTemplate(), this.basePath));
        }
        return returnedMessageAndPaths;
    }

    private class DeferredNodeBuilder
    extends NodeBuilderBase
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext,
    ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext,
    ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder,
    ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeContextBuilder {
        private final String leafNodeName;

        private DeferredNodeBuilder(String template, PathImpl path, String nodeName) {
            super(template, path);
            this.leafNodeName = nodeName;
        }

        public DeferredNodeBuilder inIterable() {
            this.propertyPath.makeLeafNodeIterable();
            return this;
        }

        public NodeBuilder atKey(Object key) {
            this.propertyPath.setLeafNodeMapKey(key);
            this.addLeafNode();
            return new NodeBuilder(this.messageTemplate, this.propertyPath);
        }

        public NodeBuilder atIndex(Integer index) {
            this.propertyPath.setLeafNodeIndex(index);
            this.addLeafNode();
            return new NodeBuilder(this.messageTemplate, this.propertyPath);
        }

        @Deprecated
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            return this.addPropertyNode(name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            this.addLeafNode();
            return new DeferredNodeBuilder(this.messageTemplate, this.propertyPath, name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            this.addLeafNode();
            return new DeferredNodeBuilder(this.messageTemplate, this.propertyPath, null);
        }

        @Override
        public ConstraintValidatorContext addConstraintViolation() {
            this.addLeafNode();
            return super.addConstraintViolation();
        }

        private void addLeafNode() {
            if (this.leafNodeName == null) {
                this.propertyPath.addBeanNode();
            } else {
                this.propertyPath.addPropertyNode(this.leafNodeName);
            }
        }
    }

    private class NodeBuilder
    extends NodeBuilderBase
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext,
    ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderDefinedContext {
        private NodeBuilder(String template, PathImpl path) {
            super(template, path);
        }

        @Deprecated
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            return this.addPropertyNode(name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            return new DeferredNodeBuilder(this.messageTemplate, this.propertyPath, name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            return new DeferredNodeBuilder(this.messageTemplate, this.propertyPath, null);
        }
    }

    private class ConstraintViolationBuilderImpl
    extends NodeBuilderBase
    implements ConstraintValidatorContext.ConstraintViolationBuilder {
        private final List<String> parameterNames;

        private ConstraintViolationBuilderImpl(List<String> parameterNames, String template, PathImpl path) {
            super(template, path);
            this.parameterNames = parameterNames;
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addNode(String name) {
            this.dropLeafNodeIfRequired();
            this.propertyPath.addPropertyNode(name);
            return new NodeBuilder(this.messageTemplate, this.propertyPath);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(String name) {
            this.dropLeafNodeIfRequired();
            return new DeferredNodeBuilder(this.messageTemplate, this.propertyPath, name);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext addBeanNode() {
            return new DeferredNodeBuilder(this.messageTemplate, this.propertyPath, null);
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addParameterNode(int index) {
            if (this.propertyPath.getLeafNode().getKind() != ElementKind.CROSS_PARAMETER) {
                throw log.getParameterNodeAddedForNonCrossParameterConstraintException(this.propertyPath);
            }
            this.dropLeafNodeIfRequired();
            this.propertyPath.addParameterNode(this.parameterNames.get(index), index);
            return new NodeBuilder(this.messageTemplate, this.propertyPath);
        }

        private void dropLeafNodeIfRequired() {
            if (this.propertyPath.getLeafNode().getKind() == ElementKind.BEAN || this.propertyPath.getLeafNode().getKind() == ElementKind.CROSS_PARAMETER) {
                this.propertyPath = this.propertyPath.getPathWithoutLeafNode();
            }
        }
    }

    private abstract class NodeBuilderBase {
        protected final String messageTemplate;
        protected PathImpl propertyPath;

        protected NodeBuilderBase(String template, PathImpl path) {
            this.messageTemplate = template;
            this.propertyPath = path;
        }

        public ConstraintValidatorContext addConstraintViolation() {
            ConstraintValidatorContextImpl.this.messageAndPaths.add(new MessageAndPath(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }
    }
}

