/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.java.sip.communicator.util.UtilActivator;

public class GuiUtils {
    private static final Calendar c1 = Calendar.getInstance();
    private static final Calendar c2 = Calendar.getInstance();
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    private static final Map<Character, Character> DIGIT_MAPPINGS;
    private static final String[][] ESCAPE_SEQUENCES;

    static {
        ESCAPE_SEQUENCES = new String[][]{{"&", "&_amp"}, {"/", "&_sl"}, {"\\\\", "&_bs"}, {":", "&_co"}, {"\\*", "&_as"}, {"\\?", "&_qm"}, {"\"", "&_pa"}, {"<", "&_lt"}, {">", "&_gt"}, {"\\|", "&_pp"}};
        HashMap<Character, Character> digitMap = new HashMap<Character, Character>(50);
        digitMap.put(Character.valueOf('0'), Character.valueOf('0'));
        digitMap.put(Character.valueOf('\uff10'), Character.valueOf('0'));
        digitMap.put(Character.valueOf('\u0660'), Character.valueOf('0'));
        digitMap.put(Character.valueOf('1'), Character.valueOf('1'));
        digitMap.put(Character.valueOf('\uff11'), Character.valueOf('1'));
        digitMap.put(Character.valueOf('\u0661'), Character.valueOf('1'));
        digitMap.put(Character.valueOf('2'), Character.valueOf('2'));
        digitMap.put(Character.valueOf('\uff12'), Character.valueOf('2'));
        digitMap.put(Character.valueOf('\u0662'), Character.valueOf('2'));
        digitMap.put(Character.valueOf('3'), Character.valueOf('3'));
        digitMap.put(Character.valueOf('\uff13'), Character.valueOf('3'));
        digitMap.put(Character.valueOf('\u0663'), Character.valueOf('3'));
        digitMap.put(Character.valueOf('4'), Character.valueOf('4'));
        digitMap.put(Character.valueOf('\uff14'), Character.valueOf('4'));
        digitMap.put(Character.valueOf('\u0664'), Character.valueOf('4'));
        digitMap.put(Character.valueOf('5'), Character.valueOf('5'));
        digitMap.put(Character.valueOf('\uff15'), Character.valueOf('5'));
        digitMap.put(Character.valueOf('\u0665'), Character.valueOf('5'));
        digitMap.put(Character.valueOf('6'), Character.valueOf('6'));
        digitMap.put(Character.valueOf('\uff16'), Character.valueOf('6'));
        digitMap.put(Character.valueOf('\u0666'), Character.valueOf('6'));
        digitMap.put(Character.valueOf('7'), Character.valueOf('7'));
        digitMap.put(Character.valueOf('\uff17'), Character.valueOf('7'));
        digitMap.put(Character.valueOf('\u0667'), Character.valueOf('7'));
        digitMap.put(Character.valueOf('8'), Character.valueOf('8'));
        digitMap.put(Character.valueOf('\uff18'), Character.valueOf('8'));
        digitMap.put(Character.valueOf('\u0668'), Character.valueOf('8'));
        digitMap.put(Character.valueOf('9'), Character.valueOf('9'));
        digitMap.put(Character.valueOf('\uff19'), Character.valueOf('9'));
        digitMap.put(Character.valueOf('\u0669'), Character.valueOf('9'));
        DIGIT_MAPPINGS = Collections.unmodifiableMap(digitMap);
    }

    public static String replaceSpecialRegExpChars(String text) {
        return text.replaceAll("([.()^&$*|])", "\\\\$1");
    }

    public static int countOccurrences(String text, char needle) {
        int count = 0;
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == needle) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public static int compareDates(Date date1, Date date2) {
        return date1.compareTo(date2);
    }

    public static int compareDates(long date1, long date2) {
        return date1 < date2 ? -1 : (date1 == date2 ? 0 : 1);
    }

    public static int compareDatesOnly(long date1, long date2) {
        c1.setTimeInMillis(date1);
        c2.setTimeInMillis(date2);
        int day1 = c1.get(5);
        int month1 = c1.get(2);
        int year1 = c1.get(1);
        int day2 = c2.get(5);
        int month2 = c2.get(2);
        int year2 = c2.get(1);
        if (year1 < year2) {
            return -1;
        }
        if (year1 == year2) {
            if (month1 < month2) {
                return -1;
            }
            if (month1 == month2) {
                if (day1 < day2) {
                    return -1;
                }
                if (day1 == day2) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
        return 1;
    }

    public static int compareDatesOnly(Date date1, Date date2) {
        return GuiUtils.compareDatesOnly(date1.getTime(), date2.getTime());
    }

    public static String formatDate(Date date) {
        return GuiUtils.formatDate(date.getTime());
    }

    public static String formatDate(long date) {
        StringBuffer strBuf = new StringBuffer();
        GuiUtils.formatDate(date, strBuf);
        return strBuf.toString();
    }

    public static void formatDate(long date, StringBuffer dateStrBuf) {
        c1.setTimeInMillis(date);
        dateStrBuf.append(GuiUtils.processMonth(c1.get(2)));
        dateStrBuf.append(' ');
        GuiUtils.formatTime(c1.get(5), dateStrBuf);
        dateStrBuf.append(", ");
        GuiUtils.formatTime(c1.get(1), dateStrBuf);
    }

    public static void formatDate(Date date, StringBuffer dateStrBuf) {
        c1.setTime(date);
        dateStrBuf.append(GuiUtils.processMonth(c1.get(2)));
        dateStrBuf.append(' ');
        GuiUtils.formatTime(c1.get(5), dateStrBuf);
        dateStrBuf.append(", ");
        GuiUtils.formatTime(c1.get(1), dateStrBuf);
    }

    public static String formatTime(Date date) {
        return GuiUtils.formatTime(date.getTime());
    }

    public static String formatTime(long time) {
        c1.setTimeInMillis(time);
        StringBuffer timeStrBuf = new StringBuffer();
        GuiUtils.formatTime(c1.get(11), timeStrBuf);
        timeStrBuf.append(':');
        GuiUtils.formatTime(c1.get(12), timeStrBuf);
        timeStrBuf.append(':');
        GuiUtils.formatTime(c1.get(13), timeStrBuf);
        return timeStrBuf.toString();
    }

    public static String formatTime(Date startDate, Date endDate) {
        return GuiUtils.formatTime(startDate.getTime(), endDate.getTime());
    }

    public static String formatTime(long start, long end) {
        long duration = end - start;
        long milPerSec = 1000L;
        long milPerMin = milPerSec * 60L;
        long milPerHour = milPerMin * 60L;
        long hours = duration / milPerHour;
        long minutes = (duration - hours * milPerHour) / milPerMin;
        long seconds = (duration - hours * milPerHour - minutes * milPerMin) / milPerSec;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private static String processMonth(int month) {
        String monthStringKey;
        switch (month) {
            case 0: {
                monthStringKey = "service.gui.JANUARY";
                break;
            }
            case 1: {
                monthStringKey = "service.gui.FEBRUARY";
                break;
            }
            case 2: {
                monthStringKey = "service.gui.MARCH";
                break;
            }
            case 3: {
                monthStringKey = "service.gui.APRIL";
                break;
            }
            case 4: {
                monthStringKey = "service.gui.MAY";
                break;
            }
            case 5: {
                monthStringKey = "service.gui.JUNE";
                break;
            }
            case 6: {
                monthStringKey = "service.gui.JULY";
                break;
            }
            case 7: {
                monthStringKey = "service.gui.AUGUST";
                break;
            }
            case 8: {
                monthStringKey = "service.gui.SEPTEMBER";
                break;
            }
            case 9: {
                monthStringKey = "service.gui.OCTOBER";
                break;
            }
            case 10: {
                monthStringKey = "service.gui.NOVEMBER";
                break;
            }
            case 11: {
                monthStringKey = "service.gui.DECEMBER";
                break;
            }
            default: {
                return "";
            }
        }
        return UtilActivator.getResources().getI18NString(monthStringKey);
    }

    private static void formatTime(int time, StringBuffer timeStrBuf) {
        String timeString = Integer.toString(time);
        if (timeString.length() < 2) {
            timeStrBuf.append('0');
        }
        timeStrBuf.append(timeString);
    }

    public static String formatSeconds(long millis) {
        long[] values = new long[]{millis / 86400000L, millis / 3600000L % 24L, millis / 60000L % 60L, millis / 1000L % 60L};
        String[] fields = new String[]{" d ", " h ", " min ", " sec"};
        StringBuffer buf = new StringBuffer(64);
        boolean valueOutput = false;
        int i = 0;
        while (i < 4) {
            long value = values[i];
            if (value == 0L) {
                if (valueOutput) {
                    buf.append('0').append(fields[i]);
                }
            } else {
                valueOutput = true;
                buf.append(value).append(fields[i]);
            }
            ++i;
        }
        return buf.toString().trim();
    }

    public static String escapeFileNameSpecialCharacters(String string) {
        String resultId = string;
        int j = 0;
        while (j < ESCAPE_SEQUENCES.length) {
            resultId = resultId.replaceAll(ESCAPE_SEQUENCES[j][0], ESCAPE_SEQUENCES[j][1]);
            ++j;
        }
        return resultId;
    }

    public static String escapeHTMLChars(String message) {
        return message.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;").replace("/", "&#x2F;");
    }
}

