/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import net.java.sip.communicator.service.protocol.media.ProtocolMediaActivator;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;

public class SrtpControls {
    private static final SrtpControlType[] SORTED_SRTP_CONTROL_TYPES = new SrtpControlType[]{SrtpControlType.ZRTP, SrtpControlType.DTLS_SRTP, SrtpControlType.MIKEY, SrtpControlType.SDES};
    private final SrtpControl[][] elements = new SrtpControl[MediaType.values().length][SrtpControlType.values().length];

    public SrtpControl findFirst(MediaType mediaType) {
        SrtpControl element = null;
        SrtpControlType[] srtpControlTypeArray = SORTED_SRTP_CONTROL_TYPES;
        int n = SORTED_SRTP_CONTROL_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            SrtpControlType srtpControlType = srtpControlTypeArray[n2];
            element = this.get(mediaType, srtpControlType);
            if (element != null) break;
            ++n2;
        }
        return element;
    }

    public SrtpControl get(MediaType mediaType, SrtpControlType srtpControlType) {
        return this.elements[mediaType.ordinal()][srtpControlType.ordinal()];
    }

    public SrtpControl getOrCreate(MediaType mediaType, SrtpControlType srtpControlType) {
        int index;
        SrtpControl[] elements = this.elements[mediaType.ordinal()];
        SrtpControl element = elements[index = srtpControlType.ordinal()];
        if (element == null && (element = ProtocolMediaActivator.getMediaService().createSrtpControl(srtpControlType)) != null) {
            elements[index] = element;
        }
        return element;
    }

    public SrtpControl remove(MediaType mediaType, SrtpControlType srtpControlType) {
        SrtpControl[] elements = this.elements[mediaType.ordinal()];
        int index = srtpControlType.ordinal();
        SrtpControl element = elements[index];
        elements[index] = null;
        return element;
    }

    public void set(MediaType mediaType, SrtpControl element) {
        SrtpControlType srtpControlType = element.getSrtpControlType();
        this.elements[mediaType.ordinal()][srtpControlType.ordinal()] = element;
    }
}

