/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.xml.XMLException;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConferenceInfoDocument {
    private static final Logger logger = Logger.getLogger(ConferenceInfoDocument.class);
    public static final String NAMESPACE = "urn:ietf:params:xml:ns:conference-info";
    public static final String CONFERENCE_INFO_ELEMENT_NAME = "conference-info";
    public static final String CONFERENCE_DESCRIPTION_ELEMENT_NAME = "conference-description";
    public static final String CONFERENCE_STATE_ELEMENT_NAME = "conference-state";
    public static final String STATE_ATTR_NAME = "state";
    public static final String ENTITY_ATTR_NAME = "entity";
    public static final String VERSION_ATTR_NAME = "version";
    public static final String USER_ELEMENT_NAME = "user";
    public static final String USERS_ELEMENT_NAME = "users";
    public static final String ENDPOINT_ELEMENT_NAME = "endpoint";
    public static final String MEDIA_ELEMENT_NAME = "media";
    public static final String ID_ATTR_NAME = "id";
    public static final String STATUS_ELEMENT_NAME = "status";
    public static final String SRC_ID_ELEMENT_NAME = "src-id";
    public static final String TYPE_ELEMENT_NAME = "type";
    public static final String USER_COUNT_ELEMENT_NAME = "user-count";
    public static final String DISPLAY_TEXT_ELEMENT_NAME = "display-text";
    private Document document;
    private Element conferenceInfo;
    private Element conferenceDescription;
    private Element conferenceState;
    private Element userCount;
    private Element users;
    private final List<User> usersList = new LinkedList<User>();

    public ConferenceInfoDocument() throws XMLException {
        try {
            this.document = XMLUtils.createDocument();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create a new document.", (Throwable)e);
            throw new XMLException(e.getMessage());
        }
        this.conferenceInfo = this.document.createElementNS(NAMESPACE, CONFERENCE_INFO_ELEMENT_NAME);
        this.document.appendChild(this.conferenceInfo);
        this.setVersion(1);
        this.conferenceDescription = this.document.createElement(CONFERENCE_DESCRIPTION_ELEMENT_NAME);
        this.conferenceInfo.appendChild(this.conferenceDescription);
        this.conferenceState = this.document.createElement(CONFERENCE_STATE_ELEMENT_NAME);
        this.conferenceInfo.appendChild(this.conferenceState);
        this.setUserCount(0);
        this.users = this.document.createElement(USERS_ELEMENT_NAME);
        this.conferenceInfo.appendChild(this.users);
    }

    public ConferenceInfoDocument(String xml) throws XMLException {
        byte[] bytes;
        try {
            bytes = xml.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            logger.warn((Object)"Failed to gets bytes from String for the UTF-8 charset", (Throwable)uee);
            bytes = xml.getBytes();
        }
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(bytes));
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage());
        }
        this.conferenceInfo = this.document.getDocumentElement();
        if (this.conferenceInfo == null) {
            throw new XMLException("Could not parse conference-info document, conference-info element not found");
        }
        this.conferenceDescription = XMLUtils.findChild((Element)this.conferenceInfo, (String)CONFERENCE_DESCRIPTION_ELEMENT_NAME);
        if (this.conferenceDescription == null) {
            throw new XMLException("Could not parse conference-info document, conference-description element not found");
        }
        this.conferenceState = XMLUtils.findChild((Element)this.conferenceInfo, (String)CONFERENCE_STATE_ELEMENT_NAME);
        if (this.conferenceState != null) {
            this.userCount = XMLUtils.findChild((Element)this.conferenceState, (String)USER_COUNT_ELEMENT_NAME);
        }
        this.users = XMLUtils.findChild((Element)this.conferenceInfo, (String)USERS_ELEMENT_NAME);
        if (this.users == null) {
            throw new XMLException("Could not parse conference-info document, 'users' element not found");
        }
        NodeList usersNodeList = this.users.getElementsByTagName(USER_ELEMENT_NAME);
        int i = 0;
        while (i < usersNodeList.getLength()) {
            User user = new User((Element)usersNodeList.item(i));
            this.usersList.add(user);
            ++i;
        }
    }

    public ConferenceInfoDocument(ConferenceInfoDocument confInfo) throws XMLException {
        this();
        String sid = confInfo.getSid();
        if (sid != null && !sid.equals("")) {
            this.setSid(sid);
        }
        this.setEntity(confInfo.getEntity());
        this.setState(confInfo.getState());
        this.setUserCount(confInfo.getUserCount());
        this.setUsersState(confInfo.getUsersState());
        this.setVersion(confInfo.getVersion());
        for (User user : confInfo.getUsers()) {
            this.addUser(user);
        }
    }

    public int getVersion() {
        int version;
        block3: {
            String versionString = this.conferenceInfo.getAttribute(VERSION_ATTR_NAME);
            if (versionString == null) {
                return -1;
            }
            version = -1;
            try {
                version = Integer.parseInt(versionString);
            }
            catch (NumberFormatException e) {
                if (!logger.isInfoEnabled()) break block3;
                logger.info((Object)("Failed to parse version string: " + versionString));
            }
        }
        return version;
    }

    public void setVersion(int version) {
        this.conferenceInfo.setAttribute(VERSION_ATTR_NAME, Integer.toString(version));
    }

    public State getState() {
        return this.getState(this.conferenceInfo);
    }

    public State getUsersState() {
        return this.getState(this.users);
    }

    public void setUsersState(State state) {
        this.setState(this.users, state);
    }

    public void setState(State state) {
        this.setState(this.conferenceInfo, state);
    }

    public void setSid(String sid) {
        if (sid == null || sid.equals("")) {
            this.conferenceInfo.removeAttribute("sid");
        } else {
            this.conferenceInfo.setAttribute("sid", sid);
        }
    }

    public String getSid() {
        return this.conferenceInfo.getAttribute("sid");
    }

    public void setEntity(String entity) {
        if (entity == null || entity.equals("")) {
            this.conferenceInfo.removeAttribute(ENTITY_ATTR_NAME);
        } else {
            this.conferenceInfo.setAttribute(ENTITY_ATTR_NAME, entity);
        }
    }

    public String getEntity() {
        return this.conferenceInfo.getAttribute(ENTITY_ATTR_NAME);
    }

    public void setUserCount(int count) {
        if (this.userCount != null) {
            this.userCount.setTextContent(Integer.toString(count));
        } else {
            if (this.conferenceState == null) {
                this.conferenceState = this.document.createElement(CONFERENCE_STATE_ELEMENT_NAME);
                this.conferenceInfo.appendChild(this.conferenceState);
            }
            this.userCount = this.document.createElement(USER_COUNT_ELEMENT_NAME);
            this.userCount.setTextContent(Integer.toString(count));
            this.conferenceState.appendChild(this.userCount);
        }
    }

    public int getUserCount() {
        int ret = -1;
        try {
            ret = Integer.parseInt(this.userCount.getTextContent());
        }
        catch (Exception e) {
            logger.warn((Object)"Could not parse user-count field");
        }
        return ret;
    }

    public String toXml() {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter buffer = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(this.conferenceInfo), new StreamResult(buffer));
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        String s = this.toXml();
        return s == null ? "Could not get conference-info XML" : s;
    }

    public List<User> getUsers() {
        return this.usersList;
    }

    public User getUser(String entity) {
        if (entity == null) {
            return null;
        }
        for (User u : this.usersList) {
            if (!entity.equals(u.getEntity())) continue;
            return u;
        }
        return null;
    }

    public User addNewUser(String entity) {
        Element userElement = this.document.createElement(USER_ELEMENT_NAME);
        User user = new User(userElement);
        user.setEntity(entity);
        this.users.appendChild(userElement);
        this.usersList.add(user);
        return user;
    }

    public void addUser(User user) {
        User newUser = this.addNewUser(user.getEntity());
        newUser.setDisplayText(user.getDisplayText());
        newUser.setState(user.getState());
        for (Endpoint endpoint : user.getEndpoints()) {
            newUser.addEndpoint(endpoint);
        }
    }

    public void removeUser(String entity) {
        User user = this.getUser(entity);
        if (user != null) {
            this.usersList.remove(user);
            this.users.removeChild(user.userElement);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    private State getState(Element element) {
        State state = State.parseString(element.getAttribute(STATE_ATTR_NAME));
        return state == null ? State.FULL : state;
    }

    private void setState(Element element, State state) {
        if (element != null) {
            if (state == State.FULL || state == null) {
                element.removeAttribute(STATE_ATTR_NAME);
            } else {
                element.setAttribute(STATE_ATTR_NAME, state.toString());
            }
        }
    }

    private void setStatus(Element element, String statusString) {
        Element statusElement = XMLUtils.findChild((Element)element, (String)STATUS_ELEMENT_NAME);
        if (statusString == null || statusString.equals("")) {
            if (statusElement != null) {
                element.removeChild(statusElement);
            }
        } else {
            if (statusElement == null) {
                statusElement = this.document.createElement(STATUS_ELEMENT_NAME);
                element.appendChild(statusElement);
            }
            statusElement.setTextContent(statusString);
        }
    }

    public class Endpoint {
        private Element endpointElement;
        private List<Media> mediasList = new LinkedList<Media>();

        private Endpoint(Element endpoint) {
            this.endpointElement = endpoint;
            NodeList mediaNodeList = endpoint.getElementsByTagName(ConferenceInfoDocument.MEDIA_ELEMENT_NAME);
            int i = 0;
            while (i < mediaNodeList.getLength()) {
                Media media = new Media((Element)mediaNodeList.item(i));
                this.mediasList.add(media);
                ++i;
            }
        }

        public void setEntity(String entity) {
            if (entity == null || entity.equals("")) {
                this.endpointElement.removeAttribute(ConferenceInfoDocument.ENTITY_ATTR_NAME);
            } else {
                this.endpointElement.setAttribute(ConferenceInfoDocument.ENTITY_ATTR_NAME, entity);
            }
        }

        public String getEntity() {
            return this.endpointElement.getAttribute(ConferenceInfoDocument.ENTITY_ATTR_NAME);
        }

        public void setState(State state) {
            ConferenceInfoDocument.this.setState(this.endpointElement, state);
        }

        public State getState() {
            return ConferenceInfoDocument.this.getState(this.endpointElement);
        }

        public void setStatus(EndpointStatusType status) {
            ConferenceInfoDocument.this.setStatus(this.endpointElement, status == null ? null : status.toString());
        }

        public EndpointStatusType getStatus() {
            Element statusElement = XMLUtils.findChild((Element)this.endpointElement, (String)ConferenceInfoDocument.STATUS_ELEMENT_NAME);
            return statusElement == null ? null : EndpointStatusType.parseString(statusElement.getTextContent());
        }

        public List<Media> getMedias() {
            return this.mediasList;
        }

        public Media getMedia(String id) {
            if (id == null) {
                return null;
            }
            for (Media m : this.mediasList) {
                if (!id.equals(m.getId())) continue;
                return m;
            }
            return null;
        }

        public Media addNewMedia(String id) {
            Element mediaElement = ConferenceInfoDocument.this.document.createElement(ConferenceInfoDocument.MEDIA_ELEMENT_NAME);
            Media media = new Media(mediaElement);
            media.setId(id);
            this.endpointElement.appendChild(mediaElement);
            this.mediasList.add(media);
            return media;
        }

        public void addMedia(Media media) {
            Media newMedia = this.addNewMedia(media.getId());
            newMedia.setSrcId(media.getSrcId());
            newMedia.setType(media.getType());
            newMedia.setStatus(media.getStatus());
        }

        public void removeMedia(String id) {
            Media media = this.getMedia(id);
            if (media != null) {
                this.mediasList.remove(media);
                this.endpointElement.removeChild(media.mediaElement);
            }
        }
    }

    public static enum EndpointStatusType {
        pending("pending"),
        dialing_out("dialing-out"),
        dialing_in("dialing-in"),
        alerting("alerting"),
        on_hold("on-hold"),
        connected("connected"),
        muted_via_focus("mute-via-focus"),
        disconnecting("disconnecting"),
        disconnected("disconnected");

        private final String type;

        private EndpointStatusType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static EndpointStatusType parseString(String typeStr) throws IllegalArgumentException {
            EndpointStatusType[] endpointStatusTypeArray = EndpointStatusType.values();
            int n = endpointStatusTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EndpointStatusType value = endpointStatusTypeArray[n2];
                if (value.toString().equals(typeStr)) {
                    return value;
                }
                ++n2;
            }
            throw new IllegalArgumentException(String.valueOf(typeStr) + " is not a valid reason");
        }
    }

    public class Media {
        private Element mediaElement;

        private Media(Element media) {
            this.mediaElement = media;
        }

        public void setId(String id) {
            if (id == null || id.equals("")) {
                this.mediaElement.removeAttribute(ConferenceInfoDocument.ID_ATTR_NAME);
            } else {
                this.mediaElement.setAttribute(ConferenceInfoDocument.ID_ATTR_NAME, id);
            }
        }

        public String getId() {
            return this.mediaElement.getAttribute(ConferenceInfoDocument.ID_ATTR_NAME);
        }

        public void setSrcId(String srcId) {
            Element srcIdElement = XMLUtils.findChild((Element)this.mediaElement, (String)ConferenceInfoDocument.SRC_ID_ELEMENT_NAME);
            if (srcId == null || srcId.equals("")) {
                if (srcIdElement != null) {
                    this.mediaElement.removeChild(srcIdElement);
                }
            } else {
                if (srcIdElement == null) {
                    srcIdElement = ConferenceInfoDocument.this.document.createElement(ConferenceInfoDocument.SRC_ID_ELEMENT_NAME);
                    this.mediaElement.appendChild(srcIdElement);
                }
                srcIdElement.setTextContent(srcId);
            }
        }

        public String getSrcId() {
            Element srcIdElement = XMLUtils.findChild((Element)this.mediaElement, (String)ConferenceInfoDocument.SRC_ID_ELEMENT_NAME);
            return srcIdElement == null ? null : srcIdElement.getTextContent();
        }

        public void setType(String type) {
            Element typeElement = XMLUtils.findChild((Element)this.mediaElement, (String)ConferenceInfoDocument.TYPE_ELEMENT_NAME);
            if (type == null || type.equals("")) {
                if (typeElement != null) {
                    this.mediaElement.removeChild(typeElement);
                }
            } else {
                if (typeElement == null) {
                    typeElement = ConferenceInfoDocument.this.document.createElement(ConferenceInfoDocument.TYPE_ELEMENT_NAME);
                    this.mediaElement.appendChild(typeElement);
                }
                typeElement.setTextContent(type);
            }
        }

        public String getType() {
            Element typeElement = XMLUtils.findChild((Element)this.mediaElement, (String)ConferenceInfoDocument.TYPE_ELEMENT_NAME);
            return typeElement == null ? null : typeElement.getTextContent();
        }

        public void setStatus(String status) {
            ConferenceInfoDocument.this.setStatus(this.mediaElement, status);
        }

        public String getStatus() {
            Element statusElement = XMLUtils.findChild((Element)this.mediaElement, (String)ConferenceInfoDocument.STATUS_ELEMENT_NAME);
            return statusElement == null ? null : statusElement.getTextContent();
        }
    }

    public static enum State {
        FULL("full"),
        PARTIAL("partial"),
        DELETED("deleted");

        private String name;

        private State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static State parseString(String name) {
            if (FULL.toString().equals(name)) {
                return FULL;
            }
            if (PARTIAL.toString().equals(name)) {
                return PARTIAL;
            }
            if (DELETED.toString().equals(name)) {
                return DELETED;
            }
            return null;
        }
    }

    public class User {
        private Element userElement;
        private List<Endpoint> endpointsList = new LinkedList<Endpoint>();

        private User(Element user) {
            this.userElement = user;
            NodeList endpointsNodeList = user.getElementsByTagName(ConferenceInfoDocument.ENDPOINT_ELEMENT_NAME);
            int i = 0;
            while (i < endpointsNodeList.getLength()) {
                Endpoint endpoint = new Endpoint((Element)endpointsNodeList.item(i));
                this.endpointsList.add(endpoint);
                ++i;
            }
        }

        public void setEntity(String entity) {
            if (entity == null || entity.equals("")) {
                this.userElement.removeAttribute(ConferenceInfoDocument.ENTITY_ATTR_NAME);
            } else {
                this.userElement.setAttribute(ConferenceInfoDocument.ENTITY_ATTR_NAME, entity);
            }
        }

        public String getEntity() {
            return this.userElement.getAttribute(ConferenceInfoDocument.ENTITY_ATTR_NAME);
        }

        public void setState(State state) {
            ConferenceInfoDocument.this.setState(this.userElement, state);
        }

        public State getState() {
            return ConferenceInfoDocument.this.getState(this.userElement);
        }

        public void setDisplayText(String text) {
            Element displayText = XMLUtils.findChild((Element)this.userElement, (String)ConferenceInfoDocument.DISPLAY_TEXT_ELEMENT_NAME);
            if (text == null || text.equals("")) {
                if (displayText != null) {
                    this.userElement.removeChild(displayText);
                }
            } else {
                if (displayText == null) {
                    displayText = ConferenceInfoDocument.this.document.createElement(ConferenceInfoDocument.DISPLAY_TEXT_ELEMENT_NAME);
                    this.userElement.appendChild(displayText);
                }
                displayText.setTextContent(text);
            }
        }

        public String getDisplayText() {
            Element displayText = XMLUtils.findChild((Element)this.userElement, (String)ConferenceInfoDocument.DISPLAY_TEXT_ELEMENT_NAME);
            if (displayText != null) {
                return displayText.getTextContent();
            }
            return null;
        }

        public List<Endpoint> getEndpoints() {
            return this.endpointsList;
        }

        public Endpoint getEndpoint(String entity) {
            if (entity == null) {
                return null;
            }
            for (Endpoint e : this.endpointsList) {
                if (!entity.equals(e.getEntity())) continue;
                return e;
            }
            return null;
        }

        public Endpoint addNewEndpoint(String entity) {
            Element endpointElement = ConferenceInfoDocument.this.document.createElement(ConferenceInfoDocument.ENDPOINT_ELEMENT_NAME);
            Endpoint endpoint = new Endpoint(endpointElement);
            endpoint.setEntity(entity);
            this.userElement.appendChild(endpointElement);
            this.endpointsList.add(endpoint);
            return endpoint;
        }

        public void addEndpoint(Endpoint endpoint) {
            Endpoint newEndpoint = this.addNewEndpoint(endpoint.getEntity());
            newEndpoint.setStatus(endpoint.getStatus());
            newEndpoint.setState(endpoint.getState());
            for (Media media : endpoint.getMedias()) {
                newEndpoint.addMedia(media);
            }
        }

        public void removeEndpoint(String entity) {
            Endpoint endpoint = this.getEndpoint(entity);
            if (endpoint != null) {
                this.endpointsList.remove(endpoint);
                this.userElement.removeChild(endpoint.endpointElement);
            }
        }
    }
}

