/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.control;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Owned;
import javax.media.control.MonitorControl;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.CircularBuffer;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.control.MonitorThread;
import net.sf.fmj.media.util.AudioCodecChain;
import net.sf.fmj.media.util.CodecChain;
import net.sf.fmj.media.util.LoopThread;
import net.sf.fmj.media.util.VideoCodecChain;

public class MonitorAdapter
implements MonitorControl,
Owned {
    protected CodecChain cc = null;
    protected boolean enabled = false;
    protected boolean closed = false;
    protected Component visualComponent = null;
    protected Component controlComponent = null;
    protected Checkbox cbEnabled = null;
    protected Format format = null;
    protected float inFrameRate = 0.0f;
    protected float previewFrameRate = 30.0f;
    protected long lastPreviewTime = 0L;
    protected long previewInterval = 33333333L;
    protected MouseListener ml = null;
    protected PopupMenu rateMenu = null;
    protected LoopThread loopThread;
    protected int[] frameRates = new int[]{0, 1, 2, 5, 7, 10, 15, 20, 30, 60, 90};
    CircularBuffer bufferQ;
    Object owner;
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");

    public MonitorAdapter(Format f, Object owner) {
        this.format = f;
        this.owner = owner;
    }

    private void addPopupMenu(Component visual) {
        MenuItem mi;
        this.visualComponent = visual;
        this.rateMenu = new PopupMenu("Monitor Rate");
        ActionListener rateSelect = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                block2: {
                    String action = ae.getActionCommand();
                    int space = action.indexOf(" ");
                    String rateString = action.substring(0, space);
                    try {
                        int rate = Integer.parseInt(rateString);
                        MonitorAdapter.this.setPreviewFrameRate(rate);
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) break block2;
                        throw (ThreadDeath)t;
                    }
                }
            }
        };
        visual.add(this.rateMenu);
        int lastAdded = 0;
        for (int i = 0; i < this.frameRates.length; ++i) {
            if (!((float)this.frameRates[i] < this.inFrameRate)) continue;
            mi = new MenuItem(this.frameRates[i] + " fps");
            this.rateMenu.add(mi);
            mi.addActionListener(rateSelect);
            lastAdded = this.frameRates[i];
        }
        if ((float)lastAdded < this.inFrameRate) {
            mi = new MenuItem(this.inFrameRate + " fps");
            this.rateMenu.add(mi);
            mi.addActionListener(rateSelect);
        }
        this.ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    MonitorAdapter.this.rateMenu.show(MonitorAdapter.this.visualComponent, me.getX(), me.getY());
                }
            }

            public void mousePressed(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    MonitorAdapter.this.rateMenu.show(MonitorAdapter.this.visualComponent, me.getX(), me.getY());
                }
            }

            public void mouseReleased(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    MonitorAdapter.this.rateMenu.show(MonitorAdapter.this.visualComponent, me.getX(), me.getY());
                }
            }
        };
        visual.addMouseListener(this.ml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.cc == null) {
            return;
        }
        this.loopThread.kill();
        CircularBuffer circularBuffer = this.bufferQ;
        synchronized (circularBuffer) {
            this.closed = true;
            this.bufferQ.notifyAll();
        }
        this.cc.close();
        this.cc = null;
    }

    private Object copyData(Object in) {
        if (in instanceof byte[]) {
            byte[] out = new byte[((byte[])in).length];
            System.arraycopy(in, 0, out, 0, out.length);
            return out;
        }
        if (in instanceof short[]) {
            short[] out = new short[((short[])in).length];
            System.arraycopy(in, 0, out, 0, out.length);
            return out;
        }
        if (in instanceof int[]) {
            int[] out = new int[((int[])in).length];
            System.arraycopy(in, 0, out, 0, out.length);
            return out;
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doProcess() {
        Buffer buffer;
        CircularBuffer circularBuffer = this.bufferQ;
        synchronized (circularBuffer) {
            while (!this.bufferQ.canRead() && this.enabled && !this.closed) {
                try {
                    this.bufferQ.wait();
                }
                catch (Exception e) {}
            }
            if (this.closed) {
                return false;
            }
            if (!this.enabled) {
                return true;
            }
            buffer = this.bufferQ.read();
        }
        boolean toDisplay = false;
        if (buffer.getFormat() instanceof AudioFormat) {
            toDisplay = true;
        } else {
            long time = buffer.getTimeStamp();
            if (time >= this.lastPreviewTime + this.previewInterval || time <= this.lastPreviewTime) {
                if (mpegVideo.matches(this.format)) {
                    int offset;
                    byte[] payload = (byte[])buffer.getData();
                    int ptype = payload[(offset = buffer.getOffset()) + 2] & 7;
                    if (ptype == 1) {
                        this.lastPreviewTime = time;
                        toDisplay = true;
                    }
                } else {
                    this.lastPreviewTime = time;
                    toDisplay = true;
                }
            } else {
                toDisplay = false;
            }
        }
        this.cc.process(buffer, toDisplay);
        CircularBuffer circularBuffer2 = this.bufferQ;
        synchronized (circularBuffer2) {
            this.bufferQ.readReport();
            this.bufferQ.notifyAll();
        }
        return true;
    }

    public void finalize() {
        if (this.visualComponent != null) {
            this.visualComponent.remove(this.rateMenu);
            this.visualComponent.removeMouseListener(this.ml);
        }
    }

    public Component getControlComponent() {
        Panel controlPanel;
        if (this.controlComponent != null) {
            return this.controlComponent;
        }
        if (this.cc == null && !this.open()) {
            return null;
        }
        this.controlComponent = this.cc.getControlComponent();
        if (this.format instanceof AudioFormat && this.controlComponent != null) {
            controlPanel = new Panel();
            controlPanel.setLayout(new BorderLayout());
            this.cbEnabled = new Checkbox("Monitor Audio");
            controlPanel.add("West", this.cbEnabled);
            controlPanel.add("Center", this.controlComponent);
            this.controlComponent = controlPanel;
            controlPanel.setBackground(Color.lightGray);
        }
        if (this.format instanceof VideoFormat && this.controlComponent != null) {
            controlPanel = new Panel();
            controlPanel.setLayout(new BorderLayout());
            this.cbEnabled = new Checkbox("Monitor Video");
            controlPanel.add("South", this.cbEnabled);
            controlPanel.add("Center", this.controlComponent);
            this.addPopupMenu(this.controlComponent);
            this.controlComponent = controlPanel;
            controlPanel.setBackground(Color.lightGray);
        }
        if (this.cbEnabled != null) {
            this.cbEnabled.setState(this.isEnabled());
            this.cbEnabled.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    MonitorAdapter.this.setEnabled(MonitorAdapter.this.cbEnabled.getState());
                }
            });
        }
        return this.controlComponent;
    }

    public Object getOwner() {
        return this.owner;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected boolean open() {
        try {
            if (this.format instanceof VideoFormat) {
                VideoFormat vf = (VideoFormat)this.format;
                this.cc = new VideoCodecChain(vf);
                this.inFrameRate = vf.getFrameRate();
                if (this.inFrameRate < 0.0f) {
                    this.inFrameRate = 30.0f;
                }
                this.inFrameRate = (float)((int)((double)(this.inFrameRate * 10.0f) + 0.5)) / 10.0f;
            } else if (this.format instanceof AudioFormat) {
                this.cc = new AudioCodecChain((AudioFormat)this.format);
            }
        }
        catch (UnsupportedFormatException e) {
            Log.warning("Failed to initialize the monitor control: " + e);
            return false;
        }
        if (this.cc == null) {
            return false;
        }
        this.bufferQ = new CircularBuffer(2);
        this.loopThread = new MonitorThread(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Buffer input) {
        if (input == null || this.previewFrameRate <= 0.0f || this.format == null || input.isEOM() || input.isDiscard() || (input.getFlags() & 0x200) != 0) {
            return;
        }
        if (!this.format.matches(input.getFormat())) {
            return;
        }
        Buffer buffer = null;
        CircularBuffer circularBuffer = this.bufferQ;
        synchronized (circularBuffer) {
            while (!this.bufferQ.canWrite() && this.enabled && !this.closed) {
                try {
                    this.bufferQ.wait();
                }
                catch (Exception e) {}
            }
            if (!this.enabled || this.closed) {
                return;
            }
            buffer = this.bufferQ.getEmptyBuffer();
        }
        buffer.setData(this.copyData(input.getData()));
        buffer.setFlags(input.getFlags());
        buffer.setFormat(input.getFormat());
        buffer.setSequenceNumber(input.getSequenceNumber());
        buffer.setHeader(input.getHeader());
        buffer.setLength(input.getLength());
        buffer.setOffset(input.getOffset());
        buffer.setTimeStamp(input.getTimeStamp());
        circularBuffer = this.bufferQ;
        synchronized (circularBuffer) {
            this.bufferQ.writeReport();
            this.bufferQ.notifyAll();
        }
    }

    public void reset() {
        if (this.cc != null) {
            this.cc.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setEnabled(boolean on) {
        if (on) {
            if (this.cc == null) {
                if (!this.open()) {
                    return false;
                }
            } else {
                this.cc.reset();
            }
            if (!this.cc.prefetch()) {
                return false;
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (this.bufferQ.canRead()) {
                    this.bufferQ.read();
                    this.bufferQ.readReport();
                }
            }
            this.enabled = true;
            this.loopThread.start();
        } else if (!on && this.cc != null) {
            this.loopThread.pause();
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.enabled = false;
                this.bufferQ.notifyAll();
            }
            this.cc.deallocate();
        }
        return this.enabled;
    }

    public float setPreviewFrameRate(float value) {
        if (value > this.inFrameRate) {
            value = this.inFrameRate;
        }
        this.previewFrameRate = value;
        this.previewInterval = (long)(1.0E9 / (double)value);
        return value;
    }
}

