/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.InfoRetreiver;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.Logger;

public class OperationSetServerStoredContactInfoJabberImpl
implements OperationSetServerStoredContactInfo {
    private static final Logger logger = Logger.getLogger(OperationSetServerStoredContactInfoJabberImpl.class);
    private InfoRetreiver infoRetreiver = null;
    private Hashtable<String, List<OperationSetServerStoredContactInfo.DetailsResponseListener>> listenersForDetails = new Hashtable();

    protected OperationSetServerStoredContactInfoJabberImpl(InfoRetreiver infoRetreiver) {
        this.infoRetreiver = infoRetreiver;
    }

    InfoRetreiver getInfoRetriever() {
        return this.infoRetreiver;
    }

    public <T extends ServerStoredDetails.GenericDetail> Iterator<T> getDetailsAndDescendants(Contact contact, Class<T> detailClass) {
        List<ServerStoredDetails.GenericDetail> details = this.infoRetreiver.getContactDetails(contact.getAddress());
        LinkedList<ServerStoredDetails.GenericDetail> result = new LinkedList<ServerStoredDetails.GenericDetail>();
        if (details == null) {
            return result.iterator();
        }
        for (ServerStoredDetails.GenericDetail item : details) {
            if (!detailClass.isInstance(item)) continue;
            ServerStoredDetails.GenericDetail t = item;
            result.add(t);
        }
        return result.iterator();
    }

    public Iterator<ServerStoredDetails.GenericDetail> getDetails(Contact contact, Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        List<ServerStoredDetails.GenericDetail> details = this.infoRetreiver.getContactDetails(contact.getAddress());
        LinkedList<ServerStoredDetails.GenericDetail> result = new LinkedList<ServerStoredDetails.GenericDetail>();
        if (details == null) {
            return result.iterator();
        }
        for (ServerStoredDetails.GenericDetail item : details) {
            if (!detailClass.equals(item.getClass())) continue;
            result.add(item);
        }
        return result.iterator();
    }

    public Iterator<ServerStoredDetails.GenericDetail> getAllDetailsForContact(Contact contact) {
        List<ServerStoredDetails.GenericDetail> details = this.infoRetreiver.getContactDetails(contact.getAddress());
        if (details == null) {
            return new LinkedList().iterator();
        }
        return new LinkedList<ServerStoredDetails.GenericDetail>(details).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator<ServerStoredDetails.GenericDetail> requestAllDetailsForContact(final Contact contact, OperationSetServerStoredContactInfo.DetailsResponseListener listener) {
        List<ServerStoredDetails.GenericDetail> res = this.infoRetreiver.getCachedContactDetails(contact.getAddress());
        if (res != null) {
            return res.iterator();
        }
        Hashtable<String, List<OperationSetServerStoredContactInfo.DetailsResponseListener>> hashtable = this.listenersForDetails;
        synchronized (hashtable) {
            List<OperationSetServerStoredContactInfo.DetailsResponseListener> ls = this.listenersForDetails.get(contact.getAddress());
            boolean isFirst = false;
            if (ls == null) {
                ls = new ArrayList<OperationSetServerStoredContactInfo.DetailsResponseListener>();
                isFirst = true;
                this.listenersForDetails.put(contact.getAddress(), ls);
            }
            if (!ls.contains(listener)) {
                ls.add(listener);
            }
            if (!isFirst) {
                return null;
            }
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List listeners;
                List<ServerStoredDetails.GenericDetail> result = OperationSetServerStoredContactInfoJabberImpl.this.infoRetreiver.retrieveDetails(contact.getAddress());
                Hashtable hashtable = OperationSetServerStoredContactInfoJabberImpl.this.listenersForDetails;
                synchronized (hashtable) {
                    listeners = (List)OperationSetServerStoredContactInfoJabberImpl.this.listenersForDetails.remove(contact.getAddress());
                }
                if (listeners == null || result == null) {
                    return;
                }
                for (OperationSetServerStoredContactInfo.DetailsResponseListener l : listeners) {
                    try {
                        l.detailsRetrieved(result.iterator());
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Error delivering for retrieved details", t);
                    }
                }
            }
        }, String.valueOf(this.getClass().getName()) + ".RetrieveDetails").start();
        return null;
    }
}

