/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class CsvOutputStream
extends OutputStream {
    private final PrintStream ostream;
    private boolean firstCellInRow = true;

    public CsvOutputStream(OutputStream ostream) {
        this.ostream = new PrintStream(ostream);
    }

    public void write(int writeme) throws IOException {
        this.ostream.write(writeme);
    }

    public CsvOutputStream headers(String ... headers) {
        for (String header : headers) {
            this.cell(header, new Object[0]);
        }
        this.newRow();
        return this;
    }

    public CsvOutputStream newRow() {
        this.ostream.println();
        this.firstCellInRow = true;
        return this;
    }

    public CsvOutputStream cell(String format, Object ... objects) {
        if (!this.firstCellInRow) {
            this.ostream.print(",");
        } else {
            this.firstCellInRow = false;
        }
        String cell = objects.length > 0 ? String.format(format, objects) : format;
        cell = cell.replace("\"", "");
        if (cell.indexOf(44) != -1) {
            cell = String.format("\"%s\"", cell);
        }
        this.ostream.print(cell);
        return this;
    }
}

