/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flap;

import java.io.IOException;
import java.net.Socket;
import net.kano.joscar.flap.AsynchronousFlapProcessor;
import net.kano.joscar.flap.FlapProcessor;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.net.ClientConn;
import net.kano.joscar.net.ClientConnEvent;
import net.kano.joscar.net.ClientConnListener;
import net.kano.joscar.net.ClientConnStreamHandler;
import net.kano.joscar.net.ConnDescriptor;

public class ClientFlapConn
extends ClientConn {
    private AsynchronousFlapProcessor flapProcessor;

    public ClientFlapConn(ConnDescriptor cd) {
        super(cd);
        this.init();
    }

    private final void init() {
        this.flapProcessor = new AsynchronousFlapProcessor();
        this.setStreamHandler(new ClientConnStreamHandler(){

            public void handleStream(ClientConn conn, Socket socket) throws IOException {
                ClientFlapConn.this.flapProcessor.runFlapLoop();
            }
        });
        this.addConnListener(new ClientConnListener(){

            public void stateChanged(ClientConnEvent e) {
                ClientConn.State newState = e.getNewState();
                if (newState == ClientConn.STATE_CONNECTED) {
                    LoggingSystem.getLogger(ClientFlapConn.class.getName()).logFine(newState.toString());
                    try {
                        if (ClientFlapConn.this.flapProcessor == null) {
                            ClientFlapConn.this.flapProcessor = new AsynchronousFlapProcessor();
                        }
                        ClientFlapConn.this.flapProcessor.attachToSocket(ClientFlapConn.this.getSocket());
                    }
                    catch (IOException e1) {
                        ClientFlapConn.this.processError(e1);
                        return;
                    }
                } else if (newState == ClientConn.STATE_NOT_CONNECTED || newState == ClientConn.STATE_FAILED) {
                    LoggingSystem.getLogger(ClientFlapConn.class.getName()).logFine(newState.toString());
                    ClientFlapConn.this.flapProcessor.breakdown();
                    ClientFlapConn.this.flapProcessor = null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            LoggingSystem.getLogger(ClientFlapConn.class.getName()).logFine("finalize()");
        }
        finally {
            super.finalize();
        }
    }

    public final FlapProcessor getFlapProcessor() {
        return this.flapProcessor;
    }

    public String toString() {
        return "ClientFlapConn: flapProcessor=" + this.flapProcessor;
    }
}

